/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovyjarjarasm.asm.Opcodes;
import java.lang.annotation.Retention;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class DelegateASTTransformation
extends AbstractASTTransformation
implements ASTTransformation,
Opcodes {
    private static final Class MY_CLASS = Delegate.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode DEPRECATED_TYPE = ClassHelper.make(Deprecated.class);
    private static final ClassNode GROOVYOBJECT_TYPE = ClassHelper.make(GroovyObject.class);
    private static final String MEMBER_DEPRECATED = "deprecated";
    private static final String MEMBER_INTERFACES = "interfaces";
    private static final String MEMBER_INCLUDES = "includes";
    private static final String MEMBER_EXCLUDES = "excludes";
    private static final String MEMBER_PARAMETER_ANNOTATIONS = "parameterAnnotations";
    private static final String MEMBER_METHOD_ANNOTATIONS = "methodAnnotations";

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (parent instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)parent;
            ClassNode type = fieldNode.getType();
            ClassNode owner = fieldNode.getOwner();
            if (type.equals(ClassHelper.OBJECT_TYPE) || type.equals(GROOVYOBJECT_TYPE)) {
                this.addError(MY_TYPE_NAME + " field '" + fieldNode.getName() + "' has an inappropriate type: " + type.getName() + ". Please add an explicit type but not java.lang.Object or groovy.lang.GroovyObject.", parent);
                return;
            }
            if (type.equals(owner)) {
                this.addError(MY_TYPE_NAME + " field '" + fieldNode.getName() + "' has an inappropriate type: " + type.getName() + ". Delegation to own type not supported. Please use a different type.", parent);
                return;
            }
            List<MethodNode> fieldMethods = this.getAllMethods(type);
            for (ClassNode next : type.getAllInterfaces()) {
                fieldMethods.addAll(this.getAllMethods(next));
            }
            boolean skipInterfaces = this.hasBooleanValue(node.getMember(MEMBER_INTERFACES), false);
            boolean includeDeprecated = this.hasBooleanValue(node.getMember(MEMBER_DEPRECATED), true) || type.isInterface() && !skipInterfaces;
            List<String> excludes = this.getMemberList(node, MEMBER_EXCLUDES);
            List<String> includes = this.getMemberList(node, MEMBER_INCLUDES);
            this.checkIncludeExclude(node, excludes, includes, MY_TYPE_NAME);
            List<MethodNode> ownerMethods = this.getAllMethods(owner);
            for (MethodNode mn : fieldMethods) {
                this.addDelegateMethod(node, fieldNode, owner, ownerMethods, mn, includeDeprecated, includes, excludes);
            }
            for (PropertyNode prop : this.getAllProperties(type)) {
                if (prop.isStatic() || !prop.isPublic()) continue;
                String name = prop.getName();
                this.addGetterIfNeeded(fieldNode, owner, prop, name);
                this.addSetterIfNeeded(fieldNode, owner, prop, name);
            }
            if (skipInterfaces) {
                return;
            }
            Set<ClassNode> allInterfaces = this.getInterfacesAndSuperInterfaces(type);
            Set<ClassNode> ownerIfaces = owner.getAllInterfaces();
            for (ClassNode iface : allInterfaces) {
                if (!Modifier.isPublic(iface.getModifiers()) || ownerIfaces.contains(iface)) continue;
                ClassNode[] ifaces = owner.getInterfaces();
                ClassNode[] newIfaces = new ClassNode[ifaces.length + 1];
                System.arraycopy(ifaces, 0, newIfaces, 0, ifaces.length);
                newIfaces[ifaces.length] = iface;
                owner.setInterfaces(newIfaces);
            }
        }
    }

    private Set<ClassNode> getInterfacesAndSuperInterfaces(ClassNode type) {
        HashSet<ClassNode> res = new HashSet<ClassNode>();
        if (type.isInterface()) {
            res.add(type);
            return res;
        }
        for (ClassNode next = type; next != null; next = next.getSuperClass()) {
            Collections.addAll(res, next.getInterfaces());
        }
        return res;
    }

    private List<MethodNode> getAllMethods(ClassNode type) {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        for (ClassNode node = type; node != null; node = node.getSuperClass()) {
            result.addAll(node.getMethods());
        }
        return result;
    }

    private List<PropertyNode> getAllProperties(ClassNode type) {
        ArrayList<PropertyNode> result = new ArrayList<PropertyNode>();
        for (ClassNode node = type; node != null; node = node.getSuperClass()) {
            result.addAll(node.getProperties());
        }
        return result;
    }

    private boolean hasBooleanValue(Expression expression, boolean bool) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).getValue().equals(bool);
    }

    private void addSetterIfNeeded(FieldNode fieldNode, ClassNode owner, PropertyNode prop, String name) {
        String setterName = "set" + Verifier.capitalize(name);
        if ((prop.getModifiers() & 0x10) == 0 && owner.getSetterMethod(setterName) == null) {
            owner.addMethod(setterName, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(DelegateASTTransformation.nonGeneric(prop.getType()), "value")}, null, new ExpressionStatement(new BinaryExpression(new PropertyExpression((Expression)new VariableExpression(fieldNode), name), Token.newSymbol(100, -1, -1), new VariableExpression("value"))));
        }
    }

    private void addGetterIfNeeded(FieldNode fieldNode, ClassNode owner, PropertyNode prop, String name) {
        String getterName = "get" + Verifier.capitalize(name);
        if (owner.getGetterMethod(getterName) == null) {
            owner.addMethod(getterName, 1, DelegateASTTransformation.nonGeneric(prop.getType()), Parameter.EMPTY_ARRAY, null, new ReturnStatement(new PropertyExpression((Expression)new VariableExpression(fieldNode), name)));
        }
    }

    private void addDelegateMethod(AnnotationNode node, FieldNode fieldNode, ClassNode owner, List<MethodNode> ownMethods, MethodNode candidate, boolean includeDeprecated, List<String> includes, List<String> excludes) {
        if (!candidate.isPublic() || candidate.isStatic() || 0 != (candidate.getModifiers() & 0x1000)) {
            return;
        }
        if (!candidate.getAnnotations(DEPRECATED_TYPE).isEmpty() && !includeDeprecated) {
            return;
        }
        if (DelegateASTTransformation.shouldSkip(candidate.getName(), excludes, includes)) {
            return;
        }
        this.checkIncludeExclude(node, excludes, includes, MY_TYPE_NAME);
        for (MethodNode mn : GROOVYOBJECT_TYPE.getMethods()) {
            if (!mn.getTypeDescriptor().equals(candidate.getTypeDescriptor())) continue;
            return;
        }
        for (MethodNode mn : owner.getMethods()) {
            if (!mn.getTypeDescriptor().equals(candidate.getTypeDescriptor())) continue;
            return;
        }
        MethodNode existingNode = null;
        for (MethodNode mn : ownMethods) {
            if (!mn.getTypeDescriptor().equals(candidate.getTypeDescriptor()) || mn.isAbstract() || mn.isStatic()) continue;
            existingNode = mn;
            break;
        }
        if (existingNode == null || existingNode.getCode() == null) {
            boolean includeParameterAnnotations = this.hasBooleanValue(node.getMember(MEMBER_PARAMETER_ANNOTATIONS), true);
            ArgumentListExpression args = new ArgumentListExpression();
            Parameter[] params = candidate.getParameters();
            Parameter[] newParams = new Parameter[params.length];
            for (int i = 0; i < newParams.length; ++i) {
                Parameter newParam = new Parameter(DelegateASTTransformation.nonGeneric(params[i].getType()), this.getParamName(params, i, fieldNode.getName()));
                newParam.setInitialExpression(params[i].getInitialExpression());
                if (includeParameterAnnotations) {
                    newParam.addAnnotations(this.copyAnnotatedNodeAnnotations(params[i].getAnnotations(), newParam));
                }
                newParams[i] = newParam;
                args.addExpression(new VariableExpression(newParam));
            }
            MethodCallExpression mce = new MethodCallExpression((Expression)new VariableExpression(fieldNode.getName(), DelegateASTTransformation.nonGeneric(fieldNode.getOriginType())), candidate.getName(), (Expression)args);
            mce.setSourcePosition(fieldNode);
            MethodNode newMethod = owner.addMethod(candidate.getName(), candidate.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF, DelegateASTTransformation.nonGeneric(candidate.getReturnType()), newParams, candidate.getExceptions(), new ExpressionStatement(mce));
            newMethod.setGenericsTypes(candidate.getGenericsTypes());
            if (this.hasBooleanValue(node.getMember(MEMBER_METHOD_ANNOTATIONS), true)) {
                newMethod.addAnnotations(this.copyAnnotatedNodeAnnotations(candidate.getAnnotations(), newMethod));
            }
        }
    }

    private String getParamName(Parameter[] params, int i, String fieldName) {
        String name = params[i].getName();
        while (name.equals(fieldName) || this.clashesWithOtherParams(name, params, i)) {
            name = "_" + name;
        }
        return name;
    }

    private boolean clashesWithOtherParams(String name, Parameter[] params, int i) {
        for (int j = 0; j < params.length; ++j) {
            if (i == j || !params[j].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private List<AnnotationNode> copyAnnotatedNodeAnnotations(List<AnnotationNode> candidateAnnotations, AnnotatedNode annotatedNode) {
        ArrayList<AnnotationNode> delegateAnnotations = new ArrayList<AnnotationNode>();
        ClassNode retentionClassNode = ClassHelper.makeWithoutCaching(Retention.class);
        for (AnnotationNode annotation : candidateAnnotations) {
            PropertyExpression propertyExpression;
            boolean processAnnotation;
            List<AnnotationNode> annotations = annotation.getClassNode().getAnnotations(retentionClassNode);
            if (annotations.isEmpty()) continue;
            if (this.hasClosureMember(annotation)) {
                this.addError(MY_TYPE_NAME + " does not support keeping Closure annotation members.", annotation);
                continue;
            }
            AnnotationNode retentionPolicyAnnotation = annotations.get(0);
            Expression valueExpression = retentionPolicyAnnotation.getMember("value");
            if (!(valueExpression instanceof PropertyExpression) || !(processAnnotation = (propertyExpression = (PropertyExpression)valueExpression).getProperty() instanceof ConstantExpression && ("RUNTIME".equals(((ConstantExpression)propertyExpression.getProperty()).getValue()) || "CLASS".equals(((ConstantExpression)propertyExpression.getProperty()).getValue())))) continue;
            AnnotationNode newAnnotation = new AnnotationNode(annotation.getClassNode());
            for (Map.Entry<String, Expression> member : annotation.getMembers().entrySet()) {
                newAnnotation.addMember(member.getKey(), member.getValue());
            }
            newAnnotation.setSourcePosition(annotatedNode);
            delegateAnnotations.add(newAnnotation);
        }
        return delegateAnnotations;
    }

    private boolean hasClosureMember(AnnotationNode annotation) {
        Map<String, Expression> members = annotation.getMembers();
        for (Map.Entry<String, Expression> member : members.entrySet()) {
            ClassExpression classExpression;
            Class typeClass;
            if (member.getValue() instanceof ClosureExpression) {
                return true;
            }
            if (!(member.getValue() instanceof ClassExpression) || (typeClass = (classExpression = (ClassExpression)member.getValue()).getType().isResolved() ? classExpression.getType().redirect().getTypeClass() : null) == null || !GeneratedClosure.class.isAssignableFrom(typeClass)) continue;
            return true;
        }
        return false;
    }
}

