/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanRule;

public class DashRule
extends GermanRule {
    public DashRule(ResourceBundle messages) {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
    }

    public String getId() {
        return "DE_DASH";
    }

    public String getDescription() {
        return "Keine Leerzeichen in Bindestrich-Komposita (wie z.B. in 'Di\u00e4ten- Erh\u00f6hung')";
    }

    public RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        String prevToken = null;
        for (int i = 0; i < tokens.length; ++i) {
            char firstChar;
            String token = tokens[i].getToken();
            if (tokens[i].isWhitespace()) continue;
            if (prevToken != null && !prevToken.equals("-") && prevToken.indexOf("--") == -1 && prevToken.indexOf("\u2013-") == -1 && prevToken.endsWith("-") && Character.isUpperCase(firstChar = token.charAt(0))) {
                String msg = "M\u00f6glicherweise fehlt ein 'und' oder ein Komma, oder es wurde nach dem Wort ein \u00fcberfl\u00fcssiges Leerzeichen eingef\u00fcgt. Eventuell haben Sie auch versehentlich einen Bindestrich statt eines Punktes eingef\u00fcgt.";
                RuleMatch ruleMatch = new RuleMatch((Rule)this, tokens[i - 1].getStartPos(), tokens[i - 1].getStartPos() + prevToken.length() + 1, "M\u00f6glicherweise fehlt ein 'und' oder ein Komma, oder es wurde nach dem Wort ein \u00fcberfl\u00fcssiges Leerzeichen eingef\u00fcgt. Eventuell haben Sie auch versehentlich einen Bindestrich statt eines Punktes eingef\u00fcgt.");
                ruleMatch.setSuggestedReplacement(tokens[i - 1].getToken());
                ruleMatches.add(ruleMatch);
            }
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public void reset() {
    }
}

