/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2014 Thomas CORDONNIER
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external;

import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.util.Language;

import java.util.Map;

/**
 * Interface for external translation memories (MyMemory, ...) in write mode
 * 
 * @author Thomas CORDONNIER
 */
public interface IWritableExternalMemory extends IExternalMemory {

    /** 
     * Indicates that we really <b>want</b> to write 
     * (IWritableExternalMemoryProvider only ensures that we <b>can</b>) <br>
     * Called only during loading of the project or on reload of 'tm' directory:
     * if false, the two next methods will never be called at all.
     **/
    boolean isWriteMode();
    
    /** 
     * Indicates that this entry has to be written in the database <br>
     * Can be always true, or you may want to write only certain entries (for example, non-fuzzy ones). <br>
     * registerTranslation will be called after, and only in case mustWrite is true <br>
     * mustWrite should be a faster method than implementing conditions inside registerTranslation,
     * and in case of error, it must return false, since it cannot throw an exception.
     **/
    boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource);    

    /**
     * Send new translation to the provider 
     * Note: we give to the provider all necessary information, 
     * but the provider is free to use some of them or not.
     */
    void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception;
    
    /**
     * Send more than one translation in one step. Used in case of loose/reconnection <br/>
     * Default implementation always works, redefine only if you can make an optimization
     */
    default void registerTranslations(Language sLang, Language tLang, Map<SourceTextEntry,PrepareTMXEntry> entries) throws Exception {
		for (Map.Entry<SourceTextEntry,PrepareTMXEntry> me: entries.entrySet()) 
			registerTranslation(sLang, tLang, me.getValue(), me.getKey());
	}
    
}
