/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2018 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;

/**
 * Entry for cross-source search: contains links between entries
 *
 * @author Thomas Cordonnier
 */
public class CrossSourceSearchResultEntry extends OngoingSearchResultEntry {

    private Set<Integer> entries = new TreeSet<>();

    public CrossSourceSearchResultEntry(SourceTextEntry sourceEntry, TMXEntry traEntry, 
		List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        super(sourceEntry, traEntry, srcMatch, targetMatch, noteMatch);
        entries.add (sourceEntry.entryNum());
    }
	
    public void add (SourceTextEntry entry) { entries.add(entry.entryNum()); }
    
    public Set<Integer> entries() { return entries; }
}
