/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2010 Antonio Vilei
               2014 Piotr Kulik, Thomas Cordonnier
               2016 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import java.io.File;
import java.util.Date;
import java.util.List;

import org.omegat.util.TMXProp;
import org.omegat.util.OStrings;

/**
 * Storage for a search result entry coming from directory searcher
 * 
 * @author Antonio Vilei
 * @author Thomas Cordonnier
 */
public class FileSearchResultEntry extends SearchResultEntry {

    /**
     * Creates a new search result entry with properties set to given values.
     * 
     * @param fileName
     *            Name of the file the entry comes from
     * @param src
     *            Source text of the corresponding entry within the file
     * @param target
     *            Target text of the corresponding entry within the file (if the file is a bilingual format and is translated)
     * @param comment
     *            Comment text of the corresponding entry within a file (if the file is a bilingual format and is translated)
     */
    public FileSearchResultEntry(File theFile, String src, String target, String comment, List<SearchMatch> srcMatch) {
        super (srcMatch, null, null);
        m_file = theFile;
        m_src = src;
        m_target = target;
        m_comment = comment;
    }

    /**
     * In file entries, entryNum is not used. Returns DirectorySearcher.ENTRY_ORIGIN_TEXT
     */
    public int getEntryNum() {
        return DirectorySearcher.ENTRY_ORIGIN_TEXT;
    }

    /** Returns information about where this entry comes from. */
    public String getPreamble() {
        return m_file.getName() + getMoreString();
    }

    public String getFileName() {
        return m_file.getName();
    }
    
    /** Returns the source text of the corresponding entry within a project. */
    public String getSrcText() {
        return (m_src);
    }

    /** Returns the target text of the corresponding entry within a project. */
    public String getTranslation() {
        return (m_target);
    }

    public String getAuthor () {
        return "";
    }
    
    public String getRevisor () {
        return null;
    }
    
    public Date getDate () {
        return new Date (m_file.lastModified());
    }
    
    public java.util.List<org.omegat.util.TMXProp> getProperties() {
        return java.util.Collections.emptyList();
    }
    
    public String getNote() {
        return "";
    }

    public boolean equals (SearchResultEntry other) {
        return super.equals(other) && getFileName().equals (other.getFileName());
    }
    
    private File m_file;
    private String m_src, m_target, m_comment;
}
