/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2019 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 **************************************************************************/
package org.omegat.gui.editor;

import org.omegat.util.VarExpansion;
import org.omegat.core.data.SourceTextEntry;

/**
 * This class is used to expand variables from paragraph marker, 
 * taking data from current SourceTextEntry and its key
 * 
 * @author Thomas CORDONNIER
 */
public class ParagraphMarkerVarExpansion extends VarExpansion<SourceTextEntry> {
    
    // ------------------------------ definitions -------------------
    
    public static final String VAR_ENTRY_NUM = "${entryNum}";    
    public static final String VAR_ENTRY_KEY_ID = "${entryKeyID}";    
    public static final String VAR_ENTRY_KEY_PATH = "${entryKeyPath}";    

	public static final String[] VARIABLES = { VAR_ENTRY_NUM, VAR_ENTRY_KEY_ID, VAR_ENTRY_KEY_PATH };
	
    // ------------------------------ non-static part -------------------
        
    public ParagraphMarkerVarExpansion (String template) {
        super(template);
    }

    @Override
    public String expandVariables (SourceTextEntry entry) {
        String localTemplate = this.template; // do not modify template directly, so that we can reuse for another change
        localTemplate = localTemplate.replace(VAR_ENTRY_NUM, Integer.toString(entry.entryNum()));
        localTemplate = localTemplate.replace(VAR_ENTRY_KEY_ID, entry.getKey().id == null ? "" : entry.getKey().id);
        localTemplate = localTemplate.replace(VAR_ENTRY_KEY_PATH, entry.getKey().path == null ? "" : entry.getKey().path);
		localTemplate = localTemplate.replace("\\n", "\n");
        return localTemplate;
    }
        
}
