/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2012 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.tokenizer.LuceneEnglishTokenizer;
import org.omegat.tokenizer.LuceneFrenchTokenizer;

import java.util.List;

import org.junit.Before;
import junit.framework.TestCase;

/**
 * Test for text expressions
 * 
 * @author Thomas Cordonnier
 */
public class TextExpressionReplaceTest extends TestCase {
    @Before
    public void setUp() throws Exception {
        // Set core project because target language is required
        ProjectProperties prop = new ProjectProperties(new java.io.File("."));
        Core.setProject(new RealProject(prop, null));        
    }
    
    private static final String STRING_TO_TEST = "This phrase contains word test.";
    
    public void testRegexReplace() {
        TextExpression expr = new TextExpression.RegexTextExpression("t(\\w\\w)t", false);
        List<SearchMatch> matches = expr.searchString(STRING_TO_TEST);
        assertEquals(ReplaceMatch.buildReplacedString(STRING_TO_TEST, matches, "!$1!"), "This phrase contains word !$1!.");
        
        expr = new TextExpression.RegexReplaceExpression("t(\\w\\w)t", false, "!$1!");
        matches = expr.searchString(STRING_TO_TEST);
        assertEquals(ReplaceMatch.buildReplacedString(STRING_TO_TEST, matches, "!$1!"), "This phrase contains word !es!.");        
    }
    
    public void testCaseChange() {
        TextExpression expr = TextExpression.RegexReplaceExpression.exactStringExpression("test", false, "\\U$0");
        List<SearchMatch> matches = expr.searchString(STRING_TO_TEST);
        assertEquals(ReplaceMatch.buildReplacedString(STRING_TO_TEST, matches, "zzz"), "This phrase contains word TEST.");        
        
        expr = TextExpression.RegexReplaceExpression.exactStringExpression("test", false, "\\u$0");
        matches = expr.searchString(STRING_TO_TEST);
        assertEquals(ReplaceMatch.buildReplacedString(STRING_TO_TEST, matches, "zzz"), "This phrase contains word Test.");        
    }
    
    public void testSimpleExpressionVariables() {
        TextExpression expr = TextExpression.RegexReplaceExpression.exactStringExpression("test", false, "\\U$1");
        List<SearchMatch> matches = expr.searchString(STRING_TO_TEST);
        assertEquals(ReplaceMatch.buildReplacedString(STRING_TO_TEST, matches, "zzz"), "This phrase contains word TEST.");        
    }
}
