/* 
 * @Purpose:	Export the whole project to XLF file for other CAT tools
 * @author:	Kos Ivantsov
 * @date:	2014-01-16
 * @version:	0.6
 * 
 */
 
/* set to true to write a settings file for Okapi Rainbow that can be
 * used to convert the XLF file produced by this script, to TMX.
 * Otherwise set to false	*/
def rainbow = true

/* set to true to output only approved entries from XLF to TMX during
 * conversion in Rainbow	*/ 
def get_only_approved = true

import static javax.swing.JOptionPane.*
import static org.omegat.util.Platform.*
import org.omegat.util.StaticUtils

def prop = project.projectProperties
if (!prop) {
    final def title = 'Export project to XLIFF file(s)'
    final def msg   = 'Please try again after you open a project.'
    showMessageDialog null, msg, title, INFORMATION_MESSAGE
    return
}
def folder = prop.projectRoot+'script_output/'
projname = new File(prop.getProjectRoot()).getName()
xliff_file = new File(folder + projname +'.xlf')
// create folder if it doesn't exist
if (! (new File (folder)).exists()) {
    (new File(folder)).mkdir()
    }
count = 0
ignorecount = 0
transcount = 0
writecount = 0

def sourceLocale = prop.getSourceLanguage().toString().toLowerCase()
def targetLocale = prop.getTargetLanguage().toString().toLowerCase()
xliff_file.write("""<?xml version="1.0" encoding="UTF-8"?>
<xliff xmlns="urn:oasis:names:tc:xliff:document:1.2" version="1.2">
""", 'UTF-8')
 
files = project.projectFiles
    for (i in 0 ..< files.size())
    {
        fi = files[i]
        xliff_file.append("""  <file original="$fi.filePath" source-language="$sourceLocale" target-language="$targetLocale" datatype="x-application/x-tmx+xml">
    <body>
      <trans-unit id="0" approved="yes">
        <source xml:lang="$sourceLocale"><ph id="filename">==FILENAME: "$fi.filePath"==</ph>
        </source>
        <target xml:lang="$targetLocale" state="final"><ph id="filename">==FILENAME: "$fi.filePath"==</ph>
        </target>
      </trans-unit>
""", 'UTF-8')
        for (j in 0 ..< fi.entries.size())
        {
            def state
            def approved = ''
            def unitnote = ''
            def ignore = ''
            ste = fi.entries[j]
            seg_num = ste.entryNum()
            source = ste.getSrcText()
            info = project.getTranslationInfo(ste)
            target = info ? info.translation : null
            if (target == null){
            state = 'state="needs-translation"'
            target = "$source"
            }else{
            approved = ' approved="yes"'
            state = 'state="final" state-qualifier="exact-match"'
            transcount++
            }
            if (target.size() == 0 ){
            target = "<EMPTY>"
            }
            if (info.hasNote()) {
            unitnote = "\n        <note>${StaticUtils.makeValidXML(info.note)}</note>"
            }
            if (source ==~ /(<\/?[a-z]+[0-9]* ?\/?>){1,5}/ ){
            ignoresource = source
            ignore = 'yes'
            }
            source = source.replaceAll(/(<)(\/?[a-z]+[0-9]* ?\/?)(>)/, /zzz$2zzz/).replaceAll(/</, /zzz#LESSTHEN#zzz/).replaceAll(/>/, /zzz#GREATERTHEN#zzz/).replaceAll(/(zzz)(\/?[a-z]+[0-9]* ?\/?)(zzz)/, /<$2>/)
            
            target = target.replaceAll(/(<)(\/?[a-z]+[0-9]* ?\/?)(>)/, /zzz$2zzz/).replaceAll(/</, /zzz#LESSTHEN#zzz/).replaceAll(/>/, /zzz#GREATERTHEN#zzz/).replaceAll(/(zzz)(\/?[a-z]+[0-9]* ?\/?)(zzz)/, /<$2>/)
            
            source = StaticUtils.makeValidXML(source).replaceAll(/&lt;/, /<ph>&lt;/).replaceAll(/&gt;/, /&gt;<\/ph>/).replaceAll(/zzz#LESSTHEN#zzz/, /&lt;/).replaceAll(/zzz#GREATERTHEN#zzz/, /&gt;/)
            
            target = StaticUtils.makeValidXML(target).replaceAll(/&lt;/, /<ph>&lt;/).replaceAll(/&gt;/, /&gt;<\/ph>/).replaceAll(/zzz#LESSTHEN#zzz/, /&lt;/).replaceAll(/zzz#GREATERTHEN#zzz/, /&gt;/)
            
            tagnumber = source.findAll(/<ph>/).size()
            if (tagnumber > 0) {
                tgnum = 0
                while (tgnum++ <= tagnumber) {
                source = source.replaceFirst(/<ph>/, "<ph id=\"$tgnum\">")
                target = target.replaceFirst(/<ph>/, "<ph id=\"$tgnum\">")
                //console.println "count: "+tagnumber+"\n"+source
                }
            }
            if (source =~ '<ph>')
            source = source.replaceAll('<ph>', '<ph id="orph"')
            
            if (target =~ '<ph>')
            target = target.replaceAll('<ph>', '<ph id="orph">')

            if (ignore != 'yes'){
            xliff_file.append("""\
      <trans-unit id="$seg_num"$approved>
        <source xml:lang="$sourceLocale">$source</source>
        <seg-source><mrk mid="0" mtype="seg">$source</mrk></seg-source>
        <target $state xml:lang="$targetLocale"><mrk mid="0" mtype="seg">$target</mrk></target>$unitnote
      </trans-unit>
""", 'UTF-8')
            writecount++
            }else{
                ignorecount++
            }
        count++
        }
        xliff_file.append("    </body>\n  </file>\n", 'UTF-8')
    }
xliff_file.append("</xliff>", 'UTF-8')
console.println """
${'*'*(xliff_file.toString().size()+12)}
Output file:   $xliff_file
${'*'*(xliff_file.toString().size()+12)}
Segments processed:	$count
Segments written:	$writecount
Segments not written:	$ignorecount
Translated segments written:	$transcount
Untranslated segments written:	${writecount-transcount}
"""
if (rainbow == true) {
    def approved
    if (get_only_approved == true){
        approved = 'true'
        }else{
            approved = 'false'
        }
    rainbowfile = new File(folder + projname +'.xlf2tmx.rnb')
    rainbowfile.write("""\
<?xml version="1.0" encoding="UTF-8"?>
<rainbowProject version="4">
    <fileSet id="1">
        <root useCustom="0"></root>
    </fileSet>
    <fileSet id="2">
        <root useCustom="0"></root>
    </fileSet>
    <fileSet id="3">
        <root useCustom="0"></root>
    </fileSet>
    <output>
        <root use="0"></root>
        <subFolder use="0"></subFolder>
        <extension use="1" style="0">.out</extension>
        <replace use="0" oldText="" newText=""></replace>
        <prefix use="0"></prefix>
        <suffix use="0"></suffix>
    </output>
    <options sourceLanguage="$sourceLocale" sourceEncoding="UTF-8" targetLanguage="$targetLocale" targetEncoding="UTF-8"></options>
    <parametersFolder useCustom="0"></parametersFolder>
    <utilities xml:spaces="preserve"><params id="currentProjectPipeline">&lt;?xml version="1.0" encoding="UTF-8"?>
&lt;rainbowPipeline version="1">&lt;step class="net.sf.okapi.steps.common.RawDocumentToFilterEventsStep">&lt;/step>
&lt;step class="net.sf.okapi.steps.codesremoval.CodesRemovalStep">#v1
stripSource.b=true
stripTarget.b=true
mode.i=0
includeNonTranslatable.b=true
replaceWithSpace.b=false&lt;/step>
&lt;step class="net.sf.okapi.steps.formatconversion.FormatConversionStep">#v1
singleOutput.b=false
autoExtensions.b=true
targetStyle.i=0
outputPath=
outputFormat=tmx
useGenericCodes.b=false
skipEntriesWithoutText.b=true
approvedEntriesOnly.b=$approved
overwriteSameSource.b=false&lt;/step>
&lt;step class="net.sf.okapi.steps.common.FilterEventsToRawDocumentStep">&lt;/step>
&lt;/rainbowPipeline>
</params></utilities>
</rainbowProject>
""", 'UTF-8')
    }
return
