/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2015 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import java.util.List;

import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;

/**
 * Entry for pre-translation. Contrarily to replacement, we cannot store replacing parts in the search matches,
 * because they are not always related
 *
 * @author Thomas Cordonnier
 */
public class PreTranslateSearchResultEntry extends OngoingSearchResultEntry {

	/*public class Highlight extends SearchMatch {
		public boolean isError = false;
		
		public Highlight(int start, int end, boolean error) {
			super(start,end); this.isError = error;
		}
	}*/

    public PreTranslateSearchResultEntry(SourceTextEntry sourceEntry, TMXEntry traEntry, 
		List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        super(sourceEntry, traEntry, srcMatch, targetMatch, noteMatch);
    }
	
    public PreTranslateSearchResultEntry(SourceTextEntry sourceEntry, TMXEntry traEntry, 
		List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch,
		// Specific to PreTranslateSearchResultEntry
		List<SearchMatch> highlights, String pretranslatedText) {
        super(sourceEntry, traEntry, srcMatch, targetMatch, noteMatch);
		this.m_highlights = highlights;
		this.m_result = pretranslatedText;
    }
	
	/** Indicates locations which need to be highlighted in the target text. This is not necessarily where match are found **/
	public List<SearchMatch> getHighlights() { return this.m_highlights; }
	
	public String getTranslationResult() { return this.m_result; }

	void setHighlights (List<SearchMatch> highlights) {
		this.m_highlights = highlights;
	}

	void addHighlight (int start, int end, boolean error) {
		if (m_highlights == null) m_highlights = new java.util.ArrayList<>();
		m_highlights.add (new SearchMatch(start, end));
	}
	
	void setTranslationResult (String tra) { this.m_result = tra; } 
	
	private List<SearchMatch> m_highlights;	
	private String m_result; 

}
