/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2010 Antonio Vilei
               2014 Piotr Kulik, Thomas Cordonnier
               2016 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import org.omegat.core.data.SourceTextEntry;

import java.util.List;


/**
 * Storage for a search result entry coming from source file
 * 
 * @author Antonio Vilei
 * @author Thomas Cordonnier
 */
public final class SourceSearchResultEntry extends SearchResultEntry {

    /**
     * Creates a new search result entry with properties set to given values.
     * 
     * @param entry
     * @param srcMatch
     * @param targetMatch
     */
    public SourceSearchResultEntry(SourceTextEntry sourceEntry,
            List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        super(srcMatch, targetMatch, noteMatch);
        m_sourceEntry = sourceEntry;
    }
    
    /** Returns the source text of the corresponding entry within a project. */
    public String getSrcText() {
        return m_sourceEntry.getSrcText();
    }

    /** Returns the target text of the corresponding entry within a project. */
    public String getTranslation() {
        return m_sourceEntry.getSourceTranslation();
    }	

    /**
     * Returns the number stored in the source text entry
     */
    public int getEntryNum() {
        return m_sourceEntry.entryNum();
    }

    /** Returns information about where this entry comes from. */
    public String getPreamble() {
        return "" + getEntryNum() + " (source) "  + getMoreString() + ">";
    }
    
    /** Return the name of the file the entry comes from **/
    public String getFileName() {
        return m_sourceEntry.getKey().file;
    }
    
    public java.util.List<org.omegat.util.TMXProp> getProperties() {
        return java.util.Collections.emptyList();
    }
    
    public java.util.Date getDate () {
        return null;
    }	
    
    public String getAuthor () {
        return null;
    }
    
    public String getRevisor () {
        return null;
    }
    
    public String getNote() {
        return m_sourceEntry.getComment();
    }
    
    
    private SourceTextEntry m_sourceEntry;
    
}
