/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2015 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.filehooks;

import java.io.File;

import org.omegat.util.Log;
import org.omegat.util.Preferences;

/**
 * Hook to call reformatter
 * 
 * @author Thomas CORDONNIER
 */
public class ReformatterHook implements IFileHook {
	
	@Override
	public String getNativeSourceFile (String currentFile) {
		return currentFile; // this file is already native
	}
	
	@Override
	public boolean supportsPseudoTags() { 
		return true; 
	}
	
	@Override	
	public boolean isNotToCompile (String midName) { 
		return midName.toLowerCase().endsWith(".docx") && midName.contains("~$"); // prevent "compilation" of MSWord's  open file markers
	}

    private static javax.script.CompiledScript groovyReformatter = null;
	
	/** Call reformatter **/
	@Override 
	public void postCompile(File destDir, String midName) {
        try {
			File tmpDestFile = new File (destDir, midName);
            javax.script.ScriptEngine groovy = org.omegat.gui.scripting.ScriptRunner.MANAGER.getEngineByExtension("groovy");
            javax.script.SimpleBindings bindings = new javax.script.SimpleBindings();
            bindings.put("project", org.omegat.core.Core.getProject()); 
            bindings.put("console", System.console());
            bindings.put("fileName", tmpDestFile.getPath());
            System.err.println("Start reformat.groovy " + tmpDestFile.getPath());
            groovy.eval (new java.io.FileReader( Preferences.getPreferenceDefault(Preferences.SCRIPTS_DIRECTORY, System.getenv("OMEGAT_HOME") + File.separator + "scripts") + File.separator + "extra" + File.separator + "reformat.groovy"), bindings);
            System.err.println("End reformat.groovy " + tmpDestFile.getPath());
			String extension = midName.substring(midName.lastIndexOf('.'));
            File italics = new File(tmpDestFile.getPath().replace(extension, "-italic" + extension));
            if (italics.exists()) {
                File locRootDirUnf = new File (tmpDestFile.getParentFile().getParentFile(), "target-unfiltered");
                File fileUnf = new File(locRootDirUnf.getPath() + File.separator + midName); fileUnf.getParentFile().mkdirs();
                try { java.nio.file.Files.move(tmpDestFile.toPath(), fileUnf.toPath()); } 
                catch (Exception eMov) { tmpDestFile.delete(); }
                italics.renameTo(tmpDestFile);
            }
        }
        catch (Exception err) {
			err.printStackTrace();
		}				
	}
	
}
