/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2008 Alex Buloichik
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.filters2;

import java.util.List;

import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;

/**
 * Callback for parse files.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 */
public interface IParseCallback {
    /**
     * Read entry from source file
     * 
     * @param id
     *            ID in source file, or null if ID not supported by format
     * @param source
     *            source entry text
     * @param traInfo
     *            information extracted from bilingual formats, including translation and maybe comment, author, date...
     * @param path
     *            path of segment
     * @param filter
     *            filter which produces entry
     * @param protectedParts
     *            protected parts
     */
    void addEntry(String id, String path, String source, SourceTextEntry.SourceTranslationInfo traInfo, 
            IFilter filter, List<ProtectedPart> protectedParts);
			
    /**
     * Old call where translation info are in more parameters, for compatibility
     */
    default void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, String path,
            IFilter filter, List<ProtectedPart> protectedParts) {
		addEntry (id, path, source, 
			(translation == null && comment == null) ? null : new SourceTextEntry.SourceTranslationInfo (translation, comment, isFuzzy),
			filter, protectedParts);
	}

    /**
     * Old call without path nor protected parts, for compatibility 
     */
    default void addEntry(String id, String source, String translation, boolean isFuzzy, String comment,  IFilter filter) {
		addEntry (id, null, source, 
			(translation == null && comment == null) ? null : new SourceTextEntry.SourceTranslationInfo (translation, comment, isFuzzy),
			filter, null);
	}

    /**
     * This method can be called from any filter on the end of file processing. It links prev/next segments
     * for multiple translations.
     */
    void linkPrevNextSegments();
}
