/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.awt.Font;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IEditorEventListener;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.util.Log;

public class CoreEvents {
    private static final List<IProjectEventListener> projectEventListeners = new CopyOnWriteArrayList<IProjectEventListener>();
    private static final List<IApplicationEventListener> applicationEventListeners = new CopyOnWriteArrayList<IApplicationEventListener>();
    private static final List<IEntryEventListener> entryEventListeners = new CopyOnWriteArrayList<IEntryEventListener>();
    private static final List<IFontChangedEventListener> fontChangedEventListeners = new CopyOnWriteArrayList<IFontChangedEventListener>();
    private static final List<IEditorEventListener> editorEventListeners = new CopyOnWriteArrayList<IEditorEventListener>();

    public static void registerProjectChangeListener(IProjectEventListener listener) {
        projectEventListeners.add(listener);
    }

    public static void unregisterProjectChangeListener(IProjectEventListener listener) {
        projectEventListeners.remove(listener);
    }

    public static void registerApplicationEventListener(IApplicationEventListener listener) {
        applicationEventListeners.add(listener);
    }

    public static void unregisterApplicationEventListener(IApplicationEventListener listener) {
        applicationEventListeners.remove(listener);
    }

    public static void registerEntryEventListener(IEntryEventListener listener) {
        entryEventListeners.add(listener);
    }

    public static void unregisterEntryEventListener(IEntryEventListener listener) {
        entryEventListeners.remove(listener);
    }

    public static void registerFontChangedEventListener(IFontChangedEventListener listener) {
        fontChangedEventListeners.add(listener);
    }

    public static void unregisterFontChangedEventListener(IFontChangedEventListener listener) {
        fontChangedEventListeners.remove(listener);
    }

    public static void registerEditorEventListener(IEditorEventListener listener) {
        editorEventListeners.add(listener);
    }

    public static void unregisterEditorEventListener(IEditorEventListener listener) {
        editorEventListeners.remove(listener);
    }

    public static void fireProjectChange(final IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_PROJECT_CHANGE", new Object[]{eventType});
                List list = projectEventListeners;
                synchronized (list) {
                    for (IProjectEventListener listener : projectEventListeners) {
                        listener.onProjectChanged(eventType);
                    }
                }
            }
        });
    }

    public static void fireApplicationStartup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_APPLICATION_STARTUP", new Object[0]);
                for (IApplicationEventListener listener : applicationEventListeners) {
                    listener.onApplicationStartup();
                }
            }
        });
    }

    public static void fireApplicationShutdown() {
        Log.logInfoRB("LOG_INFO_EVENT_APPLICATION_SHUTDOWN", new Object[0]);
        for (IApplicationEventListener listener : applicationEventListeners) {
            listener.onApplicationShutdown();
        }
    }

    public static void fireEntryNewFile(final String activeFileName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_ENTRY_NEWFILE", activeFileName);
                for (IEntryEventListener listener : entryEventListeners) {
                    listener.onNewFile(activeFileName);
                }
            }
        });
    }

    public static void fireEntryActivated(final SourceTextEntry newEntry) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_ENTRY_ACTIVATED", new Object[0]);
                for (IEntryEventListener listener : entryEventListeners) {
                    listener.onEntryActivated(newEntry);
                }
            }
        });
    }

    public static void fireFontChanged(final Font newFont) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_FONT_CHANGED", new Object[0]);
                for (IFontChangedEventListener listener : fontChangedEventListeners) {
                    listener.onFontChanged(newFont);
                }
            }
        });
    }

    public static void fireEditorNewWord(final String newWord) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (IEditorEventListener listener : editorEventListeners) {
                    listener.onNewWord(newWord);
                }
            }
        });
    }
}

