/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import javax.swing.JCheckBoxMenuItem;
import org.omegat.core.Core;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public abstract class BaseTranslate
implements IMachineTranslation,
ActionListener {
    protected final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
    protected boolean enabled;
    private Exception permanentException = null;

    public BaseTranslate() {
        Mnemonics.setLocalizedText(this.menuItem, this.getName());
        this.menuItem.addActionListener(this);
        this.enabled = Preferences.isPreference(this.getPreferenceName());
        this.menuItem.setState(this.enabled);
        Core.getMainWindow().getMainMenu().getMachineTranslationMenu().add(this.menuItem);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
        this.menuItem.setState(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.enabled = this.menuItem.isSelected();
        Preferences.setPreference(this.getPreferenceName(), this.enabled);
    }

    @Override
    public String getTranslation(Language sLang, Language tLang, String text) throws Exception {
        if (this.permanentException != null) {
            throw this.permanentException;
        }
        if (this.enabled) {
            try {
                return this.translate(sLang, tLang, text);
            }
            catch (KeyException | LimitException ex) {
                this.permanentException = ex;
                throw ex;
            }
        }
        return null;
    }

    protected abstract String getPreferenceName();

    protected abstract String translate(Language var1, Language var2, String var3) throws Exception;

    protected String cleanSpacesAroundTags(String machineText, String sourceText) {
        String replacement;
        String searchTag;
        Matcher tag = PatternConsts.OMEGAT_TAG_SPACE.matcher(machineText);
        while (tag.find()) {
            searchTag = tag.group();
            if (sourceText.indexOf(searchTag) != -1) continue;
            replacement = searchTag.substring(0, searchTag.length() - 1);
            machineText = machineText.replace(searchTag, replacement);
        }
        tag = PatternConsts.SPACE_OMEGAT_TAG.matcher(machineText);
        while (tag.find()) {
            searchTag = tag.group();
            if (sourceText.indexOf(searchTag) != -1) continue;
            replacement = searchTag.substring(1, searchTag.length());
            machineText = machineText.replace(searchTag, replacement);
        }
        return machineText;
    }

    public void removeKeyException() {
        if (!(this.permanentException instanceof LimitException)) {
            this.permanentException = null;
        }
    }

    public static class KeyException
    extends Exception {
        public KeyException(String msg) {
            super(msg);
        }
    }

    public static class LimitException
    extends Exception {
        public LimitException(String msg) {
            super(msg);
        }
    }
}

