/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.search.TextExpression;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.Language;

public class BilingualFileMemory
implements IBrowsableMemory {
    private String name;
    private List<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>();

    public BilingualFileMemory(ProjectProperties props, File file, boolean extTmxLevel2, boolean useSlash) {
        this.name = file.getPath();
        FilterMaster master = Core.getFilterMaster();
        IParseCallback parseCallback = new IParseCallback(){

            @Override
            public void linkPrevNextSegments() {
            }

            @Override
            public void addEntry(String id, String path, String source, SourceTextEntry.SourceTranslationInfo traInfo, IFilter filter, List<ProtectedPart> protectedParts) {
                if (traInfo == null) {
                    return;
                }
                if (!traInfo.isTranslated()) {
                    return;
                }
                BilingualFileMemory.this.entries.add(traInfo.asPrepareEntry(source));
            }
        };
        try {
            master.loadFile(this.name, new FilterContext(Core.getProject().getProjectProperties()), parseCallback);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    @Override
    public String getProviderName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1) + " file";
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) {
        return this.entries;
    }

    @Override
    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, long dateAfter, long dateBefore) {
        return this.entries;
    }

    public List<PrepareTMXEntry> getEntries() {
        return this.entries;
    }
}

