/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class ProjectMemory
extends ProjectTMX
implements IEntryEventListener {
    private IExternalProjectMemory memory;
    private IProject project;
    private long timeStamp = 0L;
    private long timeStamp_interval = 1000L;
    private Boolean keepOrphans = null;
    public static final long TIMESTAMP_REFRESH = -1L;

    public ProjectMemory(Language sourceLanguage, Language targetLanguage, boolean isSentenceSegmentingEnabled, File saveTmxFile, ProjectTMX.CheckOrphanedCallback callback, IProject project, File propertiesFile) throws Exception {
        super(sourceLanguage, targetLanguage, isSentenceSegmentingEnabled, saveTmxFile, callback);
        this.project = project;
        Properties config = new Properties();
        FileInputStream fis = new FileInputStream(propertiesFile);
        config.load(fis);
        fis.close();
        Class<?> memoryClass = PluginUtils.getPluginsClassLoader().loadClass(config.getProperty("class"));
        Constructor<?> cons = memoryClass.getConstructor(Properties.class);
        this.memory = (IExternalProjectMemory)cons.newInstance(config);
        try {
            this.timeStamp_interval = Long.parseLong(config.getProperty("timestamp.interval"));
            Log.log("Created project memory with timestamp interval " + this.timeStamp_interval + " milliseconds");
        }
        catch (Exception e) {
            Log.log("Created project memory with default timestamp interval (1 second)");
        }
        if (config.getProperty("project.reuse-save_tmx") != null) {
            try {
                this.timeStamp = new File(project.getProjectProperties().getProjectInternal() + "/project_save.tmx").lastModified();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (config.getProperty("distant.keep-orphans") != null) {
            this.keepOrphans = "true".equals(config.getProperty("distant.keep-orphans"));
        } else if (this.memory instanceof IConvertibleExternalProjectMemory) {
            if (project == Core.getProject()) {
                project.getTransMemories().put(OStrings.getString("CT_DISTANT_ORPHAN_STRINGS"), ((IConvertibleExternalProjectMemory)this.memory).asTranslationMemory());
            } else {
                project.getTransMemories().put(OStrings.getString("CT_DISTANT_ORPHAN_STRINGS") + " (" + targetLanguage + ")", ((IConvertibleExternalProjectMemory)this.memory).asTranslationMemory());
            }
        }
        CoreEvents.registerEntryEventListener(this);
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        try {
            Set<Integer> changes = this.refresh();
            if (changes.size() > 0) {
                Core.getEditor().commitAndDeactivate();
                Core.getEditor().refreshEntries(changes);
                Core.getEditor().activateEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not synchronize with server:\n" + e.getClass().getName() + " : " + e.getMessage(), "Error", 0);
        }
    }

    private synchronized Set<Integer> refresh() throws Exception {
        if (this.timeStamp == -1L) {
            return Collections.emptySet();
        }
        if (System.currentTimeMillis() - this.timeStamp < this.timeStamp_interval) {
            return Collections.emptySet();
        }
        this.timeStamp = -1L;
        List<SourceTextEntry> sourceEntries = Core.getProject().getAllEntries();
        HashMap<EntryKey, ContextTMXEntry> orphans = this.keepOrphans == null ? new HashMap<EntryKey, ContextTMXEntry>() : null;
        HashSet<Integer> changedSegments = new HashSet<Integer>();
        for (ContextTMXEntry contextTMXEntry : this.memory.findChanges(this.timeStamp)) {
            if (contextTMXEntry.entryNum > 0) {
                this.project.setTranslation(sourceEntries.get(contextTMXEntry.entryNum - 1), contextTMXEntry, contextTMXEntry.isDefault, contextTMXEntry.linked);
                changedSegments.add(contextTMXEntry.entryNum);
                for (SourceTextEntry dup : Core.getProject().getAllEntries().get(contextTMXEntry.entryNum - 1).getDuplicates()) {
                    changedSegments.add(dup.entryNum());
                }
                continue;
            }
            if (this.keepOrphans != null && !this.keepOrphans.booleanValue()) continue;
            EntryKey eKey = new EntryKey("unknown", contextTMXEntry.source, "unknown" + contextTMXEntry.hashCode(), "unknown", "unknown", "unknown");
            if (contextTMXEntry.otherProperties != null) {
                eKey = new EntryKey(StringUtil.nvl(contextTMXEntry.getPropValue("file"), "unknown"), contextTMXEntry.source, StringUtil.nvl(contextTMXEntry.getPropValue("id"), "unknown" + contextTMXEntry.hashCode()), StringUtil.nvl(contextTMXEntry.getPropValue("prev"), "unknown"), StringUtil.nvl(contextTMXEntry.getPropValue("next"), "unknown"), StringUtil.nvl(contextTMXEntry.getPropValue("path"), "unknown"));
            }
            if (this.keepOrphans == null) {
                if (contextTMXEntry.isDefault) {
                    orphans.put(new EntryKey(null, contextTMXEntry.source, null, null, null, null), contextTMXEntry);
                } else {
                    orphans.put(eKey, contextTMXEntry);
                }
                if (orphans.size() <= sourceEntries.size() * 2) continue;
                this.keepOrphans = false;
                continue;
            }
            if (!this.keepOrphans.booleanValue()) continue;
            this.project.setTranslation(new SourceTextEntry(eKey, -1, null, Collections.EMPTY_LIST, true), contextTMXEntry, contextTMXEntry.isDefault, contextTMXEntry.linked);
        }
        if (this.keepOrphans == null) {
            for (Map.Entry entry : orphans.entrySet()) {
                this.project.setTranslation(new SourceTextEntry((EntryKey)entry.getKey(), -1, null, Collections.EMPTY_LIST, true), (PrepareTMXEntry)entry.getValue(), ((ContextTMXEntry)entry.getValue()).isDefault, ((ContextTMXEntry)entry.getValue()).linked);
            }
            this.keepOrphans = true;
        }
        this.timeStamp = System.currentTimeMillis();
        return changedSegments;
    }

    @Override
    public void setTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) {
        super.setTranslation(ste, te, isDefault);
        if (this.timeStamp == -1L) {
            return;
        }
        try {
            if (te == null) {
                this.memory.removeTranslation(new ContextTMXEntry(ste, isDefault));
            } else {
                this.memory.registerTranslation(new ContextTMXEntry(te, ste));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface IConvertibleExternalProjectMemory
    extends IExternalProjectMemory {
        public IExternalMemory asTranslationMemory() throws Exception;
    }

    public static interface IExternalProjectMemory {
        public Iterable<ContextTMXEntry> findChanges(long var1) throws Exception;

        public void registerTranslation(ContextTMXEntry var1) throws Exception;

        public void removeTranslation(ContextTMXEntry var1) throws Exception;
    }

    public static class ContextTMXEntry
    extends PrepareTMXEntry {
        public static final long serialVersionUID = 1L;
        public int entryNum = -1;
        public boolean isDefault;
        public TMXEntry.ExternalLinked linked;

        public ContextTMXEntry() {
        }

        public ContextTMXEntry(SourceTextEntry sourceEntry, boolean isDefault) {
            this.isDefault = isDefault;
            this.entryNum = sourceEntry.entryNum();
            this.linked = null;
            this.source = sourceEntry.getSrcText();
            this.translation = null;
            this.note = null;
        }

        public ContextTMXEntry(TMXEntry tmx, SourceTextEntry sourceEntry) {
            super(tmx);
            this.isDefault = tmx.defaultTranslation;
            this.entryNum = sourceEntry.entryNum();
            this.linked = tmx.linked;
        }
    }
}

