/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.lucene.NgramAnalyzer;
import org.omegat.core.search.TextExpression;
import org.omegat.util.Language;

public class LuceneReader
implements IBrowsableMemory {
    private final NgramAnalyzer analyzer = new NgramAnalyzer();
    private IndexReader indexReader;
    private IndexSearcher searcher;
    private String name;
    private static final Pattern LITTERAL = Pattern.compile("(?<!\\\\)[^\\\\\\(\\)\\{\\}\\[\\]\\+\\-\\*]{4}");

    public LuceneReader(Properties prop) throws IOException {
        this(new File(prop.getProperty("dir")));
    }

    public LuceneReader(File indexDirectory) throws IOException {
        System.err.println("Reading Lucene : " + indexDirectory);
        if (!indexDirectory.isDirectory()) {
            indexDirectory = indexDirectory.getParentFile();
        }
        this.name = indexDirectory.getPath();
        this.indexReader = IndexReader.open((Directory)FSDirectory.open((File)indexDirectory));
        this.searcher = new IndexSearcher(this.indexReader);
        File stopFile = new File(indexDirectory, "stop");
        if (stopFile.exists()) {
            this.analyzer.loadstopNgrams(stopFile.getPath());
        }
    }

    @Override
    public String getProviderName() {
        return "Lucene";
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    private BooleanQuery buildQuery(String text, BooleanClause.Occur occur) throws IOException {
        BooleanQuery query = new BooleanQuery();
        TokenStream queryTokenStream = this.analyzer.tokenStream("src", new StringReader(text));
        TermAttribute termAtt = (TermAttribute)queryTokenStream.addAttribute(TermAttribute.class);
        queryTokenStream.reset();
        HashSet<String> terms = new HashSet<String>();
        while (queryTokenStream.incrementToken()) {
            terms.add(termAtt.term());
        }
        for (String current : terms) {
            Term t = new Term("src", current);
            query.add((Query)new TermQuery(t), occur);
        }
        queryTokenStream.end();
        queryTokenStream.close();
        return query;
    }

    @Override
    public Iterable<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        BooleanQuery query = this.buildQuery(text, BooleanClause.Occur.SHOULD);
        int minShould = query.clauses().size() * minScore / 200;
        if (minShould > 1) {
            query.setMinimumNumberShouldMatch(minShould);
        }
        return this.executeQuery(query, maxCount);
    }

    private Iterable<PrepareTMXEntry> executeQuery(BooleanQuery query, int maxCount) throws IOException {
        TopScoreDocCollector topCollector = TopScoreDocCollector.create((int)maxCount, (boolean)true);
        this.searcher.search((Query)query, (Collector)topCollector);
        final ArrayList<ScoreDoc> aList = new ArrayList<ScoreDoc>();
        for (ScoreDoc sdoc : topCollector.topDocs().scoreDocs) {
            aList.add(sdoc);
        }
        return () -> new Iterator<PrepareTMXEntry>(){
            private Iterator sdocs;
            {
                this.sdocs = aList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.sdocs.hasNext();
            }

            @Override
            public PrepareTMXEntry next() {
                try {
                    Document doc = LuceneReader.this.searcher.doc(((ScoreDoc)this.sdocs.next()).doc);
                    return LuceneReader.this.toEntry(doc);
                }
                catch (Exception cie) {
                    throw new RuntimeException(cie);
                }
            }
        };
    }

    @Override
    public Iterable<PrepareTMXEntry> getEntries() throws CorruptIndexException, IOException {
        int max1;
        for (max1 = this.indexReader.maxDoc() - 1; max1 > 0 && this.indexReader.isDeleted(max1); --max1) {
        }
        final int max = max1;
        return () -> new Iterator<PrepareTMXEntry>(){
            private int pos = 0;

            private Document nextDoc() throws CorruptIndexException, IOException {
                ++this.pos;
                if (this.pos > max) {
                    return null;
                }
                if (LuceneReader.this.indexReader.isDeleted(this.pos)) {
                    return this.nextDoc();
                }
                return LuceneReader.this.indexReader.document(this.pos);
            }

            @Override
            public PrepareTMXEntry next() {
                try {
                    return LuceneReader.this.toEntry(this.nextDoc());
                }
                catch (Exception cie) {
                    throw new RuntimeException(cie);
                }
            }

            @Override
            public boolean hasNext() {
                return this.pos < max;
            }
        };
    }

    @Override
    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, long dateAfter, long dateBefore) throws CorruptIndexException, IOException {
        if (searchSource == null) {
            return this.getEntries();
        }
        if (!andSearch && searchTarget != null) {
            return this.getEntries();
        }
        if (!andSearch && searchNotes != null) {
            return this.getEntries();
        }
        if (searchSource instanceof TextExpression.RegexTextExpression) {
            String pattern = ((TextExpression.RegexTextExpression)searchSource).getPattern().pattern();
            BooleanQuery query = new BooleanQuery();
            Matcher m = LITTERAL.matcher(pattern);
            while (m.find()) {
                query.add((Query)this.buildQuery(m.group(), BooleanClause.Occur.MUST), BooleanClause.Occur.MUST);
            }
            if (query.iterator().hasNext()) {
                return this.executeQuery(query, numberOfResults);
            }
        }
        if (searchSource instanceof TextExpression.WordsTextExpression) {
            BooleanQuery query = new BooleanQuery();
            for (TextExpression.RegexTextExpression word : ((TextExpression.WordsTextExpression)searchSource).split()) {
                String pattern = word.getPattern().pattern();
                Matcher m = LITTERAL.matcher(pattern);
                while (m.find()) {
                    query.add((Query)this.buildQuery(m.group(), BooleanClause.Occur.MUST), BooleanClause.Occur.MUST);
                }
            }
            if (query.iterator().hasNext()) {
                return this.executeQuery(query, numberOfResults);
            }
        }
        return this.getEntries();
    }

    private PrepareTMXEntry toEntry(Document doc) {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        entry.source = doc.get("src");
        entry.translation = doc.get("tra");
        entry.creator = doc.get("author");
        entry.changer = doc.get("changer");
        return entry;
    }
}

