/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.List;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.ISearchable;
import org.omegat.core.search.OngoingSearchResultEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.Searcher;
import org.omegat.core.search.SourceSearchResultEntry;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.gui.search.ProjectSearchWindow;

public class ProjectSearcher
extends Searcher {
    public static final int SEARCH_SCOPE_ONGOING = 1;
    public static final int SEARCH_SCOPE_SOURCE_FILES = 16;
    protected final IProject m_project;
    protected int m_searchLocation;
    protected boolean m_andSearch;
    protected TranslationStateFilter m_translationStateFilter;
    protected TranslationStateFilter m_sourceTranslationStateFilter;
    protected TextExpression m_searchSource;
    protected TextExpression m_searchTarget;
    protected TextExpression m_searchNotes;
    protected TextExpression m_author;
    protected TextExpression m_translator;
    protected long m_dateBefore;
    protected long m_dateAfter;

    public ProjectSearcher(ProjectSearchWindow window, IProject project, boolean removeDup, int numberOfResults, TranslationStateFilter translationStateFilter, int searchLocation, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, TextExpression translator, long dateAfter, long dateBefore) {
        super(window, removeDup, numberOfResults);
        this.m_project = project;
        this.m_translationStateFilter = translationStateFilter;
        this.m_searchLocation = searchLocation;
        this.m_searchSource = searchSource;
        this.m_searchTarget = searchTarget;
        this.m_searchNotes = searchNotes;
        this.m_andSearch = andSearch;
        this.m_author = author;
        this.m_translator = translator;
        this.m_dateBefore = dateBefore;
        this.m_dateAfter = dateAfter;
        this.m_sourceTranslationStateFilter = (searchLocation & 1) > 0 ? TranslationStateFilter.TRANSLATED_ONLY : this.m_translationStateFilter;
    }

    @Override
    protected void doSearch() {
        this.m_numFinds = 0;
        if ((this.m_searchLocation & 0x11) != 0) {
            int count = this.m_project.getAllEntries().size();
            int progress = 0;
            for (SourceTextEntry entry : this.m_project.getAllEntries()) {
                this.m_window.displayProgress("ONGOING", progress++, count, this.m_numFinds);
                if (this.m_numFinds >= this.m_maxResults) break;
                if ((this.m_searchLocation & 0x10) > 0) {
                    this.testSource(entry);
                }
                if ((this.m_searchLocation & 1) > 0) {
                    this.testOngoing(entry, true);
                }
                this.checkInterrupted();
            }
        }
    }

    protected void testSource(SourceTextEntry ste) {
        if (!this.m_sourceTranslationStateFilter.isValidEntry(ste)) {
            return;
        }
        if (this.m_author != null || this.m_dateAfter < Long.MAX_VALUE || this.m_dateBefore > Long.MIN_VALUE) {
            return;
        }
        List<SearchMatch> srcMatches = null;
        List<SearchMatch> targetMatches = null;
        List<SearchMatch> noteMatches = null;
        if (this.m_searchSource != null) {
            srcMatches = this.m_searchSource.searchString(ste.getSrcText());
        }
        if (this.m_searchTarget != null && ste.getSourceTranslation() != null) {
            targetMatches = this.m_searchTarget.searchString(ste.getSourceTranslation());
        }
        if (this.m_searchNotes != null && ste.getComment() != null) {
            noteMatches = this.m_searchNotes.searchString(ste.getComment());
        }
        if (this.checkMatches(srcMatches, targetMatches, noteMatches)) {
            this.addEntry(new SourceSearchResultEntry(ste, srcMatches, targetMatches, noteMatches));
        }
    }

    public OngoingSearchResultEntry testOngoing(SourceTextEntry ste, boolean add) {
        TMXEntry tmxEntry = this.m_project.getTranslationInfo(ste);
        if (!this.m_translationStateFilter.isValidEntry(tmxEntry)) {
            return null;
        }
        if (!this.checkFilters(tmxEntry)) {
            return null;
        }
        List<SearchMatch> srcMatches = null;
        List<SearchMatch> targetMatches = null;
        List<SearchMatch> noteMatches = null;
        if (this.m_searchSource != null) {
            srcMatches = this.m_searchSource.searchString(ste.getSrcText());
        }
        if (this.m_searchTarget != null && tmxEntry.translation != null) {
            targetMatches = this.m_searchTarget.searchString(tmxEntry.translation);
        }
        if (this.m_searchNotes != null && tmxEntry.note != null) {
            noteMatches = this.m_searchNotes.searchString(tmxEntry.note);
        }
        if (this.checkMatches(srcMatches, targetMatches, noteMatches)) {
            OngoingSearchResultEntry entry = this.buildOngoingEntry(ste, tmxEntry, srcMatches, targetMatches, noteMatches);
            if (add && entry != null) {
                this.addEntry(entry);
            }
            return entry;
        }
        return null;
    }

    protected OngoingSearchResultEntry buildOngoingEntry(SourceTextEntry ste, TMXEntry tmxEntry, List<SearchMatch> srcMatches, List<SearchMatch> targetMatches, List<SearchMatch> noteMatches) {
        return new OngoingSearchResultEntry(ste, tmxEntry, srcMatches, targetMatches, noteMatches);
    }

    protected boolean checkMatches(List<SearchMatch> srcMatches, List<SearchMatch> targetMatches, List<SearchMatch> noteMatches) {
        if (this.m_andSearch) {
            if (this.m_searchSource != null && srcMatches == null) {
                return false;
            }
            if (this.m_searchTarget != null && targetMatches == null) {
                return false;
            }
            if (this.m_searchNotes != null && noteMatches == null) {
                return false;
            }
        } else if (srcMatches == null && targetMatches == null && noteMatches == null) {
            return false;
        }
        return true;
    }

    public boolean checkFilters(PrepareTMXEntry tmxEntry) {
        if (this.m_author != null && !this.searchAuthor(tmxEntry)) {
            return false;
        }
        if (this.m_translator != null && !this.searchTranslator(tmxEntry)) {
            return false;
        }
        if (this.m_dateBefore > Long.MIN_VALUE && tmxEntry.changeDate != 0L && tmxEntry.changeDate >= this.m_dateBefore) {
            return false;
        }
        return this.m_dateAfter >= Long.MAX_VALUE || tmxEntry.changeDate == 0L || tmxEntry.changeDate > this.m_dateAfter;
    }

    public boolean checkFilters(TMXEntry tmxEntry) {
        if (this.m_author != null && !this.searchAuthor(tmxEntry)) {
            return false;
        }
        if (this.m_dateBefore > Long.MIN_VALUE && tmxEntry.changeDate != 0L && tmxEntry.changeDate >= this.m_dateBefore) {
            return false;
        }
        return this.m_dateAfter >= Long.MAX_VALUE || tmxEntry.changeDate == 0L || tmxEntry.changeDate > this.m_dateAfter;
    }

    protected boolean searchAuthor(PrepareTMXEntry te) {
        if (this.m_author == null) {
            return true;
        }
        if (te == null) {
            return false;
        }
        String author = te.changer;
        if (author == null) {
            author = te.creator;
        }
        if (author != null && this.m_author.searchString(author) != null) {
            return true;
        }
        author = te.getPropValue("Txt::Stored by");
        if (author != null) {
            return this.m_author.searchString(author) != null;
        }
        return false;
    }

    protected boolean searchAuthor(TMXEntry te) {
        if (this.m_author == null) {
            return true;
        }
        if (te == null) {
            return false;
        }
        String author = te.changer;
        if (author == null) {
            author = te.creator;
        }
        if (author != null) {
            return this.m_author.searchString(author) != null;
        }
        return false;
    }

    public TranslationStateFilter getTranslationStateFilter() {
        return this.m_translationStateFilter;
    }

    private boolean searchTranslator(PrepareTMXEntry te) {
        if (te == null) {
            return false;
        }
        if (this.m_translator == null) {
            return true;
        }
        String author = te.getPropValue("Txt::Translator");
        if (author != null) {
            return this.m_translator.searchString(author) != null;
        }
        return false;
    }

    public List<SearchMatch> searchInTranslation(String text) {
        return this.m_searchTarget == null ? null : this.m_searchTarget.searchString(text);
    }

    public List<SearchMatch> searchInSource(String text) {
        return this.m_searchSource == null ? null : this.m_searchSource.searchString(text);
    }

    public <T> Iterable<T> searchInProvider(ISearchable<T> provider) throws Exception {
        return provider.search(this.m_maxResults, this.m_searchSource, this.m_searchTarget, this.m_searchNotes, this.m_andSearch, this.m_author, this.m_dateAfter, this.m_dateBefore);
    }
}

