/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.Date;
import java.util.List;
import org.omegat.core.search.SearchMatch;
import org.omegat.util.OStrings;
import org.omegat.util.TMXProp;

public abstract class SearchResultEntry
implements Comparable<SearchResultEntry> {
    private int more = 0;
    private List<SearchMatch> m_srcMatch;
    private List<SearchMatch> m_targetMatch;
    private List<SearchMatch> m_noteMatch;

    protected SearchResultEntry(List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        this.m_srcMatch = srcMatch;
        this.m_targetMatch = targetMatch;
        this.m_noteMatch = noteMatch;
    }

    public abstract int getEntryNum();

    public abstract String getPreamble();

    public abstract String getSrcText();

    public abstract String getTranslation();

    public abstract String getNote();

    public abstract String getFileName();

    public abstract String getAuthor();

    public abstract String getRevisor();

    public abstract Date getDate();

    public abstract List<TMXProp> getProperties();

    public List<SearchMatch> getSrcMatch() {
        return this.m_srcMatch;
    }

    public List<SearchMatch> getTargetMatch() {
        return this.m_targetMatch;
    }

    public List<SearchMatch> getNoteMatch() {
        return this.m_noteMatch;
    }

    public boolean equals(SearchResultEntry entry) {
        if (!entry.getSrcText().equals(this.getSrcText())) {
            return false;
        }
        if (this.getTranslation() == null) {
            return entry.getTranslation() == null;
        }
        return this.getTranslation().equals(entry.getTranslation());
    }

    @Override
    public final int compareTo(SearchResultEntry other) {
        if (this.getEntryNum() > 0) {
            if (other.getEntryNum() > 0) {
                return this.getEntryNum() - other.getEntryNum();
            }
            return -1;
        }
        if (other.getEntryNum() > 0) {
            return 1;
        }
        return this.compareContents(other);
    }

    protected int compareContents(SearchResultEntry other) {
        int compare = this.getFileName().compareTo(other.getFileName());
        if (compare != 0) {
            return compare;
        }
        compare = this.getSrcText().compareTo(other.getSrcText());
        if (compare != 0) {
            return compare;
        }
        if (this.getTranslation() != null && other.getTranslation() != null) {
            compare = this.getTranslation().compareTo(other.getTranslation());
        }
        return 0;
    }

    void addMore() {
        ++this.more;
    }

    public final String getMoreString() {
        if (this.more == 0) {
            return "";
        }
        return "\u00a0(" + OStrings.getString("SW_NR_OF_MORE").replace("{0}", Integer.toString(this.more)) + ")";
    }
}

