/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.subtitles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.util.MixedEolHandlingReader;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class SrtFilter
extends AbstractFilter {
    protected static final Pattern PATTERN_TIME_INTERVAL = Pattern.compile("([0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3})\\s+-->\\s+([0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3})");
    protected static final String EOL = "\r\n";
    protected Map<String, String> align;
    protected String key;
    protected StringBuilder text = new StringBuilder();
    protected BufferedWriter out;

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.srt")};
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("SRTFILTER_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        String s;
        this.out = outFile;
        READ_STATE state = READ_STATE.WAIT_TIME;
        this.key = null;
        this.text.setLength(0);
        MixedEolHandlingReader reader = new MixedEolHandlingReader(inFile);
        while ((s = reader.readLine()) != null) {
            String trimmed = s.trim();
            switch (state) {
                case WAIT_TIME: {
                    if (PATTERN_TIME_INTERVAL.matcher(trimmed).matches()) {
                        state = READ_STATE.WAIT_TEXT;
                    }
                    this.key = trimmed;
                    this.text.setLength(0);
                    outFile.write(s);
                    outFile.write(EOL);
                    break;
                }
                case WAIT_TEXT: {
                    if (trimmed.isEmpty()) {
                        this.flush();
                        outFile.write(EOL);
                        state = READ_STATE.WAIT_TIME;
                    }
                    if (this.text.length() > 0) {
                        this.text.append('\n');
                    }
                    this.text.append(s);
                }
            }
        }
        reader.close();
        this.flush();
    }

    private void flush() throws IOException {
        if (this.text.length() == 0) {
            return;
        }
        if (this.align != null) {
            this.align.put(this.key, this.text.toString());
        }
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(this.key, this.text.toString(), null, false, null, null, this, null);
        } else {
            String tr = this.entryTranslateCallback.getTranslation(this.key, this.text.toString(), null);
            if (tr == null) {
                tr = this.text.toString();
            }
            this.out.write(tr.replace("\n", EOL));
            this.out.write(EOL);
        }
        this.key = null;
        this.text.setLength(0);
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }

    static enum READ_STATE {
        WAIT_TIME,
        WAIT_TEXT;

    }
}

