/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.xliff;

import java.util.zip.ZipEntry;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters4.AbstractZipFilter;
import org.omegat.filters4.xml.xliff.SdlXliff;

public class SdlProject
extends AbstractZipFilter {
    @Override
    public String getFileFormatName() {
        return "SDL project";
    }

    @Override
    protected boolean acceptEntry(ZipEntry entry, FilterContext fc) {
        return entry.getName().endsWith(".sdlxliff");
    }

    @Override
    protected boolean mustTranslateEntry(ZipEntry entry, FilterContext fc) {
        return entry.getName().startsWith(fc.getTargetLang().getLanguage()) && entry.getName().endsWith(".sdlxliff");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.sdlppx")};
    }

    @Override
    protected SdlXliff getFilter(ZipEntry ze) {
        SdlXliff xmlfilter = new SdlXliff();
        xmlfilter.setCallbacks(this.entryParseCallback, this.entryTranslateCallback);
        return xmlfilter;
    }
}

