/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.xliff;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters4.xml.xliff.Xliff1Filter;
import org.omegat.util.Preferences;

public class SdlXliff
extends Xliff1Filter {
    private String currentMid = null;
    private Map<String, StringBuffer> sdlComments = new TreeMap<String, StringBuffer>();
    private StringBuffer commentBuf = null;
    private Map<UUID, String> omegatNotes = new TreeMap<UUID, String>();
    private Map<String, UUID> defaultNoteLocations = new TreeMap<String, UUID>();
    private Map<EntryKey, UUID> altNoteLocations = new TreeMap<EntryKey, UUID>();
    private Map<String, List<XMLEvent>> tagDefs = new TreeMap<String, List<XMLEvent>>();
    private Map<String, StringBuffer> segProps = new TreeMap<String, StringBuffer>();
    private String currentProp = null;
    private Set<String> midSet = new HashSet<String>();
    private boolean has_seg_defs = false;
    public static final SimpleDateFormat TRADOS_DATE_FORMAT = new SimpleDateFormat("M/d/y H:m:s");

    @Override
    public String getFileFormatName() {
        return "SDL-Xliff";
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.sdlxliff")};
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        try {
            StartElement el = this.findEvent(inFile, Pattern.compile(".*/.*:xliff"));
            if (el == null) {
                return false;
            }
            this.namespace = el.getName().getNamespaceURI();
            if (el.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "version")) != null) {
                return true;
            }
            return super.isFileSupported(inFile, config, context);
        }
        catch (Exception npe) {
            return false;
        }
    }

    @Override
    protected boolean processStartElement(StartElement startElement, XMLEventWriter evWriter) throws XMLStreamException {
        if (startElement.getName().getLocalPart().equals("cmt-def")) {
            this.commentBuf = new StringBuffer();
            this.sdlComments.put(startElement.getAttributeByName(new QName("id")).getValue(), this.commentBuf);
            return true;
        }
        if (startElement.getName().getLocalPart().equals("mrk")) {
            if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("seg")) {
                this.currentMid = startElement.getAttributeByName(new QName("mid")).getValue();
                this.midSet.add(this.currentMid);
            } else if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-comment")) {
                String id = startElement.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "cid")).getValue();
                this.addNoteFromSource(this.currentMid, this.sdlComments.get(id).toString());
            }
        }
        if (startElement.getName().getLocalPart().equals("tag")) {
            this.currentBuffer = new LinkedList();
            this.tagDefs.put(startElement.getAttributeByName(new QName("id")).getValue(), this.currentBuffer);
        }
        if (startElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "seg"))) {
            this.segProps.clear();
            this.currentProp = null;
            this.has_seg_defs = true;
            Attribute mid = startElement.getAttributeByName(new QName("id"));
            if (mid != null) {
                this.currentMid = mid.getValue();
            }
            if (evWriter != null) {
                LinkedList<Attribute> l = new LinkedList<Attribute>();
                Iterator<Attribute> I = startElement.getAttributes();
                while (I.hasNext()) {
                    PrepareTMXEntry entry;
                    Attribute A = I.next();
                    if (!A.getName().getLocalPart().equals("conf")) {
                        l.add(A);
                        continue;
                    }
                    if (mid == null) {
                        l.add(eFactory.createAttribute("conf", A.getValue()));
                        continue;
                    }
                    String value = "Translated";
                    if (Core.getMainWindow() != null && Core.getMainWindow().getMainMenu().getRevisionMenuItem().isSelected() && (entry = this.currentEntryTranslation(mid.getValue())).getPropValue("revisor") != null) {
                        value = "ApprovedTranslation";
                    }
                    l.add(eFactory.createAttribute("conf", value));
                }
                if (mid == null) {
                    Attribute A = startElement.getAttributeByName(new QName("conf"));
                    if (A != null) {
                        l.add(A);
                    }
                } else if (this.currentEntryTranslation(mid.getValue()) != null) {
                    Attribute na = eFactory.createAttribute("conf", "Translated");
                    l.add(na);
                }
                evWriter.add(eFactory.createStartElement(startElement.getName(), l.iterator(), startElement.getNamespaces()));
                return false;
            }
        }
        if (startElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "value"))) {
            this.currentProp = startElement.getAttributeByName(new QName("key")).getValue();
            this.commentBuf = new StringBuffer();
            this.segProps.put(this.currentProp, this.commentBuf);
        }
        if (startElement.getName().getLocalPart().equals("trans-unit")) {
            this.has_seg_defs = false;
        }
        return super.processStartElement(startElement, evWriter);
    }

    @Override
    protected boolean processEndElement(EndElement endElement, XMLEventWriter evWriter) throws XMLStreamException {
        if (endElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "value"))) {
            this.commentBuf = null;
            this.currentProp = null;
        }
        if (endElement.getName().getLocalPart().equals("seg")) {
            PrepareTMXEntry entry = this.currentEntryTranslation(this.currentMid);
            this.midSet.remove(this.currentMid);
            this.currentMid = null;
            if (evWriter != null && entry != null) {
                if (this.segProps.get("last_modified_by") == null) {
                    evWriter.add(eFactory.createStartElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "value"));
                    evWriter.add(eFactory.createAttribute(new QName("key"), "last_modified_by"));
                    evWriter.add(eFactory.createCharacters(entry.changer != null ? entry.changer : Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"))));
                    evWriter.add(eFactory.createEndElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "value"));
                }
                if (this.segProps.get("modified_on") == null) {
                    evWriter.add(eFactory.createStartElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "value"));
                    evWriter.add(eFactory.createAttribute(new QName("key"), "modified_on"));
                    evWriter.add(eFactory.createCharacters(TRADOS_DATE_FORMAT.format(entry.changeDate != 0L ? new Date(entry.changeDate) : new Date())));
                    evWriter.add(eFactory.createEndElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "value"));
                }
            }
        }
        if (endElement.getName().getLocalPart().equals("trans-unit")) {
            if (evWriter != null) {
                if (this.midSet.size() > 0 && !this.has_seg_defs) {
                    evWriter.add(eFactory.createStartElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "seg-defs"));
                }
                for (String mid0 : this.midSet) {
                    evWriter.add(eFactory.createStartElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "seg"));
                    evWriter.add(eFactory.createAttribute("id", mid0));
                    PrepareTMXEntry entry = this.currentEntryTranslation(this.currentMid);
                    String value = "Translated";
                    if (Core.getMainWindow() != null && Core.getMainWindow().getMainMenu().getRevisionMenuItem().isSelected() && entry.getPropValue("revisor") != null) {
                        value = "ApprovedTranslation";
                    }
                    evWriter.add(eFactory.createAttribute("conf", value));
                    if (entry != null) {
                        evWriter.add(eFactory.createStartElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "value"));
                        evWriter.add(eFactory.createAttribute(new QName("key"), "last_modified_by"));
                        evWriter.add(eFactory.createCharacters(entry.changer != null ? entry.changer : Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"))));
                        evWriter.add(eFactory.createEndElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "value"));
                        evWriter.add(eFactory.createStartElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "value"));
                        evWriter.add(eFactory.createAttribute(new QName("key"), "modified_on"));
                        evWriter.add(eFactory.createCharacters(TRADOS_DATE_FORMAT.format(entry.changeDate != 0L ? new Date(entry.changeDate) : new Date())));
                        evWriter.add(eFactory.createEndElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "value"));
                    }
                    evWriter.add(eFactory.createEndElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "seg"));
                }
                if (this.midSet.size() > 0 && !this.has_seg_defs) {
                    evWriter.add(eFactory.createEndElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "seg-defs"));
                }
            }
            this.midSet.clear();
        }
        if (endElement.getName().getLocalPart().equals("tag")) {
            this.currentBuffer = null;
        }
        if (endElement.getName().getLocalPart().equals("cmt-def")) {
            this.commentBuf = null;
        }
        if (endElement.getName().getLocalPart().equals("cmt-defs") && evWriter != null) {
            IProject proj = Core.getProject();
            proj.iterateByDefaultTranslations((source, trans) -> {
                if (!trans.hasNote()) {
                    return;
                }
                UUID id = UUID.randomUUID();
                this.omegatNotes.put(id, trans.note);
                this.defaultNoteLocations.put(source, id);
                SdlXliff.createSdlNote(id, trans, evWriter);
            });
            proj.iterateByMultipleTranslations((key, trans) -> {
                if (!trans.hasNote()) {
                    return;
                }
                UUID id = UUID.randomUUID();
                this.omegatNotes.put(id, trans.note);
                this.altNoteLocations.put(key, id);
                SdlXliff.createSdlNote(id, trans, evWriter);
            });
        }
        if (endElement.getName().getLocalPart().equals("tag-defs") && evWriter != null) {
            for (String type : new String[]{"italic", "bold", "underline", "superscript", "subscript"}) {
                if (this.tagDefs.get("omegat-" + type) != null) continue;
                evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "tag"), null, null));
                evWriter.add(eFactory.createAttribute(new QName("id"), "omegat-" + type));
                evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "bpt"), null, null));
                evWriter.add(eFactory.createAttribute(new QName("name"), "cf"));
                evWriter.add(eFactory.createAttribute(new QName("word-end"), "false"));
                evWriter.add(eFactory.createAttribute(new QName("can-hide"), "true"));
                evWriter.add(eFactory.createCharacters("<cf " + type + "=\"true\">"));
                evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "bpt"), null));
                evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "ept"), null, null));
                evWriter.add(eFactory.createAttribute(new QName("name"), "cf"));
                evWriter.add(eFactory.createAttribute(new QName("word-end"), "false"));
                evWriter.add(eFactory.createAttribute(new QName("can-hide"), "true"));
                evWriter.add(eFactory.createCharacters("</cf>"));
                evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "ept"), null));
                evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "tag"), null));
            }
        }
        return super.processEndElement(endElement, evWriter);
    }

    @Override
    protected boolean isIngoredTag(StartElement stEl) {
        return stEl.getName().equals(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk")) && stEl.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-comment") || super.isIngoredTag(stEl);
    }

    @Override
    protected char findPrefix(StartElement stEl) {
        if (stEl.getName().getLocalPart().equals("g")) {
            try {
                String tagId = stEl.getAttributeByName(new QName("id")).getValue();
                List<XMLEvent> contents = this.tagDefs.get(tagId);
                for (XMLEvent ev : contents) {
                    String name;
                    if (ev.isCharacters()) {
                        String txt = ev.asCharacters().getData();
                        if (txt.contains("italic") && !txt.contains("bold")) {
                            return 'i';
                        }
                        if (!txt.contains("italic") && (txt.contains("bold") || txt.contains("strong"))) {
                            return 'b';
                        }
                        if (txt.contains("size")) {
                            return 's';
                        }
                        if (txt.contains("color")) {
                            return 'c';
                        }
                        if (txt.contains("footnote")) {
                            return 'n';
                        }
                        if (!txt.contains("cf")) continue;
                        return 'f';
                    }
                    if (!ev.isStartElement() || !(name = ev.asStartElement().getName().getLocalPart()).equals("bpt") && !name.equals("ept")) continue;
                    name = ev.asStartElement().getAttributeByName(new QName("name")).getValue();
                    if (name.equals("italic") || name.equals("em")) {
                        return 'i';
                    }
                    if (!name.equals("bold") && !name.equals("strong")) continue;
                    return 'b';
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.findPrefix(stEl);
    }

    @Override
    public boolean isUsingStandardNote() {
        return false;
    }

    private static void createSdlNote(UUID id, TMXEntry trans, XMLEventWriter evWriter) {
        List<Attribute> attr = Collections.singletonList(eFactory.createAttribute(new QName("id"), id.toString()));
        try {
            evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "cmt-def"), attr.iterator(), null));
            evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "Comments"), null, null));
            evWriter.add(eFactory.createStartElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "Comment"), null, null));
            evWriter.add(eFactory.createCharacters(trans.note));
            evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "Comment"), null));
            evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "Comments"), null));
            evWriter.add(eFactory.createEndElement(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "cmt-def"), null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean processCharacters(Characters event, XMLEventWriter evWriter) throws XMLStreamException {
        if (this.commentBuf != null) {
            this.commentBuf.append(event.toString());
            if (this.currentMid != null) {
                PrepareTMXEntry entry = this.currentEntryTranslation(this.currentMid);
                if (evWriter != null && entry != null) {
                    if ("last_modified_by".equals(this.currentProp)) {
                        evWriter.add(eFactory.createCharacters(entry.changer != null ? entry.changer : Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"))));
                        return false;
                    }
                    if ("modified_on".equals(this.currentProp)) {
                        evWriter.add(eFactory.createCharacters(TRADOS_DATE_FORMAT.format(entry.changeDate != 0L ? new Date(entry.changeDate) : new Date())));
                        return false;
                    }
                }
            }
        }
        return super.processCharacters(event, evWriter);
    }

    @Override
    protected List<XMLEvent> restoreTags(String unitId, String path, String src, String tra) {
        List<XMLEvent> res = super.restoreTags(unitId, path, src, tra);
        EntryKey key = new EntryKey("", src, unitId, null, null, path);
        UUID addNote = null;
        if (this.altNoteLocations.get(key) != null) {
            addNote = this.altNoteLocations.get(key);
        } else if (this.defaultNoteLocations.get(src) != null) {
            addNote = this.defaultNoteLocations.get(src);
        }
        if (addNote != null && this.omegatNotes.get(addNote) != null) {
            LinkedList<Attribute> attr = new LinkedList<Attribute>();
            attr.add(eFactory.createAttribute("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "cid", addNote.toString()));
            attr.add(eFactory.createAttribute(new QName("mtype"), "x-sdl-comment"));
            res.add(0, eFactory.createStartElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk"), attr.iterator(), null));
            res.add(eFactory.createEndElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk"), null));
        }
        return res;
    }

    @Override
    public StartElement createAddTagElement(char type, int idx) {
        List<Object> attrs = Collections.emptyList();
        switch (type) {
            case '\u2460': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-italic"));
                break;
            }
            case '\u2461': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-bold"));
                break;
            }
            case '\u2462': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-underline"));
                break;
            }
            case '\u2463': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-superscript"));
                break;
            }
            case '\u2464': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-subscript"));
            }
        }
        return eFactory.createStartElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "g"), attrs.iterator(), null);
    }

    @Override
    protected boolean isToIgnore(String src, String tra) {
        if (tra == null) {
            return false;
        }
        while (src.startsWith("<")) {
            src = src.substring(Math.max(1, src.indexOf(">") + 1));
        }
        while (tra.startsWith("<")) {
            tra = tra.substring(Math.max(1, tra.indexOf(">") + 1));
        }
        return src.length() == 0 && tra.length() == 0;
    }

    @Override
    protected SourceTextEntry.SourceTranslationInfo buildTranlsationInfo(String tra, String note) {
        long creationDate = 0L;
        long changeDate = 0L;
        StringBuffer buf = this.segProps.get("created_by");
        String creator = buf == null ? null : buf.toString();
        try {
            creationDate = TRADOS_DATE_FORMAT.parse(this.segProps.get("created_on").toString()).getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf = this.segProps.get("last_modified_by");
        String changer = buf == null ? null : buf.toString();
        try {
            changeDate = TRADOS_DATE_FORMAT.parse(this.segProps.get("modified_on").toString()).getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (creator == null) {
            creator = changer;
        }
        if (changer != null) {
            return new SourceTextEntry.SourceTranslationEntry(tra, note, false, creator, creationDate, changer, changeDate);
        }
        return super.buildTranlsationInfo(tra, note);
    }

    @Override
    protected boolean isStandardTranslationState() {
        return false;
    }
}

