/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class GlossaryConfigDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox activeSrc;
    private JCheckBox activeTra;
    private JCheckBox ignoreTags;
    private JCheckBox removeSubwords;
    private SearchModeBox modeBox;
    private JCheckBox suggest;
    private JComboBox templateList;
    private int returnStatus = 0;

    public GlossaryConfigDialog(Frame parent) {
        super(parent, true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryConfigDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.activeSrc.setSelected(Preferences.isPreference("transtips_src"));
        this.activeTra.setSelected(Preferences.isPreference("transtips_tra"));
        this.suggest.setSelected(Preferences.isPreference("transtips_suggest"));
        this.ignoreTags.setSelected(Preferences.isPreference("glossary_remove_tags"));
        this.removeSubwords.setSelected(Preferences.isPreference("glossary_remove_subwords"));
        this.templateList.setSelectedItem(ScriptItem.find(this.templateList, Preferences.getPreference("glossary_pane_template")));
        this.modeBox.loadPreferences("transtips_");
        this.invalidate();
        this.pack();
        this.setResizable(false);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.activeSrc = new JCheckBox();
        Mnemonics.setLocalizedText(this.activeSrc, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_UNDERLINE_SRC"));
        this.activeTra = new JCheckBox();
        Mnemonics.setLocalizedText(this.activeTra, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_UNDERLINE_TRA"));
        this.suggest = new JCheckBox();
        this.ignoreTags = new JCheckBox();
        this.removeSubwords = new JCheckBox();
        Mnemonics.setLocalizedText(this.ignoreTags, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_IGNORE_TAGS"));
        Mnemonics.setLocalizedText(this.removeSubwords, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_REMOVE_SUBWORDS"));
        Mnemonics.setLocalizedText(this.suggest, "Suggest translations");
        this.modeBox = new SearchModeBox(1, ITokenizer.StemmingMode.GLOSSARY, null);
        this.setTitle(OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GlossaryConfigDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        Box buttonsBox = Box.createHorizontalBox();
        this.add((Component)buttonsBox, "South");
        Box bCheck = Box.createVerticalBox();
        this.add((Component)bCheck, "North");
        Box bCheckTips = Box.createHorizontalBox();
        bCheck.add(bCheckTips);
        bCheckTips.add(this.activeSrc);
        bCheckTips.add(this.activeTra);
        Box bCheckOther = Box.createHorizontalBox();
        bCheck.add(bCheckOther);
        bCheckOther.add(this.suggest);
        bCheckOther.add(this.ignoreTags);
        bCheckOther.add(this.removeSubwords);
        Box boxTemplate = Box.createHorizontalBox();
        bCheck.add(boxTemplate);
        boxTemplate.add(new JLabel(OStrings.getString("TF_OPTIONSMENU_GLOSSARY_TEMPLATE")));
        this.templateList = new JComboBox();
        boxTemplate.add(this.templateList);
        this.templateList.addItem(new ScriptItem(OStrings.getString("TF_OPTIONSMENU_GLOSSARY_TEMPLATE_HARDCODED_DEFAULT"), "result.appendSource(entry.srcText); result.append(\": \");\ndef map = entry.translationWithComments\ndef count = map.size()\nmap.each { tra,commentsList -> \n\tresult.appendTarget(tra, entry.hasPriorities(tra));\n\tfor (com in commentsList) if ((com != null) && (com.length() > 0)) {\n\t\tresult.append(\"\\n -> \"); result.appendComment(com); \n\t}\n\tif (count-- > 1) result.append(\",\");\n}\nresult.append(\"\\n\");\n"));
        File scriptsDir = new File(Preferences.getPreferenceDefault("scripts_dir", StaticUtils.installDir() + "/scripts") + "/layout/glossary");
        if (scriptsDir.exists()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(scriptsDir.toPath());){
                for (Path p : stream) {
                    File f = p.toFile();
                    if (!f.getName().endsWith(".groovy")) continue;
                    this.templateList.addItem(new ScriptItem(f.getName(), f));
                }
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
        this.add((Component)this.modeBox, "Center");
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryConfigDialog.this.okButtonActionPerformed(evt);
            }
        });
        JPanel pButtons = new JPanel();
        this.add((Component)pButtons, "South");
        pButtons.add((Component)buttonsBox, "East");
        buttonsBox.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryConfigDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        buttonsBox.add(this.cancelButton);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.modeBox.savePreferences("transtips_");
        Preferences.setPreference("transtips_src", this.activeSrc.isSelected());
        Preferences.setPreference("transtips_tra", this.activeTra.isSelected());
        Preferences.setPreference("transtips_suggest", this.suggest.isSelected());
        Preferences.setPreference("glossary_pane_template", ((ScriptItem)this.templateList.getSelectedItem()).toOption());
        GlossaryEntry.engine = null;
        Preferences.setPreference("glossary_remove_tags", this.ignoreTags.isSelected());
        Preferences.setPreference("glossary_remove_subwords", this.removeSubwords.isSelected());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static class ScriptItem {
        String name;
        Object item;

        public ScriptItem(String name, Object item) {
            this.name = name;
            this.item = item;
        }

        public String toString() {
            return this.name;
        }

        public String toOption() {
            if (this.item instanceof File) {
                return "file:" + this.name;
            }
            return this.item.toString();
        }

        public static ScriptItem find(JComboBox items, String findName) {
            for (int i = 0; i < items.getItemCount(); ++i) {
                ScriptItem item0 = (ScriptItem)items.getItemAt(i);
                if (item0.name.equals(findName)) {
                    return item0;
                }
                if (!findName.startsWith("file:") || !item0.name.equals(findName.substring(5))) continue;
                return item0;
            }
            return (ScriptItem)items.getItemAt(0);
        }
    }
}

