/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class TeamOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JLabel authorLabel;
    private JTextField authorText;
    private JButton cancelButton;
    private JLabel descriptionLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton okButton;
    private int returnStatus = 0;

    public TeamOptionsDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.authorText.setText(Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name")));
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.authorLabel = new JLabel();
        this.authorText = new JTextField();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(OStrings.getString("GUI_TITLE_Team_Options"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TeamOptionsDialog.this.closeDialog(evt);
            }
        });
        Mnemonics.setLocalizedText(this.descriptionLabel, OStrings.getString("GUI_TEAM_DESCRIPTION"));
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.descriptionLabel, "North");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 30, 10, 30));
        this.jPanel2.setLayout(new BorderLayout());
        this.authorLabel.setLabelFor(this.authorText);
        Mnemonics.setLocalizedText(this.authorLabel, OStrings.getString("WF_OPTION_INSERT_AUTHOR_PREFIX"));
        this.jPanel2.add((Component)this.authorLabel, "West");
        this.jPanel2.add((Component)this.authorText, "Center");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TeamOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TeamOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.jPanel3.add((Component)this.jPanel1, "East");
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("team_Author", this.authorText.getText());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

