/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;
import org.omegat.core.Core;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.mark.CalcMarkersThread;
import org.omegat.gui.editor.mark.EntryMarks;
import org.omegat.gui.editor.mark.IFastMarker;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.util.Log;
import org.omegat.util.gui.UIThreadsUtil;

public class MarkerController {
    private final EditorController ec;
    private final String[] markerNames;
    protected final CalcMarkersThread[] markerThreads;
    private final Highlighter highlighter;
    private final Queue<EntryMarks> outputQueue = new LinkedList<EntryMarks>();

    MarkerController(EditorController ec) {
        this.ec = ec;
        this.highlighter = ec.editor.getHighlighter();
        ArrayList<IMarker> ms = new ArrayList<IMarker>();
        for (Class<?> mc : PluginUtils.getMarkerClasses()) {
            try {
                ms.add((IMarker)mc.newInstance());
            }
            catch (Exception ex) {
                Log.logErrorRB(ex, "PLUGIN_MARKER_INITIALIZE", mc.getName());
            }
        }
        for (IMarker marker : Core.getMarkers()) {
            ms.add(marker);
        }
        this.markerThreads = new CalcMarkersThread[ms.size()];
        this.markerNames = new String[ms.size()];
        for (int i = 0; i < ms.size(); ++i) {
            IMarker m = (IMarker)ms.get(i);
            this.markerNames[i] = m.getClass().getName();
            this.markerThreads[i] = new CalcMarkersThread(this, m, i);
            this.markerThreads[i].start();
        }
    }

    int getMarkerIndex(String markerClassName) {
        for (int i = 0; i < this.markerNames.length; ++i) {
            if (!this.markerNames[i].equals(markerClassName)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAll() {
        UIThreadsUtil.mustBeSwingThread();
        for (CalcMarkersThread th : this.markerThreads) {
            th.reset();
        }
        Queue<EntryMarks> queue = this.outputQueue;
        synchronized (queue) {
            this.outputQueue.clear();
        }
        this.highlighter.removeAllHighlights();
    }

    void remove(SegmentBuilder sb, int makerIndex) {
        UIThreadsUtil.mustBeSwingThread();
        if (sb.marks == null) {
            return;
        }
        List<MarkInfo> me = sb.marks[makerIndex];
        if (me != null) {
            for (MarkInfo info : me) {
                if (info == null || info.highlight == null) continue;
                this.highlighter.removeHighlight(info.highlight);
            }
            sb.marks[makerIndex] = null;
        }
    }

    public void reprocess(SegmentBuilder[] entryBuilders, int markerIndex) {
        UIThreadsUtil.mustBeSwingThread();
        if (entryBuilders == null) {
            return;
        }
        for (SegmentBuilder sb : entryBuilders) {
            if (!sb.hasBeenCreated()) continue;
            this.remove(sb, markerIndex);
        }
        this.markerThreads[markerIndex].add(entryBuilders);
    }

    public void reprocessImmediately(SegmentBuilder entryBuilder, DocumentEvent docEv) {
        UIThreadsUtil.mustBeSwingThread();
        entryBuilder.resetTextAttributes(docEv);
        Document3 doc = this.ec.editor.getOmDocument();
        ArrayList<EntryMarks> evs = new ArrayList<EntryMarks>();
        for (int i = 0; i < this.markerNames.length; ++i) {
            try {
                if (docEv == null) {
                    throw new ClassCastException();
                }
                IFastMarker fMark = (IFastMarker)this.markerThreads[i].marker;
                try {
                    if (entryBuilder.marks[i] == null) {
                        entryBuilder.marks[i] = new ArrayList<MarkInfo>();
                    }
                    for (MarkInfo rem : fMark.toRemove(docEv, entryBuilder.marks[i])) {
                        entryBuilder.marks[i].remove(rem);
                        if (rem.highlight == null) continue;
                        this.highlighter.removeHighlight(rem.highlight);
                    }
                    for (Mark added : fMark.toAdd(docEv)) {
                        entryBuilder.marks[i].add(new MarkInfo(added, entryBuilder, doc, this.highlighter));
                    }
                    continue;
                }
                catch (Throwable ex) {
                    Log.log(ex);
                    continue;
                }
            }
            catch (ClassCastException cce) {
                this.remove(entryBuilder, i);
                try {
                    EntryMarks ev = new EntryMarks(entryBuilder, entryBuilder.getDisplayVersion(), i);
                    ev.result = this.markerThreads[i].marker.getMarksForEntry(ev.ste, ev.sourceText, ev.translationText, ev.isActive);
                    if (ev.result == null) continue;
                    evs.add(ev);
                    continue;
                }
                catch (Throwable ex) {
                    Log.log(ex);
                }
            }
        }
        this.marksOutput(evs);
    }

    public void process(SegmentBuilder[] entryBuilders) {
        UIThreadsUtil.mustBeSwingThread();
        for (CalcMarkersThread th : this.markerThreads) {
            th.add(entryBuilders);
        }
    }

    public String getToolTips(int entryIndex, int pos) {
        UIThreadsUtil.mustBeSwingThread();
        if (entryIndex >= this.ec.m_docSegList.length || entryIndex < 0) {
            return null;
        }
        List<MarkInfo>[] m = this.ec.m_docSegList[entryIndex].marks;
        if (m == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < m.length; ++i) {
            if (m[i] == null) continue;
            for (MarkInfo t : m[i]) {
                if (t == null || t.tooltip == null || t.tooltip.p0.getOffset() > pos || t.tooltip.p1.getOffset() < pos) continue;
                if (res.length() > 0) {
                    res.append("<br>");
                }
                res.append(t.tooltip.text);
            }
        }
        if (res.length() == 0) {
            return null;
        }
        String r = res.toString();
        r = r.replace("<suggestion>", "<b>");
        r = r.replace("</suggestion>", "</b>");
        return "<html>" + r + "</html>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMarksOutput(EntryMarks ev) {
        Queue<EntryMarks> queue = this.outputQueue;
        synchronized (queue) {
            this.outputQueue.add(ev);
            this.outputQueue.notifyAll();
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<EntryMarks> evs = new ArrayList<EntryMarks>();
                Queue queue = MarkerController.this.outputQueue;
                synchronized (queue) {
                    EntryMarks ev;
                    while ((ev = (EntryMarks)MarkerController.this.outputQueue.poll()) != null) {
                        evs.add(ev);
                    }
                }
                MarkerController.this.marksOutput(evs);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marksOutput(List<EntryMarks> evs) {
        UIThreadsUtil.mustBeSwingThread();
        if (evs.isEmpty()) {
            return;
        }
        Document3 doc = this.ec.editor.getOmDocument();
        doc.trustedChangesInProgress = true;
        try {
            for (int i = 0; i < evs.size(); ++i) {
                EntryMarks ev = evs.get(i);
                if (ev.isSegmentChanged()) continue;
                this.remove(ev.builder, ev.markerIndex);
                try {
                    if (ev.builder.marks == null) {
                        ev.builder.marks = new List[this.markerNames.length];
                    }
                    ev.builder.marks[ev.markerIndex] = new ArrayList<MarkInfo>(ev.result.size());
                    for (int j = 0; j < ev.result.size(); ++j) {
                        MarkInfo nm = new MarkInfo(ev.result.get(j), ev.builder, doc, this.highlighter);
                        ev.builder.marks[ev.markerIndex].add(nm);
                    }
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        finally {
            doc.trustedChangesInProgress = false;
        }
    }

    protected static class Tooltip {
        Position p0;
        Position p1;
        String text;

        public Tooltip(Document3 doc, int start, int end, String text) throws BadLocationException {
            this.p0 = doc.createPosition(start);
            this.p1 = doc.createPosition(end);
            this.text = text;
        }
    }

    public static class MarkInfo {
        public final Highlighter.Highlight highlight;
        Tooltip tooltip;

        public MarkInfo(Mark m, SegmentBuilder sb, Document3 doc, Highlighter highlighter) throws BadLocationException {
            if (m.entryPart == Mark.ENTRY_PART.SOURCE && sb.getSourceText() == null) {
                this.highlight = null;
                return;
            }
            int sourceStartOffset = sb.getStartSourcePosition();
            int translationStartOffset = sb.isActive() ? doc.getTranslationStart() : sb.getStartTranslationPosition();
            int startOffset = m.entryPart == Mark.ENTRY_PART.SOURCE ? sourceStartOffset : translationStartOffset;
            this.highlight = m.painter != null ? (Highlighter.Highlight)highlighter.addHighlight(startOffset + m.startOffset, startOffset + m.endOffset, m.painter) : null;
            if (m.toolTipText != null) {
                this.tooltip = new Tooltip(doc, startOffset + m.startOffset, startOffset + m.endOffset, m.toolTipText);
            }
            if (m.attributes != null) {
                doc.setCharacterAttributes(startOffset + m.startOffset, m.endOffset - m.startOffset, m.attributes, false);
            }
        }
    }
}

