/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autocompleter;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import org.omegat.gui.editor.autocompleter.AbstractAutoCompleterView;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.util.StaticUtils;

public abstract class AutoCompleterTableView
extends AbstractAutoCompleterView {
    private static JTable table;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = e.getPoint();
                int r = table.rowAtPoint(p);
                int c = table.columnAtPoint(p);
                if (table.getSelectedRow() == r && table.getSelectedColumn() == c) {
                    AutoCompleterTableView.this.completer.doSelection();
                }
            }
        }
    };

    public AutoCompleterTableView(String name) {
        super(name);
        this.getTable().changeSelection(0, 0, false, false);
    }

    public void setSelection(Point p) {
        this.getTable().changeSelection(p.y, p.x, false, false);
    }

    public JTable getTable() {
        if (table == null) {
            table = new JTable();
            table.setCellSelectionEnabled(true);
            table.setFocusable(false);
            table.setTableHeader(null);
            table.addMouseListener(this.mouseAdapter);
        }
        return table;
    }

    @Override
    public Component getViewContent() {
        return this.getTable();
    }

    public Point getSelectionPoint() {
        return new Point(this.getTable().getSelectedColumn(), this.getTable().getSelectedRow());
    }

    @Override
    public boolean processKeys(KeyEvent e) {
        if (StaticUtils.isKey(e, 38, 0)) {
            this.selectPreviousPossibleValueUp();
            return true;
        }
        if (StaticUtils.isKey(e, 37, 0)) {
            this.selectPreviousPossibleValueLeft();
            return true;
        }
        if (StaticUtils.isKey(e, 40, 0)) {
            this.selectNextPossibleValueDown();
            return true;
        }
        if (StaticUtils.isKey(e, 39, 0)) {
            this.selectNextPossibleValueRight();
            return true;
        }
        if (StaticUtils.isKey(e, 33, 0)) {
            this.selectPreviousPossibleValueByPage();
            return true;
        }
        if (StaticUtils.isKey(e, 34, 0)) {
            this.selectNextPossibleValueByPage();
            return true;
        }
        if (StaticUtils.isKey(e, 36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            this.selectFirstPossibleValue();
            return true;
        }
        if (StaticUtils.isKey(e, 35, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            this.selectLastPossibleValue();
            return true;
        }
        if (StaticUtils.isKey(e, 36, 0)) {
            this.selectFirstPossibleValueInLine();
            return true;
        }
        if (StaticUtils.isKey(e, 35, 0)) {
            this.selectLastPossibleValueInLine();
            return true;
        }
        return false;
    }

    protected void selectNextPossibleValueDown() {
        Point p = this.getSelectionPoint();
        int y = (p.y + 1) % this.getTable().getModel().getRowCount();
        this.setSelection(new Point(p.x, y));
    }

    protected void selectFirstPossibleValue() {
        this.setSelection(new Point(0, 0));
    }

    protected void selectLastPossibleValue() {
        this.setSelection(new Point(this.getTable().getModel().getColumnCount() - 1, this.getTable().getModel().getRowCount() - 1));
    }

    protected void selectFirstPossibleValueInLine() {
        this.setSelection(new Point(0, this.getTable().getSelectedRow()));
    }

    protected void selectLastPossibleValueInLine() {
        this.setSelection(new Point(this.getTable().getModel().getColumnCount() - 1, this.getTable().getSelectedRow()));
    }

    protected void selectNextPossibleValueRight() {
        Point p = this.getSelectionPoint();
        int x = (p.x + 1) % this.getTable().getModel().getColumnCount();
        this.setSelection(new Point(x, p.y));
    }

    protected void selectNextPossibleValueByPage() {
        Point p = this.getSelectionPoint();
        int size = this.getTable().getModel().getRowCount();
        this.setSelection(new Point(p.x, Math.min(p.y + 10, size - 1)));
    }

    protected void selectPreviousPossibleValueUp() {
        Point p = this.getSelectionPoint();
        int size = this.getTable().getModel().getRowCount();
        int y = (p.y - 1 + size) % size;
        this.setSelection(new Point(p.x, y));
    }

    protected void selectPreviousPossibleValueLeft() {
        Point p = this.getSelectionPoint();
        int size = this.getTable().getModel().getColumnCount();
        int x = (p.x - 1 + size) % size;
        this.setSelection(new Point(x, p.y));
    }

    protected void selectPreviousPossibleValueByPage() {
        Point p = this.getSelectionPoint();
        this.setSelection(new Point(p.x, Math.max(p.y - 10, 0)));
    }

    @Override
    public int getRowCount() {
        return this.getTable().getModel().getRowCount();
    }

    @Override
    public int getPreferredHeight() {
        return this.getModifiedRowCount() * this.getTable().getRowHeight();
    }

    @Override
    public int getPreferredWidth() {
        return this.getTable().getPreferredSize().width;
    }

    @Override
    public AutoCompleterItem getSelectedValue() {
        Point p = this.getSelectionPoint();
        Object selection = this.getTable().getModel().getValueAt(p.y, p.x);
        if (selection instanceof Character) {
            return new AutoCompleterItem(selection.toString(), null, 0);
        }
        return new AutoCompleterItem((String)selection, null, 0);
    }
}

