/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.mark.IFastMarker;
import org.omegat.gui.editor.mark.Mark;

public abstract class RegexMarker
implements IFastMarker {
    protected Highlighter.HighlightPainter PAINTER;
    protected String toolTip;
    protected AttributeSet ATTRIBUTES;
    protected Pattern pattern;

    protected abstract boolean isEnabled();

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        Mark m;
        Matcher match;
        if (!this.isEnabled()) {
            return null;
        }
        ArrayList<Mark> r = new ArrayList<Mark>();
        if (isActive || Core.getEditor().getSettings().isDisplaySegmentSources() || translationText == null) {
            this.initDrawers(true, isActive);
            if (this.pattern != null) {
                match = this.pattern.matcher(sourceText);
                while (match.find()) {
                    m = new Mark(Mark.ENTRY_PART.SOURCE, match.start(), match.end());
                    m.painter = this.PAINTER;
                    m.toolTipText = this.toolTip;
                    m.attributes = this.ATTRIBUTES;
                    r.add(m);
                }
            }
        }
        if (translationText != null) {
            this.initDrawers(false, isActive);
            if (this.pattern != null) {
                match = this.pattern.matcher(translationText);
                while (match.find()) {
                    m = new Mark(Mark.ENTRY_PART.TRANSLATION, match.start(), match.end());
                    m.painter = this.PAINTER;
                    m.toolTipText = this.toolTip;
                    m.attributes = this.ATTRIBUTES;
                    r.add(m);
                }
            }
        }
        return r;
    }

    protected void initDrawers(boolean isSource, boolean isActive) {
    }

    @Override
    public List<MarkerController.MarkInfo> toRemove(DocumentEvent ev, List<MarkerController.MarkInfo> oriList) {
        if (this.pattern == null) {
            return Collections.EMPTY_LIST;
        }
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        this.initDrawers(false, true);
        ArrayList<MarkerController.MarkInfo> res = new ArrayList<MarkerController.MarkInfo>(oriList.size());
        for (MarkerController.MarkInfo ori : oriList) {
            if (ori.highlight == null || ori.highlight.getEndOffset() < ev.getOffset() || ev.getType() == DocumentEvent.EventType.INSERT && ori.highlight.getStartOffset() > ev.getOffset() + ev.getLength() || ev.getType() == DocumentEvent.EventType.REMOVE && ori.highlight.getStartOffset() > ev.getOffset()) continue;
            res.add(ori);
        }
        return res;
    }

    @Override
    public List<Mark> toAdd(DocumentEvent ev) throws Exception {
        if (this.pattern == null) {
            return Collections.EMPTY_LIST;
        }
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        this.initDrawers(false, true);
        ArrayList<Mark> res = new ArrayList<Mark>();
        Document3 doc = (Document3)ev.getDocument();
        String translationText = doc.getText(doc.getTranslationStart(), doc.getTranslationEnd() - doc.getTranslationStart());
        Matcher match = this.pattern.matcher(translationText);
        while (match.find()) {
            if (match.end() < ev.getOffset() - doc.getTranslationStart() || match.start() > ev.getOffset() + ev.getLength() - doc.getTranslationStart()) continue;
            Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, match.start(), match.end());
            m.painter = this.PAINTER;
            m.toolTipText = this.toolTip;
            m.attributes = this.ATTRIBUTES;
            res.add(m);
        }
        return res;
    }
}

