/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.Color;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.gui.scripting.ScriptingWindow;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.Styles;

public class GlossaryEntry
implements Comparable<GlossaryEntry> {
    public static ScriptEngine engine = null;
    private String m_src;
    private String[] m_loc;
    private String[] m_com;
    private boolean[] m_priority;

    public GlossaryEntry(String src, String[] loc, String[] com, boolean[] fromPriorityGlossary) {
        this.m_src = StringUtil.normalizeUnicode(src);
        this.m_loc = loc;
        this.normalize(this.m_loc);
        this.m_com = com;
        this.normalize(com);
        this.m_priority = fromPriorityGlossary;
    }

    public GlossaryEntry(String src, String loc, String com, boolean fromPriorityGlossary) {
        this(src, new String[]{loc}, new String[]{com}, new boolean[]{fromPriorityGlossary});
    }

    public String getSrcText() {
        return this.m_src;
    }

    public String getLocText() {
        return this.m_loc.length > 0 ? this.m_loc[0] : "";
    }

    public String[] getLocTerms(boolean uniqueOnly) {
        if (!uniqueOnly || this.m_loc.length == 1) {
            return this.m_loc;
        }
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < this.m_loc.length; ++i) {
            if (i > 0 && this.m_loc[i].equals(this.m_loc[i - 1])) continue;
            list.add(this.m_loc[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    public String getCommentText() {
        return this.m_com.length > 0 ? this.m_com[0] : "";
    }

    public String[] getComments() {
        return this.m_com;
    }

    public boolean getPriority() {
        if (this.m_priority == null) {
            return false;
        }
        if (this.m_priority.length == 0) {
            return false;
        }
        for (boolean prio : this.m_priority) {
            if (!prio) continue;
            return true;
        }
        return false;
    }

    public boolean[] getPriorities() {
        return this.m_priority;
    }

    private Map<String, LinkedList<String>> getTranslationWithComments() {
        TreeMap<String, LinkedList<String>> res = new TreeMap<String, LinkedList<String>>();
        for (int i = 0; i < this.m_loc.length; ++i) {
            LinkedList<String> item = (LinkedList<String>)res.get(this.m_loc[i]);
            if (item == null) {
                item = new LinkedList<String>();
                res.put(this.m_loc[i], item);
            }
            if (this.m_com[i] == null || this.m_com[i].length() <= 0) continue;
            if (this.m_priority[i]) {
                item.addFirst("\u0007" + this.m_com[i]);
                continue;
            }
            item.add(this.m_com[i]);
        }
        return res;
    }

    public StyledString toStyledString() {
        StyledString result = new StyledString();
        try {
            if (engine == null) {
                engine = new ScriptEngineManager().getEngineByName("Groovy");
                String template = Preferences.getPreferenceDefault("glossary_pane_template", "result.appendSource(entry.srcText); result.append(\": \");\ndef map = entry.translationWithComments\ndef count = map.size()\nmap.each { tra,commentsList -> \n\tresult.appendTarget(tra, entry.hasPriorities(tra));\n\tfor (com in commentsList) if ((com != null) && (com.length() > 0)) {\n\t\tresult.append(\"\\n -> \"); result.appendComment(com); \n\t}\n\tif (count-- > 1) result.append(\",\");\n}\nresult.append(\"\\n\");\n");
                if (template.startsWith("file:")) {
                    File tplFile = new File(template = template.substring(5));
                    if (!tplFile.exists()) {
                        template = Preferences.getPreferenceDefault("scripts_dir", StaticUtils.installDir() + "/scripts") + "/layout/glossary/" + template;
                        tplFile = ScriptingWindow.toJavaFile(template);
                    }
                    if (tplFile.exists()) {
                        template = new String(Files.readAllBytes(tplFile.toPath()));
                    } else {
                        engine.put("result", result);
                        engine.eval("result.appendError(\"Cannot find " + tplFile.getName().replace("\\", "\\\\") + " ; using default\\n\");");
                        template = "result.appendSource(entry.srcText); result.append(\": \");\ndef map = entry.translationWithComments\ndef count = map.size()\nmap.each { tra,commentsList -> \n\tresult.appendTarget(tra, entry.hasPriorities(tra));\n\tfor (com in commentsList) if ((com != null) && (com.length() > 0)) {\n\t\tresult.append(\"\\n -> \"); result.appendComment(com); \n\t}\n\tif (count-- > 1) result.append(\",\");\n}\nresult.append(\"\\n\");\n";
                    }
                }
                engine.eval("package org.omegat.core; public class Core {}");
                if (template.contains("sourceLang")) {
                    engine.put("sourceLang", Core.getProject().getProjectProperties().getSourceLanguage().toString());
                }
                if (template.contains("targetLang")) {
                    engine.put("targetLang", Core.getProject().getProjectProperties().getTargetLanguage().toString());
                }
                engine.eval("def format(entry,result) {\n" + template + "\n}");
            }
            engine.put("result", result);
            engine.put("entry", this);
            engine.eval("format(entry, result)");
        }
        catch (Exception e) {
            result.appendError(e.getMessage());
        }
        return result;
    }

    private static String bracketEntry(String entry) {
        if (entry.contains(",") && !entry.contains(";") && !entry.contains("\"")) {
            entry = '\"' + entry + '\"';
        }
        return entry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GlossaryEntry otherGlossaryEntry = (GlossaryEntry)o;
        return StringUtil.equalsWithNulls(this.m_src, otherGlossaryEntry.m_src) && Arrays.equals(this.m_loc, otherGlossaryEntry.m_loc) && Arrays.equals(this.m_com, otherGlossaryEntry.m_com);
    }

    public boolean hasPriorities() {
        for (boolean b : this.m_priority) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public boolean hasPriorities(String tra) {
        for (int i = 0; i < this.m_loc.length; ++i) {
            if (!this.m_loc[i].equals(tra) || !this.m_priority[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(GlossaryEntry other) {
        if (this.hasPriorities()) {
            if (!other.hasPriorities()) {
                return -1;
            }
            return this.m_src.compareTo(other.m_src);
        }
        if (other.hasPriorities()) {
            return 1;
        }
        return this.m_src.compareTo(other.m_src);
    }

    public int hashCode() {
        int hash = 98;
        hash = hash * 17 + (this.m_src == null ? 0 : this.m_src.hashCode());
        hash = hash * 31 + (this.m_loc == null ? 0 : Arrays.hashCode(this.m_loc));
        hash = hash * 13 + (this.m_com == null ? 0 : Arrays.hashCode(this.m_com));
        return hash;
    }

    private void normalize(String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = StringUtil.normalizeUnicode(strs[i]);
        }
    }

    static class StyledString {
        public StringBuilder text = new StringBuilder();
        public LinkedList<AttributesPart> attrParts = new LinkedList();
        public LinkedList<AttributesPart> attrBolds = new LinkedList();
        public LinkedList<TooltipPart> tooltips = new LinkedList();

        StyledString() {
        }

        public void markBoldStart() {
            this.attrBolds.add(new AttributesPart(this.text.length(), 0, GlossaryTextArea.PRIORITY_ATTRIBUTES));
        }

        public void markBoldEnd() {
            this.attrBolds.getLast().setEnd(this.text.length());
        }

        public void startTooltip(String tip) {
            this.tooltips.add(new TooltipPart(this.text.length(), 0, tip));
        }

        public void endTooltip() {
            this.tooltips.getLast().setEnd(this.text.length());
        }

        public StyledString append(StyledString str) {
            int off = this.text.length();
            this.text.append((CharSequence)str.text);
            for (AttributesPart attr : str.attrParts) {
                this.attrParts.add(attr.decale(off));
            }
            for (AttributesPart attr : str.attrBolds) {
                this.attrBolds.add(attr.decale(off));
            }
            for (TooltipPart tt : str.tooltips) {
                this.tooltips.add(tt.shift(off));
            }
            return this;
        }

        public StyledString append(String str) {
            this.text.append(str);
            return this;
        }

        public StyledString appendError(String src) {
            this.attrParts.add(new AttributesPart(this.text.length(), src.length(), Styles.createAttributeSet(Color.RED, null, true, null)));
            this.text.append(src);
            return this;
        }

        public StyledString appendSource(String src) {
            this.attrParts.add(new AttributesPart(this.text.length(), src.length(), GlossaryTextArea.SOURCE_ATTRIBUTES));
            this.text.append(GlossaryEntry.bracketEntry(src));
            return this;
        }

        public StyledString appendTarget(String src) {
            this.attrParts.add(new AttributesPart(this.text.length(), src.length(), GlossaryTextArea.TARGET_ATTRIBUTES));
            this.text.append(GlossaryEntry.bracketEntry(src));
            return this;
        }

        public StyledString appendTarget(String src, boolean priority) {
            this.attrParts.add(new AttributesPart(this.text.length(), src.length(), GlossaryTextArea.TARGET_ATTRIBUTES));
            if (priority) {
                this.markBoldStart();
            }
            this.text.append(GlossaryEntry.bracketEntry(src));
            if (priority) {
                this.markBoldEnd();
            }
            return this;
        }

        public StyledString appendComment(String src) {
            if (src.startsWith("\u0007")) {
                return this.appendComment(src.substring(1), true);
            }
            this.attrParts.add(new AttributesPart(this.text.length(), src.length(), GlossaryTextArea.NOTES_ATTRIBUTES));
            this.text.append(src);
            return this;
        }

        public StyledString appendComment(String src, boolean priority) {
            this.attrParts.add(new AttributesPart(this.text.length(), src.length(), GlossaryTextArea.NOTES_ATTRIBUTES));
            if (priority) {
                this.markBoldStart();
            }
            this.text.append(src);
            if (priority) {
                this.markBoldEnd();
            }
            return this;
        }

        public String toHTML() {
            StringBuilder sb = new StringBuilder(this.text);
            AttributesPart[] attrPartsTmp = this.attrParts.toArray(new AttributesPart[0]);
            ListIterator<AttributesPart> li = this.attrBolds.listIterator(this.attrBolds.size());
            while (li.hasPrevious()) {
                li.previous().insertHtml(sb, attrPartsTmp);
            }
            for (int i = attrPartsTmp.length - 1; i >= 0; --i) {
                attrPartsTmp[i].insertHtml(sb, null);
            }
            sb.insert(0, "<html><p>").append("</p></html>");
            return sb.toString().replaceAll("\n", "<br>").replaceAll("\t", "&#009;");
        }

        static class TooltipPart
        extends Part {
            private String text;

            public TooltipPart(int start, int len, String text) {
                super(start, len);
                this.text = text;
            }

            public TooltipPart shift(int start) {
                return new TooltipPart(this.start + start, this.len, this.text);
            }

            public boolean contains(int pos) {
                return pos >= this.start && pos <= this.start + this.len;
            }

            public String getText() {
                return this.text;
            }
        }

        static class AttributesPart
        extends Part {
            private AttributeSet attr;

            public AttributesPart(int start, int len, AttributeSet attr) {
                super(start, len);
                this.attr = attr;
            }

            public void apply(StyledDocument doc) {
                doc.setCharacterAttributes(this.start, this.len, this.attr, false);
            }

            public AttributesPart decale(int start) {
                return new AttributesPart(this.start + start, this.len, this.attr);
            }

            void insertHtml(StringBuilder sb, AttributesPart[] next) {
                int shift1 = 0;
                int shift2 = 0;
                Color color = StyleConstants.getForeground(this.attr);
                if (color != Color.black) {
                    String colorString = String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                    sb.insert(this.start + this.len, "</font>");
                    sb.insert(this.start, "<font color=#" + colorString + ">");
                    shift1 = 20;
                    shift2 = 7;
                } else if (StyleConstants.isBold(this.attr)) {
                    sb.insert(this.start + this.len, "</b>");
                    sb.insert(this.start, "<b>");
                    shift1 = 3;
                    shift2 = 4;
                }
                if (next == null) {
                    return;
                }
                for (int i = 0; i < next.length; ++i) {
                    if (next[i].start >= this.start + this.len) {
                        next[i] = next[i].decale(shift1 + shift2);
                        continue;
                    }
                    if (next[i].start < this.start) continue;
                    next[i] = next[i].decale(shift1);
                }
            }
        }

        static class Part {
            protected int start;
            protected int len;

            public Part(int start, int len) {
                this.start = start;
                this.len = len;
            }

            public void setEnd(int pos) {
                this.len = pos - this.start;
            }
        }
    }
}

