/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.EncodingDetector;
import org.omegat.util.StringUtil;

public class GlossaryReaderTSV {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GlossaryEntry> read(File file, boolean priorityGlossary) throws IOException {
        String encoding;
        String fname_lower = file.getName().toLowerCase();
        if (fname_lower.endsWith(".tab") || fname_lower.endsWith(".txt")) {
            encoding = EncodingDetector.detectEncodingDefault(file, Charset.defaultCharset().name());
        } else if (fname_lower.endsWith(".utf8")) {
            encoding = "UTF-8";
        } else {
            return null;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        try (BufferedReader in = new BufferedReader(reader);){
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                String[] tokens;
                if (!s.startsWith("#") && (tokens = s.split("\t")).length >= 2 && !tokens[0].isEmpty()) {
                    String comment = "";
                    if (tokens.length >= 3) {
                        comment = tokens[2];
                    }
                    result.add(new GlossaryEntry(tokens[0], tokens[1], comment, priorityGlossary));
                }
                s = in.readLine();
            }
        }
        return result;
    }

    public static void append(File file, GlossaryEntry newEntry) throws IOException {
        String encoding = "UTF-8";
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            file.createNewFile();
        } else {
            encoding = EncodingDetector.detectEncodingDefault(file, "UTF-8");
        }
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), encoding);
        ((Writer)wr).append(newEntry.getSrcText()).append('\t').append(newEntry.getLocText());
        if (!StringUtil.isEmpty(newEntry.getCommentText())) {
            wr.append('\t').append(newEntry.getCommentText());
        }
        ((Writer)wr).append(System.getProperty("line.separator"));
        ((Writer)wr).close();
    }
}

