/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.TextExpression;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;

public class TransTipsPopup
implements IPopupMenuConstructor {
    @Override
    public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        if (!Preferences.isPreference("transtips_suggest")) {
            return;
        }
        if (!isInActiveEntry || isInActiveTranslation) {
            return;
        }
        int startSource = sb.getStartSourcePosition();
        int len = sb.getSourceText().length();
        if (mousepos < startSource || mousepos > startSource + len) {
            return;
        }
        SearchModeBox dummyBox = new SearchModeBox(0, ITokenizer.StemmingMode.GLOSSARY, null);
        dummyBox.loadPreferences("transtips_");
        for (GlossaryEntry ge : GlossaryTextArea.nowEntries) {
            TextExpression expr;
            List<SearchMatch> matches;
            String phrase = ge.getSrcText();
            if (phrase == null || phrase.equals("") || (matches = (expr = dummyBox.buildExpression(phrase, false, true)).searchString(sb.getSourceText())) == null) continue;
            for (SearchMatch found : matches) {
                if (startSource + found.getStart() > mousepos || mousepos > startSource + found.getEnd()) continue;
                String[] stringArray = ge.getLocTerms(true);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s;
                    final String txt = s = stringArray[i];
                    JMenuItem it = menu.add(txt);
                    it.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Core.getEditor().insertText(txt);
                        }
                    });
                }
            }
        }
        menu.addSeparator();
    }
}

