/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.FloatingDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.NearString;
import org.omegat.gui.common.OmegaTIcons;
import org.omegat.gui.dialogs.FileCollisionDialog;
import org.omegat.gui.filelist.ProjectFilesListController;
import org.omegat.gui.main.IMainMenu;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindowMenu;
import org.omegat.gui.main.MainWindowMenuHandler;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.WikiGet;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class MainWindow
extends JFrame
implements IMainWindow {
    public final MainWindowMenu menu;
    protected ProjectFilesListController m_projWin;
    private Font m_font;
    private final List<SearchWindow> m_searches = new ArrayList<SearchWindow>();
    protected JLabel lengthLabel;
    protected JLabel progressLabel;
    protected JLabel statusLabel;
    protected DockingDesktop desktop;
    private JLabel lastDialogText;
    private String lastDialogKey;

    public MainWindow() {
        this.menu = new MainWindowMenu(this, new MainWindowMenuHandler(this));
        this.setJMenuBar(this.menu.initComponents());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.menu.mainWindowMenuHandler.projectExitMenuItemActionPerformed();
            }

            @Override
            public void windowDeactivated(WindowEvent we) {
                Core.getEditor().windowDeactivated();
                super.windowDeactivated(we);
            }
        });
        String fontName = Preferences.getPreferenceDefault("source_font", "Dialog");
        int fontSize = Preferences.getPreferenceDefault("source_font_size", 12);
        this.m_font = new Font(fontName, 0, fontSize);
        MainWindowUI.createMainComponents(this, this.m_font);
        this.getContentPane().add((Component)MainWindowUI.initDocking(this), "Center");
        this.pack();
        this.getContentPane().add((Component)MainWindowUI.createStatusBar(this), "South");
        OmegaTIcons.setIconImages(this);
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                MainWindow.this.updateTitle();
                if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                    MainWindow.this.closeSearchWindows();
                }
            }
        });
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
                MainWindowUI.initializeScreenLayout(MainWindow.this);
                DockingUI.removeUnusedMenuSeparators(MainWindow.this.menu.getOptionsMenu().getPopupMenu());
            }

            @Override
            public void onApplicationShutdown() {
                MainWindowUI.saveScreenLayout(MainWindow.this);
                Preferences.save();
            }
        });
        MainWindowUI.handlePerProjectLayouts(this);
        this.updateTitle();
    }

    @Override
    public JFrame getApplicationFrame() {
        return this;
    }

    @Override
    public Font getApplicationFont() {
        return this.m_font;
    }

    @Override
    public IMainMenu getMainMenu() {
        return this.menu;
    }

    protected void setApplicationFont(Font newFont) {
        this.m_font = newFont;
        Preferences.setPreference("source_font", newFont.getName());
        Preferences.setPreference("source_font_size", newFont.getSize());
        CoreEvents.fireFontChanged(newFont);
    }

    @Override
    public void addDockable(Dockable pane) {
        this.desktop.addDockable(pane);
    }

    protected void updateTitle() {
        ResourceBundle verBundle;
        StringBuffer s;
        block46: {
            s = new StringBuffer(OStrings.getDisplayNameAndVersion());
            verBundle = ResourceBundle.getBundle("org/omegat/Version");
            s.append(" + DGT Extensions ").append(verBundle.getString("dgt.version"));
            if (verBundle.getString("dgt.status").contains("/")) {
                try {
                    int i;
                    String envStatus = "";
                    File jarDir = new File(MainWindow.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
                    if (jarDir.getName().startsWith("OmegaT-")) {
                        envStatus = jarDir.getName().substring(jarDir.getName().lastIndexOf("-") + 1);
                        if (envStatus.equals("APPVD")) {
                            envStatus = "DEV";
                        } else if (envStatus.equals("APPVT")) {
                            envStatus = "TEST";
                        } else if (envStatus.equals("APPVP")) {
                            envStatus = "PROD";
                        } else if (envStatus.equals("APPVL")) {
                            envStatus = "LEG";
                        } else if (envStatus.equals("APPVA")) {
                            envStatus = "ACC";
                        }
                    }
                    if (envStatus.length() < 1) {
                        for (String contents : jarDir.list()) {
                            if (contents.startsWith("ver.W10-APPVD") || contents.startsWith("ver.W10-DEV")) {
                                envStatus = "DEV";
                                break;
                            }
                            if (contents.startsWith("ver.W10-APPVT") || contents.startsWith("ver.W10-TEST")) {
                                envStatus = "TEST";
                                break;
                            }
                            if (contents.startsWith("ver.W10-APPVP") || contents.startsWith("ver.W10-PRO")) {
                                envStatus = "PROD";
                                break;
                            }
                            if (contents.startsWith("ver.W10-APPVL") || contents.startsWith("ver.W10-LEG")) {
                                envStatus = "LEG";
                                break;
                            }
                            if (!contents.startsWith("ver.W10-APPVA") && !contents.startsWith("ver.W10-ACC")) continue;
                            envStatus = "ACC";
                            break;
                        }
                    }
                    String[] statuses = verBundle.getString("dgt.status").split("/");
                    if (envStatus.length() < 1) {
                        s.append("-").append(statuses[0]).append("-").append(verBundle.getString("dgt.update").split("/")[0]);
                        break block46;
                    }
                    s.append("-").append(envStatus).append("-");
                    for (i = 0; i < statuses.length && !statuses[i].equals(envStatus); ++i) {
                    }
                    String[] versions = verBundle.getString("dgt.update").split("/");
                    if (i < versions.length) {
                        s.append(versions[i]);
                        break block46;
                    }
                    s.append(versions[0]);
                }
                catch (Exception e) {
                    s.append("-").append(verBundle.getString("dgt.status").substring(0, verBundle.getString("dgt.status").indexOf(47)));
                    s.append("-").append(verBundle.getString("dgt.update").substring(0, verBundle.getString("dgt.update").indexOf(47)));
                }
            } else {
                s.append("-").append(verBundle.getString("dgt.status")).append("-").append(verBundle.getString("dgt.update"));
            }
        }
        try {
            Log.log("Reading " + StaticUtils.installDir() + "/" + "changes.txt" + " to check version DGT-OmegaT " + verBundle.getString("dgt.version"));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(StaticUtils.installDir() + "/" + "changes.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.contains("DGT-OmegaT " + verBundle.getString("dgt.version"))) continue;
                    if (line.contains("bis")) {
                        s.append("-bis");
                    } else if (line.contains("ter")) {
                        s.append("-ter");
                    } else if (line.contains("quarter")) {
                        s.append("-quarter");
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.menu.revisionModeMenuItem.isSelected()) {
            s.append(" (" + OStrings.getString("MODE_REVISION") + ")");
        } else {
            s.append(" (" + OStrings.getString("MODE_TRANSLATION") + ")");
        }
        if (Core.getProject().isProjectLoaded()) {
            s.append(" :: ").append(Core.getProject().getProjectProperties().getProjectName());
        }
        this.setTitle(s.toString());
    }

    public void doInsertTrans() {
        NearString near;
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String text = this.getSelectedTextInMatcher();
        if (StringUtil.isEmpty(text) && (near = Core.getMatcher().getActiveMatch()) != null) {
            text = near.translation;
        }
        if (!StringUtil.isEmpty(text)) {
            Core.getEditor().insertText(text);
            Core.getEditor().requestFocus();
        }
    }

    public void doRecycleTrans() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = this.getSelectedTextInMatcher();
        if (!StringUtil.isEmpty(selection)) {
            Core.getEditor().replaceEditText(selection);
            Core.getEditor().requestFocus();
            return;
        }
        NearString near = Core.getMatcher().getActiveMatch();
        if (near != null) {
            String translation = near.translation;
            if (Preferences.isPreference("wf_convertNumbers")) {
                translation = Core.getMatcher().substituteNumbers(Core.getEditor().getCurrentEntry().getSrcText(), near.source, near.translation);
            }
            if (near.comesFrom == NearString.MATCH_SOURCE.TM && ExternalTMX.isInPath(new File(Core.getProject().getProjectProperties().getTMRoot(), "mt"), new File(near.proj))) {
                Core.getEditor().replaceEditTextWithColor(translation, Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_MT.getColor(), true);
                Core.getEditor().insertInfo(OStrings.getString("TF_SEG_COMESFROM_TM_MT"));
            } else {
                Core.getEditor().replaceEditTextWithColor(translation, near.score == 100 ? Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_PERFECT.getColor() : Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_FUZZY.getColor(), true);
                Core.getEditor().insertInfo(this.formatComesFromMatch(near));
            }
            Core.getEditor().requestFocus();
        }
    }

    public String formatComesFromMatch(NearString near) {
        String templateText = Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>");
        if (templateText.contains("core}")) {
            Matcher m = Pattern.compile("([\\w\\s]+:)?\\$\\{(score|noStemScore|adjustedScore)\\}").matcher(templateText);
            if (m.find()) {
                templateText = templateText.substring(m.start());
            }
            m = Pattern.compile("\\$\\{(score|noStemScore|adjustedScore)\\}(\\s*\\%)?").matcher(templateText);
            int idx = 0;
            while (m.find()) {
                idx = m.end();
            }
            if ((templateText = templateText.substring(0, idx)).contains("\u0013")) {
                m = Pattern.compile("\\$\\{(score|noStemScore|adjustedScore)\\}").matcher(templateText);
                templateText = "";
                while (m.find()) {
                    templateText = templateText + m.group() + "/";
                }
                templateText = templateText.substring(0, templateText.length() - 2) + "%";
            }
            templateText = new MatchesVarExpansion((String)templateText).apply((NearString)near, (int)1).text;
        } else {
            templateText = "";
        }
        return MessageFormat.format("  {0} {1}  ", OStrings.getString("TF_SEG_COMESFROM_MATCH"), templateText);
    }

    private String getSelectedTextInMatcher() {
        IMatcher matcher = Core.getMatcher();
        return matcher instanceof JTextComponent ? ((JTextComponent)((Object)matcher)).getSelectedText() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSearchWindow(final SearchWindow newSearchWindow) {
        newSearchWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                MainWindow.this.removeSearchWindow(newSearchWindow);
            }
        });
        List<SearchWindow> list = this.m_searches;
        synchronized (list) {
            this.m_searches.add(newSearchWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSearchWindow(SearchWindow searchWindow) {
        List<SearchWindow> list = this.m_searches;
        synchronized (list) {
            this.m_searches.remove(searchWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSearchWindows() {
        List<SearchWindow> list = this.m_searches;
        synchronized (list) {
            for (SearchWindow sw : this.m_searches) {
                sw.dispose();
            }
            this.m_searches.clear();
        }
    }

    protected List<SearchWindow> getSearchWindows() {
        return Collections.unmodifiableList(this.m_searches);
    }

    public void doPromptImportSourceFiles() {
        OmegaTFileChooser chooser = new OmegaTFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle(OStrings.getString("TF_FILE_IMPORT_TITLE"));
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            File[] selFiles = chooser.getSelectedFiles();
            this.importFiles(Core.getProject().getProjectProperties().getSourceRoot(), selFiles);
        }
    }

    public void importFiles(String destination, File[] toImport) {
        this.importFiles(destination, toImport, true);
    }

    public void importFiles(String destination, File[] toImport, boolean doReload) {
        try {
            FileUtil.copyFilesTo(new File(destination), toImport, new CollisionCallback());
            if (doReload) {
                ProjectUICommands.projectReload();
            }
        }
        catch (IOException ioe) {
            this.displayErrorRB(ioe, "MAIN_ERROR_File_Import_Failed", new Object[0]);
        }
    }

    public void doWikiImport() {
        String remote_url = JOptionPane.showInputDialog(this, OStrings.getString("TF_WIKI_IMPORT_PROMPT"), OStrings.getString("TF_WIKI_IMPORT_TITLE"), 2);
        String projectsource = Core.getProject().getProjectProperties().getSourceRoot();
        if (remote_url == null || remote_url.trim().isEmpty()) {
            return;
        }
        try {
            WikiGet.doWikiGet(remote_url, projectsource);
            ProjectUICommands.projectReload();
        }
        catch (Exception ex) {
            Log.log(ex);
            this.displayErrorRB(ex, "TF_WIKI_IMPORT_FAILED", new Object[0]);
        }
    }

    @Override
    public void showStatusMessageRB(String messageKey, Object ... params) {
        final String msg = this.getLocalizedString(messageKey, params);
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.statusLabel.setText(msg);
            }
        });
    }

    private String getLocalizedString(String messageKey, Object ... params) {
        if (messageKey == null) {
            return " ";
        }
        if (params == null) {
            return OStrings.getString(messageKey);
        }
        return StringUtil.format(OStrings.getString(messageKey), params);
    }

    public void showTimedStatusMessageRB(String messageKey, Object ... params) {
        this.showStatusMessageRB(messageKey, params);
        if (messageKey == null) {
            return;
        }
        final String localizedString = this.getLocalizedString(messageKey, params);
        ActionListener clearStatus = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String text = MainWindow.this.statusLabel.getText();
                if (localizedString.equals(text)) {
                    MainWindow.this.statusLabel.setText(null);
                }
            }
        };
        int DELAY = 10000;
        Timer timer = new Timer(10000, clearStatus);
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    public void showProgressMessage(String messageText) {
        this.progressLabel.setText(messageText);
    }

    public void setProgressToolTipText(String toolTipText) {
        this.progressLabel.setToolTipText(toolTipText);
    }

    @Override
    public void showLengthMessage(String messageText) {
        this.lengthLabel.setText(messageText);
    }

    @Override
    public void displayWarningRB(String warningKey, Object ... params) {
        this.displayWarningRB(warningKey, null, params);
    }

    @Override
    public void displayWarningRB(final String warningKey, final String supercedesKey, final Object ... params) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            @Override
            public void run() {
                Window w;
                String msg = params != null ? StringUtil.format(OStrings.getString(warningKey), params) : OStrings.getString(warningKey);
                if (supercedesKey != null && MainWindow.this.lastDialogText != null && supercedesKey.equals(MainWindow.this.lastDialogKey) && (w = SwingUtilities.getWindowAncestor(MainWindow.this.lastDialogText)) != null) {
                    w.dispose();
                }
                MainWindow.this.lastDialogText = new JLabel(msg);
                MainWindow.this.lastDialogKey = warningKey;
                MainWindow.this.statusLabel.setText(msg);
                JOptionPane.showMessageDialog(MainWindow.this, MainWindow.this.lastDialogText, OStrings.getString("TF_WARNING"), 2);
            }
        });
    }

    @Override
    public void displayErrorRB(final Throwable ex, final String errorKey, final Object ... params) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            @Override
            public void run() {
                String msg = params != null ? StringUtil.format(OStrings.getString(errorKey), params) : OStrings.getString(errorKey);
                MainWindow.this.statusLabel.setText(msg);
                String fulltext = msg;
                if (ex != null) {
                    fulltext = fulltext + "\n" + ex.toString();
                }
                JOptionPane.showMessageDialog(MainWindow.this, fulltext, OStrings.getString("TF_ERROR"), 0);
            }
        });
    }

    @Override
    public void lockUI() {
        UIThreadsUtil.mustBeSwingThread();
        this.setEnabled(false);
        for (Frame frame : Frame.getFrames()) {
            frame.setEnabled(false);
        }
        block1: for (Frame frame : this.desktop.getDockables()) {
            if (frame.isDocked()) continue;
            frame.getDockable().getComponent().setEnabled(false);
            for (Container parent = frame.getDockable().getComponent().getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof FloatingDialog)) continue;
                parent.setEnabled(false);
                continue block1;
            }
        }
    }

    @Override
    public void unlockUI() {
        UIThreadsUtil.mustBeSwingThread();
        for (DockableState dockableState : this.desktop.getDockables()) {
            if (dockableState.isDocked()) continue;
            for (Container parent = dockableState.getDockable().getComponent().getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof FloatingDialog)) continue;
                parent.setEnabled(true);
                break;
            }
            dockableState.getDockable().getComponent().setEnabled(true);
        }
        for (Frame frame : Frame.getFrames()) {
            frame.setEnabled(true);
        }
        this.setEnabled(true);
    }

    @Override
    public void showErrorDialogRB(String title, String message, Object ... args) {
        JOptionPane.showMessageDialog(this.getApplicationFrame(), StringUtil.format(OStrings.getString(message), args), OStrings.getString(title), 0);
    }

    @Override
    public int showConfirmDialog(Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
    }

    @Override
    public void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private class CollisionCallback
    implements FileUtil.ICollisionCallback {
        private boolean isCanceled = false;
        private boolean yesToAll = false;

        private CollisionCallback() {
        }

        @Override
        public boolean shouldReplace(File file, int index, int total) {
            if (this.isCanceled) {
                return false;
            }
            if (this.yesToAll) {
                return true;
            }
            FileCollisionDialog dialog = new FileCollisionDialog(MainWindow.this);
            dialog.setFilename(file.getName());
            dialog.enableApplyToAll(total - index > 1);
            dialog.pack();
            dialog.setVisible(true);
            this.isCanceled = dialog.userDidCancel();
            if (this.isCanceled) {
                return false;
            }
            this.yesToAll = dialog.isApplyToAll() && dialog.shouldReplace();
            return this.yesToAll || dialog.shouldReplace();
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled;
        }
    }
}

