/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.filelist.ProjectFilesListController;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class MainWindowUI {
    public static String UI_LAYOUT_FILE = "uiLayout" + OStrings.getBrandingToken() + ".xml";
    public static String UI_LAYOUT_DEFAULT_FILE = "uiLayout-default.xml";

    public static void createMainComponents(MainWindow mainWindow, Font font) {
        mainWindow.m_projWin = new ProjectFilesListController(mainWindow);
    }

    public static DockingDesktop initDocking(MainWindow mainWindow) {
        DockingUI.initialize();
        mainWindow.desktop = new DockingDesktop();
        mainWindow.desktop.addDockableStateWillChangeListener(new DockableStateWillChangeListener(){

            public void dockableStateWillChange(DockableStateWillChangeEvent event) {
                if (event.getFutureState().isClosed()) {
                    event.cancel();
                }
            }
        });
        return mainWindow.desktop;
    }

    public static void handlePerProjectLayouts(MainWindow mainWindow) {
        PerProjectLayoutHandler handler = new PerProjectLayoutHandler(mainWindow);
        CoreEvents.registerProjectChangeListener(handler);
        CoreEvents.registerApplicationEventListener(handler);
    }

    public static JPanel createStatusBar(MainWindow mainWindow) {
        mainWindow.statusLabel = new JLabel();
        mainWindow.progressLabel = new JLabel();
        mainWindow.lengthLabel = new JLabel();
        mainWindow.statusLabel.setFont(mainWindow.statusLabel.getFont().deriveFont(11.0f));
        Border border = UIManager.getBorder("OmegaTStatusArea.border");
        STATUS_BAR_MODE progressMode = Preferences.getPreferenceEnumDefault("sb_progress_mode", STATUS_BAR_MODE.DEFAULT);
        String statusText = OStrings.getString("MW_PROGRESS_DEFAULT");
        String tooltipText = "MW_PROGRESS_TOOLTIP";
        if (progressMode == STATUS_BAR_MODE.PERCENTAGE) {
            statusText = OStrings.getProgressBarDefaultPrecentageText();
            tooltipText = "MW_PROGRESS_TOOLTIP_PERCENTAGE";
        }
        Mnemonics.setLocalizedText(mainWindow.progressLabel, statusText);
        mainWindow.progressLabel.setToolTipText(OStrings.getString(tooltipText));
        mainWindow.progressLabel.setBorder(border);
        mainWindow.progressLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                STATUS_BAR_MODE[] modes = STATUS_BAR_MODE.values();
                STATUS_BAR_MODE progressMode = Preferences.getPreferenceEnumDefault("sb_progress_mode", STATUS_BAR_MODE.DEFAULT);
                progressMode = modes[(progressMode.ordinal() + 1) % modes.length];
                Preferences.setPreference("sb_progress_mode", (Object)progressMode);
                String statusText = OStrings.getString("MW_PROGRESS_DEFAULT");
                String tooltipText = "MW_PROGRESS_TOOLTIP";
                if (progressMode == STATUS_BAR_MODE.PERCENTAGE) {
                    statusText = OStrings.getProgressBarDefaultPrecentageText();
                    tooltipText = "MW_PROGRESS_TOOLTIP_PERCENTAGE";
                }
                if (Core.getProject().isProjectLoaded()) {
                    ((EditorController)Core.getEditor()).showStat();
                } else {
                    Core.getMainWindow().showProgressMessage(statusText);
                }
                ((MainWindow)Core.getMainWindow()).setProgressToolTipText(OStrings.getString(tooltipText));
            }
        });
        Mnemonics.setLocalizedText(mainWindow.lengthLabel, OStrings.getString("MW_SEGMENT_LENGTH_DEFAULT"));
        mainWindow.lengthLabel.setToolTipText(OStrings.getString("MW_SEGMENT_LENGTH_TOOLTIP"));
        mainWindow.lengthLabel.setBorder(border);
        mainWindow.lengthLabel.setFocusable(false);
        JPanel statusPanel2 = new JPanel(new FlowLayout(2));
        statusPanel2.add(mainWindow.progressLabel);
        statusPanel2.add(mainWindow.lengthLabel);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)mainWindow.statusLabel, "Center");
        statusPanel.add((Component)statusPanel2, "East");
        statusPanel.setBorder(UIManager.getBorder("OmegaTMainWindowBottomMargin.border"));
        Color bgColor = UIManager.getColor("AutoHideButtonPanel.background");
        if (bgColor != null) {
            statusPanel.setBackground(bgColor);
            statusPanel2.setBackground(bgColor);
        }
        return statusPanel;
    }

    public static void initializeScreenLayout(MainWindow mainWindow) {
        int h;
        int w;
        int y;
        int x;
        try {
            x = Integer.parseInt(Preferences.getPreference("screen_x"));
            y = Integer.parseInt(Preferences.getPreference("screen_y"));
            w = Integer.parseInt(Preferences.getPreference("screen_width"));
            h = Integer.parseInt(Preferences.getPreference("screen_height"));
        }
        catch (NumberFormatException nfe) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle scrSize = env.getMaximumWindowBounds();
            if (scrSize.width < 900) {
                x = 0;
                y = 0;
                w = 580;
                h = 536;
            }
            x = 0;
            y = 0;
            w = 690;
            h = 700;
        }
        w = StaticUIUtils.correctFrameWidth(w);
        mainWindow.setBounds(x, y, w, h);
        MainWindowUI.loadScreenLayoutFromPreferences(mainWindow);
    }

    private static void loadScreenLayoutFromPreferences(MainWindow mainWindow) {
        File uiLayoutFile = new File(StaticUtils.getConfigDir(), UI_LAYOUT_DEFAULT_FILE);
        if (!uiLayoutFile.exists()) {
            uiLayoutFile = new File(StaticUtils.getConfigDir(), UI_LAYOUT_FILE);
        }
        if (uiLayoutFile.exists()) {
            MainWindowUI.loadScreenLayout(mainWindow, uiLayoutFile);
        } else {
            MainWindowUI.resetDesktopLayout(mainWindow);
        }
    }

    private static void loadScreenLayout(MainWindow mainWindow, File uiLayoutFile) {
        try {
            MainWindowUI.loadScreenLayout(mainWindow, new FileInputStream(uiLayoutFile));
        }
        catch (FileNotFoundException ex) {
            Log.log(ex);
        }
    }

    private static void loadScreenLayout(MainWindow mainWindow, InputStream in) {
        try {
            try {
                mainWindow.desktop.readXML(in);
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            Log.log(e);
            MainWindowUI.resetDesktopLayout(mainWindow);
        }
        MainWindowUI.createDesktopPlugins(mainWindow);
    }

    private static void createDesktopPlugins(MainWindow mainWindow) {
        for (Class<?> plugin : PluginUtils.getDockableClasses()) {
            try {
                if (plugin.getField("INSTANCES").getInt(null) != 0) continue;
                Constructor<?> cons = plugin.getDeclaredConstructor(MainWindow.class);
                cons.newInstance(mainWindow);
            }
            catch (Exception nsm) {
                Log.log("Cannot initialize plugin " + plugin);
            }
        }
    }

    public static void saveScreenLayout(MainWindow mainWindow) {
        File uiLayoutFile = new File(StaticUtils.getConfigDir(), UI_LAYOUT_DEFAULT_FILE);
        MainWindowUI.saveScreenLayout(mainWindow, uiLayoutFile);
    }

    private static void saveScreenLayout(MainWindow mainWindow, File uiLayoutFile) {
        Preferences.setPreference("screen_x", mainWindow.getX());
        Preferences.setPreference("screen_y", mainWindow.getY());
        Preferences.setPreference("screen_width", mainWindow.getWidth());
        Preferences.setPreference("screen_height", mainWindow.getHeight());
        try (FileOutputStream out = new FileOutputStream(uiLayoutFile);){
            mainWindow.desktop.writeXML((OutputStream)out);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void resetDesktopLayout(MainWindow mainWindow) {
        MainWindowUI.loadScreenLayout(mainWindow, MainWindowUI.class.getResourceAsStream("DockingDefaults.xml"));
    }

    private static class PerProjectLayoutHandler
    implements IProjectEventListener,
    IApplicationEventListener {
        private final MainWindow mainWindow;
        private boolean didApplyPerProjectLayout = false;

        public PerProjectLayoutHandler(MainWindow mainWindow) {
            this.mainWindow = mainWindow;
        }

        @Override
        public void onApplicationStartup() {
        }

        @Override
        public void onApplicationShutdown() {
            if (Core.getProject().isProjectLoaded() && this.didApplyPerProjectLayout) {
                MainWindowUI.loadScreenLayoutFromPreferences(this.mainWindow);
                this.didApplyPerProjectLayout = false;
            }
        }

        @Override
        public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
            if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE && this.didApplyPerProjectLayout) {
                MainWindowUI.loadScreenLayoutFromPreferences(this.mainWindow);
                this.didApplyPerProjectLayout = false;
                return;
            }
            if (!Core.getProject().isProjectLoaded()) {
                return;
            }
            File perProjLayout = this.getPerProjectLayout();
            if (!perProjLayout.isFile()) {
                return;
            }
            switch (eventType) {
                case LOAD: {
                    MainWindowUI.saveScreenLayout(this.mainWindow);
                    MainWindowUI.loadScreenLayout(this.mainWindow, perProjLayout);
                    this.didApplyPerProjectLayout = true;
                    break;
                }
                case SAVE: {
                    MainWindowUI.saveScreenLayout(this.mainWindow, perProjLayout);
                }
            }
        }

        private File getPerProjectLayout() {
            File res = new File(Core.getProject().getProjectProperties().getProjectInternal(), UI_LAYOUT_DEFAULT_FILE);
            if (res.exists()) {
                return res;
            }
            return new File(Core.getProject().getProjectProperties().getProjectInternal(), UI_LAYOUT_FILE);
        }
    }

    public static enum STATUS_BAR_MODE {
        DEFAULT,
        PERCENTAGE;

    }
}

