/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.search.Searcher;
import org.omegat.gui.editor.EditorPopups;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.EntryListPane;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Log;
import org.omegat.util.MultiMap;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.RegexHighlightListener;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public abstract class SearchWindow
extends JFrame {
    private long lastDisplayProgress = 0L;
    protected final MainWindow m_parent;
    private JButton m_searchButton;
    private JButton m_stopSearchButton;
    private JButton m_formatButton;
    protected SearchModeBox m_modePanel;
    protected JLabel m_resultsLabel;
    private JButton m_advancedButton;
    protected boolean m_advancedVisible;
    protected JComponent advancedPanel;
    protected JSpinner m_numberOfResults;
    protected JSpinner m_maxTime;
    protected SpinnerModel m_numberModel;
    private JLabel m_elapsedTimeLabel;
    protected JCheckBox m_removeDupCB;
    private JButton m_dismissButton;
    protected EntryListPane m_viewer;
    protected JScrollPane m_viewerScroller;
    protected Searcher m_thread;
    public static final int H_MARGIN = 10;

    public SearchWindow(MainWindow par, String startText) {
        JComponent where;
        this.m_parent = par;
        this.setTitle(OStrings.getString("SW_TITLE_SEARCH"));
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        Box bTop = Box.createVerticalBox();
        cp.add((Component)bTop, "North");
        bTop.add(this.textPanel(startText));
        bTop.add(this.modePanel());
        Box options = this.optionsPanel();
        if (options != null) {
            bTop.add(options);
        }
        if ((where = this.wherePanel()) != null) {
            bTop.add(where);
        }
        this.m_resultsLabel = new JLabel();
        this.advancedPanel = this.advancedPanel();
        if (this.advancedPanel != null) {
            bTop.add(this.advancedPanel);
        }
        Box bAO = Box.createHorizontalBox();
        bAO.add(this.m_resultsLabel);
        bAO.add(Box.createHorizontalGlue());
        this.m_searchButton = new JButton();
        this.m_searchButton.addActionListener(e -> this.doSearch());
        Mnemonics.setLocalizedText(this.m_searchButton, OStrings.getString("BUTTON_SEARCH"));
        this.m_stopSearchButton = new JButton();
        this.m_stopSearchButton.addActionListener(e -> this.stopAndDisplay());
        Mnemonics.setLocalizedText(this.m_stopSearchButton, OStrings.getString("BUTTON_SEARCH_STOP"));
        this.m_stopSearchButton.setEnabled(false);
        bAO.add(this.m_stopSearchButton);
        bAO.add(this.m_searchButton);
        if (this.advancedPanel != null) {
            this.m_advancedButton = new JButton();
            Mnemonics.setLocalizedText(this.m_advancedButton, OStrings.getString("SW_ADVANCED_OPTIONS"));
            bAO.add(this.m_advancedButton);
            bAO.add(Box.createHorizontalStrut(10));
            this.m_advancedButton.addActionListener(e -> {
                this.m_advancedVisible = !this.m_advancedVisible;
                this.updateAdvancedOptionStatus();
            });
            bTop.add(bAO);
        }
        this.m_viewer = new EntryListPane(this);
        cp.add((Component)new JScrollPane(this.m_viewer), "Center");
        cp.add((Component)this.buttonsPanel(), "South");
        this.m_viewer.setText(this.getHelpText());
        this.loadPreferences();
        for (JTextComponent comp : this.textFieldsList()) {
            comp.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    for (JComponent comp : SearchWindow.this.componentsEnabledWhenResults()) {
                        comp.setEnabled(false);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    for (JComponent comp : SearchWindow.this.componentsEnabledWhenResults()) {
                        comp.setEnabled(false);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    for (JComponent comp : SearchWindow.this.componentsEnabledWhenResults()) {
                        comp.setEnabled(false);
                    }
                }
            });
        }
    }

    protected abstract String getScopeText();

    protected abstract boolean isReplace();

    public final String getHelpText() {
        StringBuffer buf = new StringBuffer();
        buf.append(OStrings.getString("SW_SEARCH_SCOPE")).append(":\n");
        buf.append(this.getScopeText());
        buf.append("\n\n").append(OStrings.getString("SW_ZONE_EXPRESSION_MODE")).append(":\n");
        buf.append(OStrings.getString("SW_HELP_EXPR_MODE_EXACT")).append("\n");
        if (!this.isReplace()) {
            buf.append(OStrings.getString("SW_HELP_EXPR_MODE_KEYWORDS")).append("\n");
        }
        buf.append(OStrings.getString("SW_HELP_EXPR_MODE_REGEX")).append("\n");
        buf.append(OStrings.getString("SW_HELP_EXPR_MODE_REGEX_NOWILD")).append("\n");
        if (this.isReplace()) {
            buf.append(OStrings.getString("SW_HELP_EXPR_MODE_REGEX_REPLACE")).append("\n");
        }
        buf.append("\n\n").append(OStrings.getString("SW_ZONE_WORD_MODE")).append(":\n");
        buf.append(OStrings.getString("SW_WORD_MODE_STRINGS")).append(":\t").append(OStrings.getString("SW_HELP_WORD_MODE_STRINGS")).append("\n");
        buf.append(OStrings.getString("SW_WORD_MODE_WHOLE")).append(":\t").append(OStrings.getString("SW_HELP_WORD_MODE_WHOLE")).append("\n");
        buf.append(OStrings.getString("SW_WORD_MODE_LEMMAS")).append(":\t").append(OStrings.getString("SW_HELP_WORD_MODE_LEMMAS")).append("\n");
        return buf.toString();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getMainSearchTextField().requestFocus();
    }

    protected abstract JComponent textPanel(String var1);

    protected JComponent modePanel() {
        this.m_modePanel = new SearchModeBox(0, ITokenizer.StemmingMode.MATCHING, this);
        for (AbstractButton component : this.m_modePanel.getOptionsComponents()) {
            this.addFocusToSearchListener(component);
        }
        return this.m_modePanel;
    }

    protected Box optionsPanel() {
        this.m_removeDupCB = new JCheckBox();
        Mnemonics.setLocalizedText(this.m_removeDupCB, OStrings.getString("SW_REMOVE_DUP"));
        Box bOB = Box.createHorizontalBox();
        bOB.add(this.m_removeDupCB);
        this.addFocusToSearchListener(this.m_removeDupCB);
        bOB.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_ZONE_OPTIONS")));
        return bOB;
    }

    protected abstract JComponent wherePanel();

    protected abstract String[] getFormatVariablesList();

    protected abstract String getFormatOptionName();

    protected abstract String getFormatOptionDefaultValue();

    public abstract void refreshLists(boolean var1);

    protected JComponent advancedPanel() {
        Box advBox = Box.createVerticalBox();
        this.m_numberModel = new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1);
        this.m_numberOfResults = new JSpinner(this.m_numberModel);
        JLabel m_numberLabel = new JLabel();
        Mnemonics.setLocalizedText(m_numberLabel, OStrings.getString("SW_NUMBER"));
        this.m_maxTime = new JSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1));
        JLabel m_timeLabel = new JLabel();
        Mnemonics.setLocalizedText(m_timeLabel, OStrings.getString("SW_MAX_TIME"));
        Box bNbr = Box.createHorizontalBox();
        bNbr.add(m_numberLabel);
        bNbr.add(this.m_numberOfResults);
        bNbr.add(m_timeLabel);
        bNbr.add(this.m_maxTime);
        bNbr.add(Box.createHorizontalStrut(10));
        bNbr.add(Box.createHorizontalGlue());
        this.m_elapsedTimeLabel = new JLabel();
        bNbr.add(this.m_elapsedTimeLabel);
        JSpinner m_dummy = new JSpinner();
        m_dummy.setVisible(false);
        bNbr.add(m_dummy);
        bNbr.add(Box.createHorizontalStrut(10));
        bNbr.add(Box.createHorizontalGlue());
        bNbr.add(m_dummy);
        Box formatBox = Box.createHorizontalBox();
        formatBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("EXT_TMX_MATCHES_TEMPLATE")));
        advBox.add(formatBox);
        JLabel varLabel = new JLabel();
        Mnemonics.setLocalizedText(varLabel, OStrings.getString("EXT_TMX_MATCHES_TEMPLATE_VARIABLES"));
        formatBox.add(varLabel);
        final JComboBox<String> varList = new JComboBox<String>();
        formatBox.add(varList);
        varList.setModel(new DefaultComboBoxModel<String>(this.getFormatVariablesList()));
        varList.setEnabled(false);
        final JButton insertButton = new JButton();
        Mnemonics.setLocalizedText(insertButton, OStrings.getString("BUTTON_INSERT"));
        insertButton.addActionListener(e -> this.m_viewer.replaceSelection(varList.getSelectedItem().toString()));
        insertButton.setEnabled(false);
        formatBox.add(insertButton);
        final JButton resetButton = new JButton();
        Mnemonics.setLocalizedText(resetButton, "Reset");
        resetButton.addActionListener(e -> this.m_viewer.setText(Preferences.getPreferenceDefault(this.getFormatOptionName(), this.getFormatOptionDefaultValue())));
        resetButton.setEnabled(false);
        formatBox.add(resetButton);
        final JButton cancelButton = new JButton();
        cancelButton.setEnabled(false);
        formatBox.add(cancelButton);
        Mnemonics.setLocalizedText(cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.m_formatButton = new JButton();
        Mnemonics.setLocalizedText(this.m_formatButton, OStrings.getString("SW_BTN_CONFIGURE"));
        formatBox.add(this.m_formatButton);
        final class ConfigureActionListener
        implements ActionListener {
            private String previousText;
            private final ActionListener resetListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchWindow.this.m_viewer.setText(previousText);
                    SearchWindow.this.m_viewer.setBackground(Color.WHITE);
                    SearchWindow.this.m_viewer.setEditable(false);
                    Mnemonics.setLocalizedText(SearchWindow.this.m_formatButton, OStrings.getString("SW_BTN_CONFIGURE"));
                    SearchWindow.this.m_formatButton.removeActionListener(validateListener);
                    cancelButton.removeActionListener(this);
                    SearchWindow.this.m_formatButton.addActionListener(this);
                    varList.setEnabled(false);
                    insertButton.setEnabled(false);
                    resetButton.setEnabled(false);
                    cancelButton.setEnabled(false);
                    SearchWindow.this.m_searchButton.setEnabled(SearchWindow.this.isSearchPossible());
                }
            };
            private final ActionListener validateListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preferences.setPreference(SearchWindow.this.getFormatOptionName(), SearchWindow.this.m_viewer.getText());
                    Preferences.save();
                    resetListener.actionPerformed(e);
                }
            };

            ConfigureActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchWindow.this.m_thread != null) {
                    SearchWindow.this.m_thread.fin();
                }
                SearchWindow.this.m_searchButton.setEnabled(false);
                this.previousText = SearchWindow.this.m_viewer.getText();
                SearchWindow.this.m_viewer.setText(Preferences.getPreferenceDefault(SearchWindow.this.getFormatOptionName(), SearchWindow.this.getFormatOptionDefaultValue()));
                SearchWindow.this.m_viewer.setBackground(new Color(255, 224, 255));
                SearchWindow.this.m_viewer.setEditable(true);
                Mnemonics.setLocalizedText(SearchWindow.this.m_formatButton, OStrings.getString("SW_BTN_CONFIGURE_VALIDATE"));
                SearchWindow.this.m_formatButton.removeActionListener(this);
                SearchWindow.this.m_formatButton.addActionListener(this.validateListener);
                varList.setEnabled(true);
                insertButton.setEnabled(true);
                cancelButton.setEnabled(true);
                resetButton.setEnabled(true);
                cancelButton.addActionListener(this.resetListener);
            }
        }
        this.m_formatButton.addActionListener(new ConfigureActionListener());
        this.m_numberOfResults.addChangeListener(e -> this.getMainSearchTextField().requestFocus());
        advBox.add(bNbr);
        return advBox;
    }

    protected Box buttonsPanel() {
        this.m_dismissButton = new JButton();
        Mnemonics.setLocalizedText(this.m_dismissButton, OStrings.getString("BUTTON_CLOSE"));
        Box bCB = Box.createHorizontalBox();
        bCB.add(this.m_dismissButton);
        this.m_dismissButton.addActionListener(this.getRootPane().getActionMap().get("ESCAPE"));
        return bCB;
    }

    public abstract JComboBox getMainSearchTextField();

    protected boolean isSearchPossible() {
        return true;
    }

    protected final void addFocusToSearchListener(AbstractButton button) {
        button.addActionListener(e -> {
            this.getMainSearchTextField().requestFocus();
            this.m_searchButton.setEnabled(this.isSearchPossible());
        });
    }

    protected void loadPreferences() {
        try {
            String dx = Preferences.getPreferenceDefault(this.getClass().getSimpleName() + "_" + "search_window_x", Preferences.getPreference("search_window_x"));
            String dy = Preferences.getPreferenceDefault(this.getClass().getSimpleName() + "_" + "search_window_y", Preferences.getPreference("search_window_y"));
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.setLocation(x, y);
            String dw = Preferences.getPreferenceDefault(this.getClass().getSimpleName() + "_" + "search_window_width", Preferences.getPreference("search_window_width"));
            String dh = Preferences.getPreferenceDefault(this.getClass().getSimpleName() + "_" + "search_window_height", Preferences.getPreference("search_window_height"));
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            this.setSize(800, 700);
        }
        this.m_modePanel.loadPreferences(this.getClass().getSimpleName() + "_");
        if (this.m_removeDupCB != null) {
            this.m_removeDupCB.setSelected(Preferences.isPreferenceDefault(this.getClass().getSimpleName() + "_" + "search_window_remove_dup", Preferences.isPreferenceDefault("search_window_remove_dup", false)));
        }
        this.loadAdvancedOptionPreferences();
        this.updateAdvancedOptionStatus();
    }

    protected void savePreferences() {
        Preferences.setPreference(this.getClass().getSimpleName() + "_" + "search_window_width", this.getWidth());
        Preferences.setPreference(this.getClass().getSimpleName() + "_" + "search_window_height", this.getHeight());
        Preferences.setPreference(this.getClass().getSimpleName() + "_" + "search_window_x", this.getX());
        Preferences.setPreference(this.getClass().getSimpleName() + "_" + "search_window_y", this.getY());
        this.m_modePanel.savePreferences(this.getClass().getSimpleName() + "_");
        if (this.m_removeDupCB != null) {
            Preferences.setPreference(this.getClass().getSimpleName() + "_" + "search_window_remove_dup", Boolean.toString(this.m_removeDupCB.isSelected()));
        }
        Preferences.setPreference(this.getClass().getSimpleName() + "_" + "search_window_advanced_visible", Boolean.toString(this.m_advancedVisible));
        Preferences.setPreference(this.getClass().getSimpleName() + "_" + "search_window_number_of_results", (Integer)this.m_numberOfResults.getValue());
        Preferences.setPreference(this.getClass().getSimpleName() + "_" + "search_window_max_time", (Integer)this.m_maxTime.getValue());
    }

    protected abstract JComponent[] componentsEnabledWhenResults();

    protected abstract JTextComponent[] textFieldsList();

    public void displaySearchResult(Collection<SearchResultEntry> entries) {
        UIThreadsUtil.executeInSwingThread(() -> {
            this.m_resultsLabel.setText(StringUtil.format(OStrings.getString("SW_DISPLAYING"), entries.size()));
            this.m_viewer.displaySearchResult(entries, (Integer)this.m_numberOfResults.getValue(), Preferences.getPreferenceDefault(this.getFormatOptionName(), this.getFormatOptionDefaultValue()), this.m_modePanel.englobeWords());
            if (entries.size() > 0) {
                for (JComponent comp : this.componentsEnabledWhenResults()) {
                    comp.setEnabled(true);
                }
            }
            this.m_stopSearchButton.setEnabled(false);
        });
    }

    protected void searchEnded(int resNum, int matchesNum) {
        if (resNum == matchesNum) {
            this.m_resultsLabel.setText(StringUtil.format(OStrings.getString("SW_NR_OF_RESULTS"), resNum));
        } else {
            this.m_resultsLabel.setText(StringUtil.format(OStrings.getString("SW_NR_OF_RESULTS_WITH_MATCHES"), resNum, matchesNum));
        }
        this.m_searchButton.setEnabled(true);
        this.m_formatButton.setEnabled(true);
        long time = System.currentTimeMillis() - this.m_thread.startTime;
        if (time < 60000L) {
            this.m_elapsedTimeLabel.setText(StringUtil.format(OStrings.getString("SW_SEARCHING_TIME"), "" + time / 1000L + "." + String.format("%03d", time % 1000L)) + " s.");
        } else {
            this.m_elapsedTimeLabel.setText(StringUtil.format(OStrings.getString("SW_SEARCHING_TIME"), "" + time / 60L + ":" + String.format("%02d", (time /= 1000L) % 60L)));
        }
    }

    @Override
    public void processWindowEvent(WindowEvent w) {
        int evt = w.getID();
        if (evt == 201 || evt == 202) {
            this.savePreferences();
            if (this.m_thread != null) {
                this.m_thread.fin();
            }
        }
        super.processWindowEvent(w);
    }

    protected abstract Searcher buildSearcher() throws Exception;

    protected final void doSearch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.m_thread != null) {
            this.m_thread.fin();
        }
        this.getMainSearchTextField().requestFocus();
        this.m_viewer.reset();
        this.savePreferences();
        Object item = this.getMainSearchTextField().getSelectedItem();
        if (item == null || item.toString().length() == 0) {
            this.setTitle(OStrings.getString("SW_TITLE_SEARCH"));
        } else {
            this.setTitle(item.toString() + " - OmegaT");
        }
        try {
            this.m_thread = this.buildSearcher();
            if (this.m_thread != null) {
                this.m_searchButton.setEnabled(false);
                this.m_stopSearchButton.setEnabled(true);
                this.m_formatButton.setEnabled(false);
                this.m_viewer.setText(OStrings.getString("SW_SEARCHING"));
                this.m_resultsLabel.setText(OStrings.getString("SW_SEARCHING"));
                this.m_thread.start();
            }
        }
        catch (Exception e) {
            try {
                DefaultStyledDocument doc = new DefaultStyledDocument();
                doc.insertString(0, OStrings.getString("LD_ERROR").replace("{0}", ""), Styles.createAttributeSet(Color.RED, null, true, null));
                doc.insertString(OStrings.getString("LD_ERROR").length() - 3, e.getMessage(), Styles.createAttributeSet(Color.RED, null, false, null));
                this.m_viewer.setDocument(doc);
            }
            catch (Exception e2) {
                this.m_viewer.setText(String.format(OStrings.getString("LD_ERROR"), "") + "\n\n" + e.getMessage());
            }
            Log.log(e);
        }
    }

    private void stopAndDisplay() {
        UIThreadsUtil.mustBeSwingThread();
        this.m_thread.fin();
        Collection<SearchResultEntry> res = this.m_thread.getSearchResults();
        this.searchEnded(res.size(), res.size());
        this.m_searchButton.setEnabled(true);
        this.m_stopSearchButton.setEnabled(false);
        this.displaySearchResult(res);
    }

    private void doCancel() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.m_thread != null) {
            this.m_thread.fin();
        }
        this.m_searchButton.setEnabled(true);
        this.m_stopSearchButton.setEnabled(false);
        this.dispose();
    }

    protected void loadAdvancedOptionPreferences() {
        String advancedVisible = Preferences.getPreferenceDefault(this.getClass().getSimpleName() + "_" + "search_window_advanced_visible", Preferences.getPreferenceDefault("search_window_advanced_visible", "false"));
        this.m_advancedVisible = Boolean.valueOf(advancedVisible);
        this.m_numberOfResults.setValue(Preferences.getPreferenceDefault(this.getClass().getSimpleName() + "_" + "search_window_number_of_results", Preferences.getPreferenceDefault("search_window_number_of_results", 1000)));
        this.m_maxTime.setValue(Preferences.getPreferenceDefault(this.getClass().getSimpleName() + "_" + "search_window_max_time", Preferences.getPreferenceDefault("search_window_max_time", 10)));
    }

    protected void updateAdvancedOptionStatus() {
        this.advancedPanel.setVisible(this.m_advancedVisible);
    }

    public void displayErrorRB(Throwable ex, String errorKey, Object ... params) {
        UIThreadsUtil.executeInSwingThread(() -> {
            String msg = params != null ? StringUtil.format(OStrings.getString(errorKey), params) : OStrings.getString(errorKey);
            String fulltext = msg;
            if (ex != null) {
                fulltext = fulltext + "\n" + ex.getLocalizedMessage();
            }
            JOptionPane.showMessageDialog(this, fulltext, OStrings.getString("TF_ERROR"), 0);
            this.m_searchButton.setEnabled(true);
            this.m_formatButton.setEnabled(true);
        });
    }

    public void displayProgress(String step, int done, int total, int found) {
        long time = System.currentTimeMillis() - this.m_thread.startTime;
        if (time < 1000L) {
            return;
        }
        if (time - this.lastDisplayProgress < 1000L) {
            return;
        }
        this.lastDisplayProgress = time;
        UIThreadsUtil.executeInSwingThread(() -> {
            long localTime = time / 1000L;
            if (localTime > 60L * (long)((Integer)this.m_maxTime.getValue()).intValue()) {
                this.stopAndDisplay();
            } else {
                this.m_viewer.setText(StringUtil.format(OStrings.getString("SW_SEARCHING_PROGRESS"), OStrings.getString("SW_SEARCHING_STEP_" + step)) + " (" + done + "/" + total + " = " + (int)(100.0 * (double)done / (double)total) + " %)\n" + StringUtil.format(OStrings.getString("SW_SEARCHING_FOUND"), found) + "\n" + StringUtil.format(OStrings.getString("SW_SEARCHING_TIME"), "" + localTime / 60L + ":" + String.format("%02d", localTime % 60L)));
            }
        });
    }

    protected JButton createMemorizeButton(int winY, boolean canAll, final JComboBox field, final JComboBox replace, final String checkLabel, final SetRef valuesSet) {
        JButton memoBtn = new JButton(OStrings.getString("SW_SEARCH_MEMORIZE"));
        memoBtn.addActionListener(e -> {
            final JDialog dialog = new JDialog();
            dialog.setTitle("Select scope");
            dialog.setModal(true);
            JButton bSession = new JButton("For this session");
            JButton bProj = new JButton("For the project");
            JButton bAll = new JButton("For all projects");
            JButton bCancel = new JButton("Cancel");
            class ButtonListener
            implements ActionListener {
                private String destDir;
                private boolean cancel = false;
                private boolean global = false;

                public ButtonListener(boolean cancel, boolean global, String destDir) {
                    this.destDir = destDir;
                    this.cancel = cancel;
                    this.global = global;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    if (this.cancel) {
                        return;
                    }
                    String selection = field.getSelectedItem().toString();
                    field.addItem(selection);
                    valuesSet.add(selection);
                    if (this.destDir != null) {
                        try {
                            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.destDir + "search.tsv", true)));
                            StringBuffer values = new StringBuffer();
                            if (this.global) {
                                values.append(Core.getProject().getProjectProperties().getSourceLanguage()).append("\t");
                                values.append(Core.getProject().getProjectProperties().getTargetLanguage()).append("\t");
                            }
                            if ("REGEXP".equals(SearchWindow.this.m_modePanel.searchTypeString())) {
                                values.append("*").append("\t");
                                if (checkLabel.contains("SEARCH")) {
                                    values.append("SW_SEARCH_*").append(":");
                                } else {
                                    values.append(checkLabel).append(":");
                                }
                                values.append(SearchWindow.this.m_modePanel.searchTypeString()).append("\t");
                            } else {
                                values.append(SearchWindow.this.getClass().getSimpleName()).append("\t");
                                values.append(checkLabel).append(":");
                                values.append(SearchWindow.this.m_modePanel.searchTypeString()).append("\t");
                            }
                            values.append("{").append(SearchWindow.this.m_modePanel.wordModeString()).append("}");
                            values.append(selection);
                            if (replace != null) {
                                String replaceTxt = replace.getSelectedItem().toString();
                                values.append("\t").append(replaceTxt);
                                if (selection == null) {
                                    return;
                                }
                            }
                            out.println(values.toString());
                            out.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            bCancel.addActionListener(new ButtonListener(true, false, null));
            bSession.addActionListener(new ButtonListener(false, false, null));
            bProj.addActionListener(new ButtonListener(false, false, Core.getProject().getProjectProperties().getProjectRoot()));
            if (canAll) {
                bAll.addActionListener(new ButtonListener(false, true, StaticUtils.getConfigDir()));
            }
            Container cp = dialog.getContentPane();
            cp.setLayout(new GridLayout(4, 1));
            cp.add(bSession);
            cp.add(bProj);
            if (canAll) {
                cp.add(bAll);
            }
            cp.add(bCancel);
            dialog.pack();
            dialog.setLocation(memoBtn.getX() - 50, winY);
            dialog.setVisible(true);
        });
        return memoBtn;
    }

    class RegexModeSwitchListener
    implements ActionListener {
        private SearchModeBox box;
        private RegexHighlightListener listenerRegex;
        private RegexHighlightListener listenerJokers;
        private JTextComponent receiver;

        public RegexModeSwitchListener(SearchModeBox box, JTextComponent receiver) {
            this.box = box;
            this.receiver = receiver;
            this.listenerRegex = new RegexHighlightListener(receiver, 3);
            this.listenerJokers = new RegexHighlightListener(receiver, 4);
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (this.box.searchTypeString().equals("REGEXP")) {
                this.receiver.getDocument().addDocumentListener(this.listenerRegex);
                this.receiver.getDocument().removeDocumentListener(this.listenerJokers);
            } else {
                this.receiver.getDocument().removeDocumentListener(this.listenerRegex);
                this.receiver.getDocument().addDocumentListener(this.listenerJokers);
            }
        }
    }

    static class SearchesLoader<SC>
    implements IProjectEventListener {
        private Map<String, SC> asso;
        private String name;

        public SearchesLoader(String name, Map<String, SC> asso) {
            this.asso = asso;
            this.name = name;
            this.load(true);
            if (Core.getProject() != null && Core.getProject().getProjectProperties() != null) {
                this.load(false);
            }
        }

        @Override
        public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE type) {
            if (type == IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE || type == IProjectEventListener.PROJECT_CHANGE_TYPE.SAVE) {
                return;
            }
            for (SC set : this.asso.values()) {
                if (set instanceof Set) {
                    ((Set)set).clear();
                    continue;
                }
                if (!(set instanceof Map)) continue;
                ((Map)set).clear();
            }
            if (type == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                return;
            }
            this.load(true);
            if (Core.getProject() != null && Core.getProject().getProjectProperties() != null) {
                this.load(false);
            }
        }

        private void load(boolean global) {
            try {
                String line;
                String fileName = global ? StaticUtils.getConfigDir() + "search.tsv" : Core.getProject().getProjectProperties().getProjectRoot() + "search.tsv";
                Log.log("Loading searches from " + fileName);
                BufferedReader reader = new BufferedReader(new FileReader(fileName));
                int classPos = 0;
                int typePos = 1;
                int dataPos = 2;
                if (global) {
                    classPos += 2;
                    typePos += 2;
                    dataPos += 2;
                }
                while ((line = reader.readLine()) != null) {
                    String[] cols = line.split("\t");
                    if (!cols[classPos].equals("*") && !cols[classPos].equals(this.name)) continue;
                    if (global) {
                        if (cols[0].equals("*")) {
                            cols[0] = Core.getProject().getProjectProperties().getSourceLanguage().toString();
                        }
                        if (cols[1].equals("*")) {
                            cols[1] = Core.getProject().getProjectProperties().getTargetLanguage().toString();
                        }
                        if (!cols[0].equals(Core.getProject().getProjectProperties().getSourceLanguage().toString()) || !cols[1].equals(Core.getProject().getProjectProperties().getTargetLanguage().toString())) continue;
                    }
                    Collection<Object> typeSets = Collections.emptySet();
                    if (!cols[typePos].contains("*")) {
                        typeSets = Collections.singleton(this.asso.get(cols[typePos]));
                    } else if (cols[typePos].equals("*:*")) {
                        typeSets = this.asso.values();
                    } else if (cols[typePos].startsWith("*:")) {
                        typeSets = new ArrayList();
                        for (Map.Entry entry : this.asso.entrySet()) {
                            if (!((String)entry.getKey()).endsWith(cols[typePos].substring(cols[typePos].indexOf(58) + 1))) continue;
                            typeSets.add(entry.getValue());
                        }
                    } else if (cols[typePos].startsWith("SW_SEARCH_*:")) {
                        typeSets = new ArrayList();
                        for (Map.Entry entry : this.asso.entrySet()) {
                            if (!((String)entry.getKey()).startsWith("SW_SEARCH") || !((String)entry.getKey()).endsWith(cols[typePos].substring(cols[typePos].indexOf(58) + 1))) continue;
                            typeSets.add(entry.getValue());
                        }
                    } else if (cols[typePos].endsWith(":*")) {
                        typeSets = new ArrayList();
                        for (Map.Entry entry : this.asso.entrySet()) {
                            if (!((String)entry.getKey()).startsWith(cols[typePos].substring(0, cols[typePos].indexOf(58)))) continue;
                            typeSets.add(entry.getValue());
                        }
                    }
                    for (Object e : typeSets) {
                        if (e instanceof Set) {
                            ((Set)e).add(cols[dataPos]);
                            continue;
                        }
                        if (!(e instanceof Map)) continue;
                        Map searches = (Map)e;
                        TreeSet<String> localAsso = (TreeSet<String>)searches.get(cols[dataPos]);
                        if (localAsso == null) {
                            localAsso = new TreeSet<String>();
                            searches.put(cols[dataPos], localAsso);
                        }
                        localAsso.add(cols[dataPos + 1]);
                    }
                }
                reader.close();
            }
            catch (FileNotFoundException fnf) {
                Log.log("File does not exist. Nothing to read.");
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    protected static class SetRef {
        public Set<String> theSet;

        public SetRef(Set<String> theSet) {
            this.theSet = theSet;
        }

        public void add(String val) {
            this.theSet.add(val);
        }
    }

    protected static class PopupFactory
    extends MouseAdapter {
        private JTextComponent receiver;
        private MultiMap<Integer, IPopupMenuConstructor> popupConstructors;

        public PopupFactory(JTextComponent receiver) {
            this.receiver = receiver;
            this.popupConstructors = new MultiMap(true);
            this.popupConstructors.put(400, new EditorPopups.DefaultPopup());
            this.popupConstructors.put(700, new EditorPopups.InsertTagsPopup());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JPopupMenu popup;
            if ((e.isPopupTrigger() || e.getButton() == 3) && (popup = this.makePopupMenu(this.receiver.viewToModel(e.getPoint()))).getComponentCount() > 0) {
                popup.show(this.receiver, (int)e.getPoint().getX(), (int)e.getPoint().getY());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JPopupMenu makePopupMenu(int pos) {
            LinkedList<IPopupMenuConstructor> cons = new LinkedList<IPopupMenuConstructor>();
            MultiMap<Integer, IPopupMenuConstructor> multiMap = this.popupConstructors;
            synchronized (multiMap) {
                for (IPopupMenuConstructor cons0 : this.popupConstructors.values()) {
                    cons.add(cons0);
                }
            }
            JPopupMenu popup = new JPopupMenu();
            for (IPopupMenuConstructor c : cons) {
                c.addItems(popup, this.receiver, pos, false, true, null);
            }
            DockingUI.removeUnusedMenuSeparators(popup);
            return popup;
        }
    }
}

