/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.shortcuts;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public class PropertiesShortcuts {
    private static final String MAIN_MENU_SHORTCUTS_FILE = "/org/omegat/gui/main/MainMenuShortcuts.properties";
    public static final PropertiesShortcuts MainMenuShortcuts = new PropertiesShortcuts("/org/omegat/gui/main/MainMenuShortcuts.properties");
    private final Properties properties = new Properties();

    public PropertiesShortcuts(String propertiesFileInClasspath) {
        try {
            if (Platform.isMacOSX()) {
                String macSpecific = propertiesFileInClasspath.replaceAll("\\.properties$", ".mac.properties");
                this.loadProperties(PropertiesShortcuts.class.getResourceAsStream(macSpecific));
            }
            if (this.properties.isEmpty()) {
                this.loadProperties(PropertiesShortcuts.class.getResourceAsStream(propertiesFileInClasspath));
            }
            String userFile = propertiesFileInClasspath.substring(propertiesFileInClasspath.lastIndexOf(47) + 1);
            File userShortcutsFile = new File(StaticUtils.getConfigDir(), userFile);
            if (userShortcutsFile.exists()) {
                this.loadProperties(new FileInputStream(userShortcutsFile));
            }
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private void loadProperties(InputStream in) throws IOException {
        if (in != null) {
            try {
                this.properties.load(in);
            }
            finally {
                in.close();
            }
        }
    }

    public KeyStroke getKeyStroke(String key) {
        String shortcut = this.properties.getProperty(key);
        if (shortcut == null) {
            throw new IllegalArgumentException("Key '" + key + "' is not found.");
        }
        return KeyStroke.getKeyStroke(shortcut);
    }

    public void bindKeyStrokes(JMenuBar menu) {
        this.applyTo(menu.getComponents());
    }

    private void applyTo(Component[] items) {
        for (Component c : items) {
            if (!(c instanceof JMenuItem)) continue;
            this.bindKeyStrokes((JMenuItem)c);
        }
    }

    public void bindKeyStrokes(JMenuItem item) {
        if (item instanceof JMenu) {
            this.applyTo(((JMenu)item).getMenuComponents());
        } else {
            String shortcut = item.getActionCommand();
            if (!StringUtil.isEmpty(shortcut)) {
                try {
                    item.setAccelerator(this.getKeyStroke(shortcut));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void bindKeyStrokes(InputMap inputMap, Object ... keys) {
        for (Object o : keys) {
            try {
                String key = (String)o;
                KeyStroke keyStroke = this.getKeyStroke(key);
                if (keyStroke == null) {
                    this.removeEntry(inputMap, key);
                    continue;
                }
                inputMap.put(keyStroke, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private KeyStroke removeEntry(InputMap inputMap, String keyToBeRemoved) {
        KeyStroke removedEntry = null;
        for (KeyStroke ks : inputMap.keys()) {
            String key = (String)inputMap.get(ks);
            if (!key.equals(keyToBeRemoved)) continue;
            inputMap.remove(ks);
            removedEntry = ks;
            break;
        }
        return removedEntry;
    }
}

