/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.stat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.statistics.CalcMatchStatistics;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.stat.BaseStatisticsPanel;
import org.omegat.gui.stat.MatchStatisticsPanel;
import org.omegat.gui.stat.PerFileMatchStatisticsPanel;
import org.omegat.gui.stat.StatisticsPanel;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class StatisticsWindow
extends JDialog {
    private String textData;
    private LongProcessThread thread;
    private JButton closeButton;
    private JButton copyDataButton;
    JPanel displayPanel;
    private Box.Filler filler1;
    private JPanel jPanel2;
    JProgressBar progressBar;

    public StatisticsWindow(STAT_TYPE statType) {
        super((Frame)Core.getMainWindow().getApplicationFrame(), false);
        this.initComponents();
        this.copyDataButton.setVisible(false);
        BaseStatisticsPanel output = null;
        switch (statType) {
            case STANDARD: {
                this.setTitle(OStrings.getString("CT_STATSSTANDARD_WindowHeader"));
                StatisticsPanel panel = new StatisticsPanel(this);
                this.thread = new CalcStandardStatistics(panel);
                output = panel;
                break;
            }
            case MATCHES: {
                this.setTitle(OStrings.getString("CT_STATSMATCH_WindowHeader"));
                MatchStatisticsPanel panel1 = new MatchStatisticsPanel(this);
                this.thread = new CalcMatchStatistics(panel1, false);
                output = panel1;
                break;
            }
            case MATCHES_PER_FILE: {
                this.setTitle(OStrings.getString("CT_STATSMATCH_PER_FILE_WindowHeader"));
                PerFileMatchStatisticsPanel panel2 = new PerFileMatchStatisticsPanel(this);
                this.thread = new CalcMatchStatistics(panel2, true);
                output = panel2;
            }
        }
        this.thread.setPriority(1);
        this.thread.start();
        this.displayPanel.add(output);
        StaticUIUtils.setEscapeClosable(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StatisticsWindow.this.thread.fin();
            }
        });
        this.setSize(800, 400);
        DockingUI.displayCentered(this);
    }

    private void initComponents() {
        this.displayPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.progressBar = new JProgressBar();
        this.copyDataButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.displayPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.displayPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.displayPanel, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jPanel2.add(this.filler1);
        this.progressBar.setStringPainted(true);
        this.jPanel2.add(this.progressBar);
        Mnemonics.setLocalizedText(this.copyDataButton, OStrings.getString("CT_STATS_CopyToClipboard"));
        this.copyDataButton.setEnabled(false);
        this.copyDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsWindow.this.copyDataButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.copyDataButton);
        Mnemonics.setLocalizedText(this.closeButton, OStrings.getString("BUTTON_CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticsWindow.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.closeButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void copyDataButtonActionPerformed(ActionEvent evt) {
        if (this.textData != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.textData), null);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.thread.fin();
        this.dispose();
    }

    public void setTextData(final String textData) {
        this.textData = textData;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatisticsWindow.this.copyDataButton.setEnabled(textData != null && !textData.isEmpty());
            }
        });
    }

    public void showProgress(final int percent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatisticsWindow.this.progressBar.setValue(percent);
                StatisticsWindow.this.progressBar.setString(percent + "%");
            }
        });
    }

    public void finishData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatisticsWindow.this.progressBar.setValue(100);
                StatisticsWindow.this.progressBar.setString("");
                StatisticsWindow.this.progressBar.setVisible(false);
                StatisticsWindow.this.copyDataButton.setVisible(true);
            }
        });
    }

    public static enum STAT_TYPE {
        STANDARD,
        MATCHES,
        MATCHES_PER_FILE;

    }
}

