/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;

public abstract class VarExpansion<Param> {
    public static final String VAR_SOURCE_TEXT = "${sourceText}";
    public static final String VAR_TARGET_TEXT = "${targetText}";
    public static final String VAR_PROJECT_SOURCE_LANG = "${projectSourceLang}";
    public static final String VAR_PROJECT_SOURCE_LANG_CODE = "${projectSourceLangCode}";
    public static final String VAR_PROJECT_TARGET_LANG = "${projectTargetLang}";
    public static final String VAR_PROJECT_TARGET_LANG_CODE = "${projectTargetLangCode}";
    public static final String VAR_FILE_NAME = "${fileName}";
    public static final String VAR_FILE_NAME_ONLY = "${fileNameOnly}";
    public static final String VAR_FILE_EXTENSION = "${fileExtension}";
    public static final String VAR_FILE_PATH = "${filePath}";
    public static final String VAR_FILE_SHORT_PATH = "${fileShortPath}";
    public static final Pattern patternBundleEntry = Pattern.compile("#\\{([\\w\\.]+?)\\}(\\[.+?\\])*");
    protected String template;
    public static final Pattern patternSingleProperty = Pattern.compile("@\\{(.+?)\\}");
    public static final Pattern patternPropertyGroup = Pattern.compile("@\\[(.+?)\\]\\[(.+?)\\]\\[(.+?)\\]");

    public VarExpansion(String template) {
        template = VarExpansion.expandBundleEntries(template);
        if (Core.getProject().isProjectLoaded()) {
            ProjectProperties prop = Core.getProject().getProjectProperties();
            template = template.replace(VAR_PROJECT_TARGET_LANG, prop.getTargetLanguage().getLanguage());
            template = template.replace(VAR_PROJECT_TARGET_LANG_CODE, prop.getTargetLanguage().getLanguageCode());
            template = template.replace(VAR_PROJECT_SOURCE_LANG, prop.getSourceLanguage().getLanguage());
            template = template.replace(VAR_PROJECT_SOURCE_LANG_CODE, prop.getSourceLanguage().getLanguageCode());
        }
        this.template = template;
    }

    protected static String expandBundleEntries(String localTemplate) {
        Matcher matcher;
        while ((matcher = patternBundleEntry.matcher(localTemplate)).find()) {
            String original = matcher.group();
            String translation = OStrings.getString(matcher.group(1));
            if (!StringUtil.isEmpty(matcher.group(2))) {
                String vars = matcher.group(2);
                ArrayList<String> values = new ArrayList<String>();
                matcher = Pattern.compile("\\[(.+?)\\]").matcher(vars);
                while (matcher.find()) {
                    values.add(matcher.group(1));
                }
                translation = MessageFormat.format(translation, values.toArray());
            }
            localTemplate = localTemplate.replace(original, translation);
        }
        return localTemplate;
    }

    public String expandFileName(String localTemplate, String filePath, String baseDir) {
        if (localTemplate == null) {
            localTemplate = this.template;
        }
        localTemplate = localTemplate.replace(VAR_FILE_PATH, filePath);
        if (filePath.startsWith(baseDir)) {
            filePath = filePath.substring(baseDir.length());
        }
        localTemplate = localTemplate.replace(VAR_FILE_SHORT_PATH, filePath);
        if (filePath.contains(File.separator)) {
            filePath = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        }
        localTemplate = localTemplate.replace(VAR_FILE_NAME, filePath);
        if (filePath.contains(".")) {
            String[] splitName = filePath.split("\\.");
            StringBuilder nameOnlyBuf = new StringBuilder(splitName[0]);
            StringBuilder extensionBuf = new StringBuilder(splitName[splitName.length - 1]);
            localTemplate = localTemplate.replace(VAR_FILE_NAME_ONLY, nameOnlyBuf.toString());
            localTemplate = localTemplate.replace(VAR_FILE_EXTENSION, extensionBuf.toString());
            for (int i = 0; i < splitName.length; ++i) {
                localTemplate = localTemplate.replaceAll("\\$\\{fileNameOnly-" + i + "\\}", nameOnlyBuf.toString());
                localTemplate = localTemplate.replaceAll("\\$\\{fileExtension-" + i + "\\}", extensionBuf.toString());
                if (i + 1 >= splitName.length) continue;
                nameOnlyBuf.append(".").append(splitName[i + 1]);
                extensionBuf.insert(0, splitName[splitName.length - i - 2] + '.');
            }
        }
        localTemplate = localTemplate.replaceAll("\\$\\{fileNameOnly(-\\d+)?\\}", filePath);
        localTemplate = localTemplate.replaceAll("\\$\\{fileExtension(-\\d+)?\\}", "");
        return localTemplate;
    }

    public String expandProperties(String localTemplate, List<TMXProp> props) {
        Matcher matcher;
        while ((matcher = patternSingleProperty.matcher(localTemplate)).find()) {
            String value = this.getPropValue(props, matcher.group(1));
            localTemplate = localTemplate.replace(matcher.group(), value == null ? "" : value);
        }
        while ((matcher = patternPropertyGroup.matcher(localTemplate)).find()) {
            String patternStr = matcher.group(1);
            String separator1 = matcher.group(2);
            String separator2 = matcher.group(3);
            separator1 = separator1.replace("\\n", "\n");
            separator2 = separator2.replace("\\n", "\n");
            Pattern pattern = Pattern.compile(patternStr.replace("*", "(.*)").replace("?", "(.)"));
            StringBuilder res = new StringBuilder();
            for (TMXProp me : props) {
                if (!pattern.matcher(me.getType().toString()).matches()) continue;
                res.append(me.getType()).append(separator1).append(me.getValue()).append(separator2);
            }
            if (res.toString().endsWith(separator2)) {
                res.replace(res.toString().lastIndexOf(separator2), res.length(), "");
            }
            localTemplate = localTemplate.replace(matcher.group(), res.toString());
        }
        return localTemplate;
    }

    protected String getPropValue(List<TMXProp> props, String type) {
        if (props == null) {
            return null;
        }
        for (TMXProp me : props) {
            if (!type.equals(me.getType())) continue;
            return me.getValue();
        }
        return null;
    }

    public abstract String expandVariables(Param var1);
}

