/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.omegat.util.Platform;

public class DataTableStyling {
    public static final Color COLOR_STANDARD_FG = Color.BLACK;
    public static final Color COLOR_STANDARD_BG = Color.WHITE;
    public static final Color COLOR_SPECIAL_FG = Color.BLACK;
    public static final Color COLOR_SPECIAL_BG = new Color(13164018);
    public static final Color COLOR_SELECTION_FG = Color.WHITE;
    public static final Color COLOR_SELECTION_BG = new Color(3110874);
    public static final Color COLOR_ALTERNATING_HILITE = new Color(245, 245, 245);
    public static final Border TABLE_FOCUS_BORDER = new MatteBorder(1, 1, 1, 1, new Color(7778280));
    public static final DecimalFormat NUMBER_FORMAT = new DecimalFormat(",##0");
    public static final int FONT_NO_CHANGE = -1;
    public static final int LINE_SPACING = 6;

    public static void applyColors(JTable table) {
        if (!Platform.isMacOSX()) {
            if (table.getParent() instanceof JViewport) {
                table.getParent().setBackground(COLOR_STANDARD_BG);
            }
            if (table.getParent().getParent() instanceof JScrollPane) {
                table.getParent().getParent().setBackground(COLOR_STANDARD_BG);
            }
            if (table.getTableHeader() != null) {
                table.getTableHeader().setBackground(COLOR_STANDARD_BG);
            }
        }
        table.setForeground(COLOR_STANDARD_FG);
        table.setBackground(COLOR_STANDARD_BG);
        table.setSelectionForeground(COLOR_SELECTION_FG);
        table.setSelectionBackground(COLOR_SELECTION_BG);
        table.setGridColor(COLOR_STANDARD_BG);
    }

    public static void applyFont(JTable table, Font font) {
        table.setFont(font);
        table.setRowHeight(font.getSize() + 6);
    }

    public static TableCellRenderer getNumberCellRenderer() {
        return new AlternatingHighlightRenderer(4, NUMBER_FORMAT, true, -1);
    }

    public static TableCellRenderer getTextCellRenderer() {
        return new AlternatingHighlightRenderer(2, null, true, -1);
    }

    public static TableCellRenderer getHeaderTextCellRenderer() {
        return new AlternatingHighlightRenderer(2, null, true, 1);
    }

    public static class AlternatingHighlightRenderer
    extends DefaultTableCellRenderer {
        private final NumberFormat numberFormat;
        private final boolean doHighlight;
        private final int fontStyle;

        public AlternatingHighlightRenderer(int alignment, NumberFormat numberFormat, boolean doHighlight, int fontStyle) {
            this.setHorizontalAlignment(alignment);
            this.numberFormat = numberFormat;
            this.doHighlight = doHighlight;
            this.fontStyle = fontStyle;
        }

        @Override
        protected void setValue(Object value) {
            if (this.numberFormat != null) {
                if (value instanceof Number) {
                    super.setValue(this.numberFormat.format((Number)value));
                    return;
                }
                if (value instanceof String) {
                    try {
                        long lVal = Long.parseLong((String)value);
                        super.setValue(this.numberFormat.format(lVal));
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            super.setValue(value);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.fontStyle != -1) {
                result.setFont(table.getFont().deriveFont(this.fontStyle));
            }
            if (isSelected) {
                result.setForeground(table.getSelectionForeground());
                result.setBackground(table.getSelectionBackground());
            } else if (this.isSpecialHighlightRow(row)) {
                result.setForeground(COLOR_SPECIAL_FG);
                result.setBackground(COLOR_SPECIAL_BG);
            } else if (row % 2 != 0 && this.doHighlight) {
                result.setForeground(table.getForeground());
                result.setBackground(COLOR_ALTERNATING_HILITE);
            } else {
                result.setForeground(table.getForeground());
                result.setBackground(table.getBackground());
            }
            if (hasFocus && result instanceof JComponent) {
                ((JComponent)result).setBorder(TABLE_FOCUS_BORDER);
            }
            return result;
        }

        protected boolean isSpecialHighlightRow(int row) {
            return false;
        }
    }
}

