/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import org.omegat.util.PatternConsts;

public class XMLReader
extends Reader {
    private BufferedReader reader;
    private String encoding;
    private String eol;
    boolean readFirstTime = true;

    public String getEncoding() {
        return this.encoding;
    }

    public String getEol() {
        return this.eol;
    }

    public XMLReader(String fileName) throws IOException {
        this.reader = new BufferedReader(this.createReader(new FileInputStream(fileName)));
    }

    public XMLReader(InputStream is) throws IOException {
        this.reader = this.createReader(is);
    }

    public XMLReader(File file) throws IOException {
        this.reader = this.createReader(new FileInputStream(file));
    }

    private BufferedReader createReader(InputStream is) throws IOException {
        String buffer;
        Matcher matcher_xml;
        int char4;
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        is.mark(65536);
        this.encoding = null;
        int char1 = is.read();
        int char2 = is.read();
        int char3 = is.read();
        if (char1 == 254 && char2 == 255) {
            this.encoding = "UTF-16BE";
        }
        if (char1 == 255 && char2 == 254) {
            this.encoding = "UTF-16LE";
        }
        if (char1 == 239 && char2 == 187 && char3 == 191) {
            this.encoding = "UTF-8";
        }
        if (char1 >= 0 && char1 < 32 && char3 >= 0 && char3 < 32) {
            this.encoding = "UTF-16BE";
        }
        if (char2 >= 0 && char2 < 32 && (char4 = is.read()) >= 0 && char4 < 32) {
            this.encoding = "UTF-16LE";
        }
        is.reset();
        if (this.encoding != null) {
            return this.createReaderAndDetectEOL(is, this.encoding);
        }
        is.mark(65536);
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        if (len > 0 && (matcher_xml = PatternConsts.XML_ENCODING.matcher(buffer = new String(buf, 0, len))).find()) {
            this.encoding = matcher_xml.group(1);
        }
        is.reset();
        if (this.encoding != null) {
            return this.createReaderAndDetectEOL(is, this.encoding);
        }
        try {
            return this.createReaderAndDetectEOL(is, "UTF-8");
        }
        catch (Exception e) {
            return this.createReaderAndDetectEOL(is, null);
        }
    }

    private BufferedReader createReaderAndDetectEOL(InputStream is, String encoding) throws IOException {
        BufferedReader rd = new BufferedReader(encoding != null ? new InputStreamReader(is, encoding) : new InputStreamReader(is), 65536);
        rd.mark(65536);
        for (int i = 0; i < 65536; ++i) {
            char ch = (char)rd.read();
            if (ch == '\r' || ch == '\n') {
                if (this.eol == null) {
                    this.eol = "";
                } else if (this.eol.codePointAt(0) == ch) {
                    rd.reset();
                    return rd;
                }
                this.eol = this.eol + ch;
                if (this.eol.codePointCount(0, this.eol.length()) != 2) continue;
                rd.reset();
                return rd;
            }
            if (this.eol == null) continue;
            rd.reset();
            return rd;
        }
        this.eol = "\n";
        rd.reset();
        return rd;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.readFirstTime) {
            this.readFirstTime = false;
            this.reader.mark(1);
            int ch = this.reader.read();
            if (ch != 65279) {
                this.reader.reset();
            }
        }
        return this.reader.read(cbuf, off, len);
    }
}

