/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ja;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.Tagger;

public class JapaneseTagger
implements Tagger {
    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            AnalyzedToken at = this.asAnalyzedToken(word);
            l.add(at);
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += at.getToken().length();
        }
        return tokenReadings;
    }

    public final AnalyzedTokenReadings createNullToken(String token, int startPos) {
        return new AnalyzedTokenReadings(new AnalyzedToken(token, null, null), startPos);
    }

    public AnalyzedToken createToken(String token, String posTag) {
        return new AnalyzedToken(token, posTag, null);
    }

    private AnalyzedToken asAnalyzedToken(String word) {
        String[] parts = word.split(" ");
        if (parts.length != 3) {
            return new AnalyzedToken(" ", null, null);
        }
        return new AnalyzedToken(parts[0], parts[1], parts[2]);
    }

    public static final String arrayToString(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            buff.append(bytes[i] + " ");
        }
        return buff.toString();
    }
}

