/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.ja;

import java.util.ArrayList;
import java.util.List;
import net.java.sen.SenFactory;
import net.java.sen.StringTagger;
import net.java.sen.dictionary.Token;
import org.languagetool.tokenizers.Tokenizer;

public class JapaneseWordTokenizer
implements Tokenizer {
    private StringTagger stringtagger;

    private void init() {
        if (this.stringtagger == null) {
            this.stringtagger = SenFactory.getStringTagger(null);
        }
    }

    public List<String> tokenize(String text) {
        this.init();
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList tokens = new ArrayList();
        try {
            this.stringtagger.analyze(text, tokens);
        }
        catch (Exception e) {
            return ret;
        }
        for (Token token : tokens) {
            String basicForm = token.getMorpheme().getBasicForm().equalsIgnoreCase("*") ? token.getSurface() : token.getMorpheme().getBasicForm();
            ret.add(token.getSurface() + " " + token.getMorpheme().getPartOfSpeech() + " " + basicForm);
        }
        return ret;
    }
}

