/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.http;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Language;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.HttpCyclotis;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;
import org.silvestrislab.cyclotis.omegat.proj.HttpProjectMemory;
import org.silvestrislab.cyclotis.omegat.tm.HttpMemory;

public class TMXFormat
implements HttpOutputFormat {
    private DateFormat tmxDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public TMXFormat(String name) {
        int idx = name.indexOf("dateFormat");
        if (idx > 0) {
            if ((idx = (name = name.substring(idx) + 11).indexOf(";")) > 0) {
                name = name.substring(0, idx);
            }
            if ((idx = name.indexOf("!")) > 0) {
                String lang = name.substring(0, idx);
                String spec = name.substring(idx + 1);
                this.tmxDateFormat = new SimpleDateFormat(spec, new Locale(lang));
            }
        }
    }

    @Override
    public String MIME() {
        return "text/xml";
    }

    @Override
    public <T> List<T> readFromGet(HttpCyclotis<T> cyclotis, InputStream is, String encoding) throws Exception {
        XMLEventReader xmlEventReader = this.xmlInputFactory.createXMLEventReader(is, encoding);
        ArrayList<T> theList = new ArrayList<T>();
        TmxHandler<T> handler = new TmxHandler<T>(cyclotis);
        T next = handler.next(xmlEventReader);
        while (next != null) {
            theList.add(next);
        }
        return theList;
    }

    @Override
    public <T> Iterator<T> iterator(final HttpCyclotis<T> cyclotis, InputStream is, String encoding) {
        try {
            final XMLEventReader xmlEventReader = this.xmlInputFactory.createXMLEventReader(is, encoding);
            return new Iterator<T>(){
                private final TmxHandler<T> handler;
                private T current;
                {
                    this.handler = new TmxHandler(cyclotis);
                    this.current = this.handler.next(xmlEventReader);
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public T next() {
                    Object prev = this.current;
                    try {
                        this.current = this.handler.next(xmlEventReader);
                    }
                    catch (Exception e) {
                        this.current = null;
                    }
                    return prev;
                }
            };
        }
        catch (Exception e) {
            cyclotis.logException(e);
            return Collections.emptyIterator();
        }
    }

    @Override
    public PrepareTMXEntry buildTmxEntry(HttpMemory memory, Object args) {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        TmxHandler handler = (TmxHandler)args;
        handler.fillEntry(entry);
        String mem_name = entry.getPropValue("prop:Cyclotis:mem_name");
        entry.otherProperties = memory.store.fromDatabase(entry.otherProperties, entry);
        if (mem_name != null) {
            entry.otherProperties.add(new TMXProp("db.table.name", mem_name));
        }
        return entry;
    }

    @Override
    public ProjectMemory.ContextTMXEntry buildContextEntry(HttpProjectMemory memory, Object args) {
        ProjectMemory.ContextTMXEntry entry = new ProjectMemory.ContextTMXEntry();
        TmxHandler handler = (TmxHandler)args;
        handler.fillEntry((PrepareTMXEntry)entry);
        memory.keyStore.fillEntry(entry);
        memory.contextMode.fillEntry((Cyclotis)memory, entry, handler.context);
        try {
            entry.linked = TMXEntry.ExternalLinked.valueOf((String)entry.getPropValue("externalLinked"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry;
    }

    @Override
    public GlossaryEntry buildGlossaryEntry(Object args, boolean priority) {
        TmxHandler handler = (TmxHandler)args;
        if (handler.note == null) {
            handler.note = "";
        }
        return new GlossaryEntry(handler.source, handler.target, handler.note, priority);
    }

    class TmxHandler<T> {
        ProjectProperties prop = Core.getProject().getProjectProperties();
        Language srcLang = this.prop.getSourceLanguage();
        Language traLang = this.prop.getTargetLanguage();
        String lang = "";
        String source = "";
        String target = "";
        String note = "";
        List<TMXProp> tmxAttributes = new ArrayList<TMXProp>();
        String author = "";
        String changer = "";
        Date creationDate = new Date(0L);
        Date changeDate = new Date(0L);
        int score = 100;
        String context = "";
        final HttpCyclotis<T> cyclotis;

        public TmxHandler(HttpCyclotis<T> cyclotis) {
            this.cyclotis = cyclotis;
        }

        public void startElement(StartElement el) {
            String localName = el.getName().getLocalPart();
            if (localName.startsWith("tu")) {
                this.author = el.getAttributeByName(new QName("creationid")).getValue();
                this.creationDate = this.parseDate(el.getAttributeByName(new QName("creationdate")).getValue());
                this.changer = el.getAttributeByName(new QName("changeid")).getValue();
                this.changeDate = this.parseDate(el.getAttributeByName(new QName("changedate")).getValue());
            }
            if (localName.equals("tuv")) {
                this.lang = el.getAttributeByName(new QName("", "lang", "xml")).getValue();
                if (this.lang == null || this.lang.length() == 0) {
                    if (this.target.length() == 0) {
                        this.lang = "x-src";
                    }
                    if (this.source.length() == 0) {
                        this.lang = "x-tra";
                    }
                }
                if (this.lang.equalsIgnoreCase(this.srcLang.getLanguage())) {
                    this.lang = "x-src";
                }
                if (this.lang.equalsIgnoreCase(this.srcLang.getLanguageCode())) {
                    this.lang = "x-src";
                }
                if (this.lang.equalsIgnoreCase(this.srcLang.getLocaleCode())) {
                    this.lang = "x-src";
                }
                if (this.lang.equalsIgnoreCase(this.traLang.getLanguage())) {
                    this.lang = "x-tra";
                }
                if (this.lang.equalsIgnoreCase(this.traLang.getLanguageCode())) {
                    this.lang = "x-tra";
                }
                if (this.lang.equalsIgnoreCase(this.traLang.getLocaleCode())) {
                    this.lang = "x-tra";
                }
            }
            if (localName.equalsIgnoreCase("note")) {
                this.lang = "note:";
            }
            if (localName.equalsIgnoreCase("prop")) {
                this.lang = "prop:" + el.getAttributeByName(new QName("type")).getValue();
            }
        }

        private Date parseDate(String txt) {
            try {
                return TMXFormat.this.tmxDateFormat.parse(txt);
            }
            catch (Exception e1) {
                TMXFormat.this.tmxDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
                try {
                    return TMXFormat.this.tmxDateFormat.parse(txt);
                }
                catch (Exception e2) {
                    return new Date(0L);
                }
            }
        }

        public void characters(String data) {
            if (this.lang.equalsIgnoreCase("x-src")) {
                this.source = this.source + data;
            }
            if (this.lang.equalsIgnoreCase("x-tra")) {
                this.target = this.target + data;
            }
            if (this.lang.equalsIgnoreCase("note:")) {
                this.note = this.note + data;
            }
            if (this.lang.startsWith("prop:")) {
                this.tmxAttributes.add(new TMXProp(this.lang.substring(5), data));
            }
            if (this.lang.equalsIgnoreCase("prop:Cyclotis:score")) {
                try {
                    this.score = (int)(100.0 * (double)Integer.parseInt(data));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.lang.equalsIgnoreCase("prop:Cyclotis:mem_name")) {
                this.tmxAttributes.add(new TMXProp("Row.Table", data));
            }
        }

        public void fillEntry(PrepareTMXEntry entry) {
            try {
                entry.source = this.cyclotis.reformatText(this.source, true);
                entry.translation = this.cyclotis.reformatText(this.target, true);
                entry.creator = this.author;
                entry.creationDate = this.creationDate.getTime();
                entry.changer = this.changer;
                entry.changeDate = this.changeDate.getTime();
                entry.note = this.note;
                entry.otherProperties = this.tmxAttributes;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public T next(XMLEventReader xmlEventReader) throws XMLStreamException {
            block11: while (xmlEventReader.hasNext()) {
                XMLEvent current = xmlEventReader.nextEvent();
                switch (current.getEventType()) {
                    case 1: {
                        XMLEvent el2;
                        try {
                            el2 = (StartElement)current;
                            this.cyclotis.logMessage("http-response", "HTTP-XML: start " + el2.getName());
                            this.startElement((StartElement)el2);
                        }
                        catch (ClassCastException el2) {}
                        break;
                    }
                    case 4: {
                        XMLEvent el2;
                        try {
                            el2 = (Characters)current;
                            this.cyclotis.logMessage("http-response", "HTTP-XML: characters " + el2.getData());
                            this.characters(el2.getData());
                        }
                        catch (ClassCastException el) {}
                        break;
                    }
                    case 2: {
                        XMLEvent el2;
                        try {
                            el2 = (EndElement)current;
                            this.cyclotis.logMessage("http-response", "HTTP-XML: end " + el2.getName());
                            if (el2.getName().getLocalPart().equals("tu")) {
                                return this.cyclotis.analyzeLine(TMXFormat.this, this);
                            }
                            if (!el2.getName().getLocalPart().equals("body")) continue block11;
                            return null;
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                }
            }
            return null;
        }
    }
}

