/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.tm;

import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.core.search.ISearchable;
import org.omegat.core.search.TextExpression;
import org.omegat.util.Language;
import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;
import org.silvestrislab.cyclotis.omegat.tm.SaveConditions;

public class HttpMemory
extends HttpCyclotisTMX<PrepareTMXEntry>
implements IWritableExternalMemory,
ISearchable<PrepareTMXEntry> {
    protected static final String LINE_FORMAT = "otadcupnN";
    private SaveConditions conditions;

    public HttpMemory(Properties propList) {
        super(propList);
        if (propList.getProperty("update") != null) {
            String updateString = propList.getProperty("update");
            this.conditions = !updateString.equalsIgnoreCase("false") ? SaveConditions.forProperty(updateString) : null;
        } else if (propList.getProperty("table.exclude") != null) {
            this.urlFind = this.urlFind + "?exclude=" + propList.getProperty("table.exclude");
            this.conditions = null;
        } else {
            this.conditions = null;
        }
        System.out.println(this.getMemoryName() + (this.conditions == null ? " update = false" : " update condition = " + this.conditions));
    }

    public HttpMemory(HttpCyclotisTMX ori) {
        super(ori);
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        this.logMessage("search", "Searching for <" + this.digest(text) + "> '" + text + "'");
        return this.httpGetAll("fuzzy", LINE_FORMAT, this.reduceWords(text));
    }

    @Override
    public PrepareTMXEntry analyzeLine(HttpOutputFormat fmt, Object args) {
        return fmt.buildTmxEntry(this, args);
    }

    public boolean isWriteMode() {
        return this.conditions != null;
    }

    public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        return this.conditions.mustWrite(this, entryContents, entrySource);
    }

    public void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
        entryContents.otherProperties = this.store.toDatabase(entryContents, entrySource);
        this.registerTranslation(entryContents);
    }

    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, long dateAfter, long dateBefore) throws Exception {
        if (andSearch) {
            Iterable<PrepareTMXEntry> I;
            if (searchSource != null && (I = this.searchTextExpression("Src", searchSource)) != null) {
                return I;
            }
            if (searchTarget != null && (I = this.searchTextExpression("Tra", searchTarget)) != null) {
                return I;
            }
            if (searchNotes != null && (I = this.searchTextExpression("Note", searchNotes)) != null) {
                return I;
            }
        } else {
            String field = null;
            TextExpression expr = null;
            if (searchSource != null) {
                if (searchTarget != null && searchTarget.equals(searchSource)) {
                    if (searchNotes != null && searchNotes.equals(searchSource)) {
                        field = "Any";
                        expr = searchSource;
                    }
                } else if (searchNotes != null && searchNotes.equals(searchSource)) {
                    field = "SegAny";
                    expr = searchSource;
                }
            } else if (searchTarget != null) {
                if (searchNotes == null) {
                    field = "Tra";
                    expr = searchTarget;
                }
            } else if (searchNotes != null) {
                field = "Note";
                expr = searchNotes;
            }
            if (field != null && expr != null) {
                return this.searchTextExpression(field, expr);
            }
        }
        if (dateAfter < Long.MAX_VALUE) {
            return this.httpGetIterable("all", LINE_FORMAT, new Timestamp(dateAfter).toString());
        }
        return this.getEntries();
    }

    private Iterable<PrepareTMXEntry> searchTextExpression(String field, TextExpression expr) throws Exception {
        if (expr instanceof TextExpression.RegexTextExpression) {
            TextExpression.RegexTextExpression RE = (TextExpression.RegexTextExpression)expr;
            return this.httpGetIterable((RE.getPattern().flags() & 2) == 0 ? "regex" + field : "iregex" + field, LINE_FORMAT, RE.getPattern().pattern());
        }
        if (expr instanceof TextExpression.WordsTokenExpression) {
            if (field.equals("Note")) {
                return null;
            }
            TextExpression.WordsTokenExpression RE = (TextExpression.WordsTokenExpression)expr;
            StringBuffer buf = new StringBuffer();
            for (TextExpression.ExactTokenExpression word : RE.split()) {
                buf.append("  ").append(word);
            }
            return this.httpGetIterable("conc" + field, LINE_FORMAT, buf.toString());
        }
        return null;
    }

    public Iterable<PrepareTMXEntry> getEntries() throws Exception {
        this.logMessage("search", "Searching for all entries");
        return this.httpGetIterable("all", LINE_FORMAT, "1900-01-01");
    }
}

