/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.madlonkay.supertmxmerge.CombineIOController;
import org.madlonkay.supertmxmerge.DiffIOController;
import org.madlonkay.supertmxmerge.MergeController;
import org.madlonkay.supertmxmerge.MergeIOController;
import org.madlonkay.supertmxmerge.StmProperties;
import org.madlonkay.supertmxmerge.data.DiffAnalysis;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.MergeAnalysis;
import org.madlonkay.supertmxmerge.data.Report;
import org.madlonkay.supertmxmerge.data.ResolutionSet;
import org.madlonkay.supertmxmerge.gui.FileSelectWindow;
import org.madlonkay.supertmxmerge.util.DiffUtil;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;
import org.omegat.core.data.OmTTmx;
import org.omegat.core.data.ProjectTMX;

public class SuperTmxMerge {
    private static final Logger LOGGER = Logger.getLogger(SuperTmxMerge.class.getName());

    public static void diff(File file1, File file2) {
        DiffIOController controller = new DiffIOController();
        controller.setFile1(file1);
        controller.setFile2(file2);
        controller.go();
    }

    public static void diffTo(File file1, File file2, File outFile) {
        DiffIOController controller = new DiffIOController();
        controller.setFile1(file1);
        controller.setFile2(file2);
        controller.setOutputFile(outFile);
        controller.go();
    }

    public static File merge(File baseFile, File file1, File file2) {
        MergeIOController controller = new MergeIOController();
        controller.setBaseFile(baseFile);
        controller.setFile1(file1);
        controller.setFile2(file2);
        controller.setOutputFile(null);
        controller.go();
        return controller.getOutputFile();
    }

    public static ProjectTMX merge(ProjectTMX baseTmx, ProjectTMX tmx1, ProjectTMX tmx2, String sourceLanguage, String targetLanguage, StmProperties properties) {
        if (properties == null) {
            properties = new StmProperties();
        }
        LocString.addBundle(properties.getLanguageResource());
        MergeController controller = new MergeController();
        controller.setQuiet(true);
        controller.setIsModal(true);
        controller.setCanCancel(false);
        controller.setParentWindow(properties.getParentWindow());
        controller.setListViewThreshold(properties.getListViewThreshold());
        OmTTmx base = new OmTTmx(baseTmx, properties.getBaseTmxName(), sourceLanguage, targetLanguage);
        OmTTmx one = new OmTTmx(tmx1, properties.geTmx1Name(), sourceLanguage, targetLanguage);
        OmTTmx two = new OmTTmx(tmx2, properties.getTmx2Name(), sourceLanguage, targetLanguage);
        MergeAnalysis analysis = controller.analyze(base, one, two);
        ResolutionSet resolution = controller.resolve(properties.getResolutionStrategy());
        ITmx wrappedResult = controller.apply(resolution);
        if (wrappedResult != null) {
            DiffAnalysis diff = DiffUtil.mapDiff(two, wrappedResult);
            properties.setReport(new Report(analysis, diff));
            return (ProjectTMX)wrappedResult.getUnderlyingRepresentation();
        }
        return null;
    }

    public static void mergeTo(File baseFile, File file1, File file2, File outputFile) {
        MergeIOController controller = new MergeIOController();
        controller.setBaseFile(baseFile);
        controller.setFile1(file1);
        controller.setFile2(file2);
        controller.setOutputFile(outputFile);
        controller.go();
    }

    public static void combine(File ... files) {
        SuperTmxMerge.combineTo(null, files);
    }

    public static void combineTo(File outputFile, File ... files) {
        CombineIOController controller = new CombineIOController();
        controller.setFiles(files);
        controller.setOutputFile(outputFile);
        controller.go();
    }

    public static void promptForFiles() {
        JFrame window = FileSelectWindow.newAsFrame();
        GuiUtil.displayWindow(window);
    }
}

