/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.tika.language.LanguageIdentifier;
import org.apache.tika.language.LanguageProfile;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;

public class LanguageIdentifierTools {
    public static void addLtProfiles() {
        for (Language language : Language.REAL_LANGUAGES) {
            LanguageIdentifierTools.addProfile(language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addProfile(Language language) {
        String PROFILE_SUFFIX = ".ngp";
        String PROFILE_ENCODING = "UTF-8";
        try {
            LanguageProfile profile = new LanguageProfile();
            String languageCode = language.getShortName();
            String detectionFile = "/" + languageCode + "/" + languageCode + ".ngp";
            if (!JLanguageTool.getDataBroker().resourceExists(detectionFile)) {
                return;
            }
            InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(detectionFile);
            try {
                InputStreamReader in = new InputStreamReader(stream, "UTF-8");
                BufferedReader reader = new BufferedReader(in);
                String line = reader.readLine();
                while (line != null) {
                    if (line.length() > 0 && !line.startsWith("#")) {
                        int space = line.indexOf(32);
                        profile.add(line.substring(0, space), Long.parseLong(line.substring(space + 1)));
                    }
                    line = reader.readLine();
                }
            }
            finally {
                stream.close();
            }
            LanguageIdentifier.addProfile((String)languageCode, (LanguageProfile)profile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed trying to load language profile for language \"" + language + "\".", e);
        }
    }
}

