/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.io.File;
import java.util.ArrayList;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.madlonkay.supertmxmerge.SuperTmxMerge;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class Main {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "SuperTMXMerge");
        }
        catch (UnsupportedLookAndFeelException ex) {
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        final String[] theArgs = args;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (theArgs.length == 0) {
                        SuperTmxMerge.promptForFiles();
                        return;
                    }
                    if ("--combine".equals(theArgs[0])) {
                        int i;
                        ArrayList<File> files = new ArrayList<File>();
                        File outputFile = null;
                        for (i = 1; i < theArgs.length && !"-o".equals(theArgs[i]); ++i) {
                            File file = new File(theArgs[i]);
                            if (files.contains(file)) continue;
                            files.add(file);
                        }
                        if (i < theArgs.length - 1) {
                            outputFile = new File(theArgs[i + 1]);
                        }
                        SuperTmxMerge.combineTo(outputFile, files.toArray(new File[0]));
                        return;
                    }
                    if (theArgs.length == 2) {
                        SuperTmxMerge.diff(new File(theArgs[0]), new File(theArgs[1]));
                        return;
                    }
                    if (theArgs.length == 3) {
                        SuperTmxMerge.merge(new File(theArgs[0]), new File(theArgs[1]), new File(theArgs[2]));
                        return;
                    }
                    if (theArgs.length == 4) {
                        if (theArgs[2].equals("-o")) {
                            SuperTmxMerge.diffTo(new File(theArgs[0]), new File(theArgs[1]), new File(theArgs[3]));
                            return;
                        }
                        SuperTmxMerge.mergeTo(new File(theArgs[0]), new File(theArgs[1]), new File(theArgs[2]), new File(theArgs[3]));
                        return;
                    }
                    Main.printUsage();
                }
                catch (Exception ex) {
                    System.err.println(ex.getLocalizedMessage());
                }
            }
        };
        GuiUtil.safelyRunBlockingRoutine(run);
    }

    private static void printUsage() {
        System.out.print(LocString.get("STM_USAGE_DIRECTIONS"));
    }
}

