/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary.taas;

import gen.taas.TaasCollection;
import gen.taas.TaasCollectionType;
import gen.taas.TaasDomain;
import gen.taas.TaasLanguage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.omegat.core.Core;
import org.omegat.gui.glossary.taas.BrowseTaasCollectionsUI;
import org.omegat.gui.glossary.taas.TaaSClient;
import org.omegat.gui.glossary.taas.TaaSPlugin;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;

public class BrowseTaasCollectionsController {
    static BrowseTaasCollectionsUI dialog;
    static DefaultTableCellRenderer NAME_CELL_RENDERER;
    static ActionListener DOWNLOAD_LISTENER;

    public static void show() {
        dialog = new BrowseTaasCollectionsUI((Frame)Core.getMainWindow().getApplicationFrame(), true);
        final Language sourceLang = Core.getProject().getProjectProperties().getSourceLanguage();
        final Language targetLang = Core.getProject().getProjectProperties().getTargetLanguage();
        List<TaasCollection> list = Collections.emptyList();
        CollectionsTable model = new CollectionsTable(list, sourceLang, targetLang);
        BrowseTaasCollectionsController.dialog.tableCollections.setModel(model);
        BrowseTaasCollectionsController.dialog.tableCollections.setColumnModel(BrowseTaasCollectionsController.createColumnModel());
        BrowseTaasCollectionsController.dialog.labelStatus.setText(OStrings.getString((String)"TAAS_STATUS_LIST"));
        new SwingWorker<List<TaasCollection>, Void>(){

            @Override
            protected List<TaasCollection> doInBackground() throws Exception {
                return TaaSPlugin.client.getCollectionsList();
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    BrowseTaasCollectionsController.removeUnusedCollections(list);
                    CollectionsTable model = new CollectionsTable(list, sourceLang, targetLang);
                    BrowseTaasCollectionsController.dialog.tableCollections.setModel(model);
                    TableRowSorter<CollectionsTable> sorter = new TableRowSorter<CollectionsTable>(model);
                    BrowseTaasCollectionsController.dialog.tableCollections.setRowSorter(sorter);
                    sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
                    BrowseTaasCollectionsController.dialog.tableCollections.setColumnModel(BrowseTaasCollectionsController.createColumnModel());
                    BrowseTaasCollectionsController.dialog.labelStatus.setText(" ");
                }
                catch (ExecutionException e) {
                    Throwable ex = e.getCause();
                    if (ex instanceof TaaSClient.FormatError) {
                        Log.logErrorRB((Throwable)ex, (String)"TAAS_FORMAT_ERROR", (Object[])new Object[]{ex.getMessage()});
                        BrowseTaasCollectionsController.dialog.labelStatus.setText(OStrings.getString((String)"TAAS_FORMAT_ERROR"));
                    } else if (ex instanceof TaaSClient.Unauthorized) {
                        Log.logErrorRB((Throwable)ex, (String)"TAAS_UNAUTHORIZED_ERROR", (Object[])new Object[0]);
                        BrowseTaasCollectionsController.dialog.labelStatus.setText(OStrings.getString((String)"TAAS_UNAUTHORIZED_ERROR"));
                    } else {
                        Log.logErrorRB((Throwable)ex, (String)"TAAS_GENERAL_ERROR", (Object[])new Object[]{ex.getMessage()});
                        BrowseTaasCollectionsController.dialog.labelStatus.setText(MessageFormat.format(OStrings.getString((String)"TAAS_GENERAL_ERROR"), ex.getMessage()));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.execute();
        BrowseTaasCollectionsController.dialog.btnDownload.addActionListener(DOWNLOAD_LISTENER);
        StaticUIUtils.setEscapeClosable((JDialog)dialog);
        BrowseTaasCollectionsController.dialog.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        DockingUI.displayCentered((Window)dialog);
        dialog.setVisible(true);
    }

    static void removeUnusedCollections(List<TaasCollection> list) {
        Language sourceLang = Core.getProject().getProjectProperties().getSourceLanguage();
        Language targetLang = Core.getProject().getProjectProperties().getTargetLanguage();
        for (int i = 0; i < list.size(); ++i) {
            TaasCollection c = list.get(i);
            if (BrowseTaasCollectionsController.getCountForLanguage(c, sourceLang) != 0 && BrowseTaasCollectionsController.getCountForLanguage(c, targetLang) != 0) continue;
            list.remove(i);
            --i;
        }
    }

    static int getCountForLanguage(TaasCollection c, Language lang) {
        String langCode = lang.getLanguageCode();
        for (TaasLanguage l : c.getLanguages().getLanguage()) {
            if (!langCode.equalsIgnoreCase(l.getId())) continue;
            return l.getCount();
        }
        return 0;
    }

    static TableColumnModel createColumnModel() {
        DefaultTableColumnModel columns = new DefaultTableColumnModel();
        TableColumn cName = new TableColumn(0, 150);
        cName.setHeaderValue(OStrings.getString((String)"TAAS_LIST_NAME"));
        cName.setCellRenderer(NAME_CELL_RENDERER);
        TableColumn cDesc = new TableColumn(1, 150);
        cDesc.setHeaderValue(OStrings.getString((String)"TAAS_LIST_DESC"));
        TableColumn cSource = new TableColumn(2, 50);
        cSource.setHeaderValue(OStrings.getString((String)"TAAS_LIST_SOURCE_COUNT"));
        TableColumn cTarget = new TableColumn(3, 50);
        cTarget.setHeaderValue(OStrings.getString((String)"TAAS_LIST_TARGET_COUNT"));
        TableColumn cDomains = new TableColumn(4, 150);
        cDomains.setHeaderValue(OStrings.getString((String)"TAAS_LIST_DOMAINS"));
        TableColumn cUpdated = new TableColumn(5, 50);
        cUpdated.setHeaderValue(OStrings.getString((String)"TAAS_LIST_UPDATED"));
        TableColumn cDownload = new TableColumn(6, 50);
        cDownload.setHeaderValue("");
        columns.addColumn(cDownload);
        columns.addColumn(cName);
        columns.addColumn(cDesc);
        columns.addColumn(cSource);
        columns.addColumn(cTarget);
        columns.addColumn(cDomains);
        columns.addColumn(cUpdated);
        return columns;
    }

    static File getFileForCollection(TaasCollection collection) {
        File dir = new File(Core.getProject().getProjectProperties().getGlossaryRoot());
        return new File(dir, "TaaS-" + collection.getId() + ".tbx");
    }

    static {
        NAME_CELL_RENDERER = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                List<TaasCollection> list = ((CollectionsTable)BrowseTaasCollectionsController.dialog.tableCollections.getModel()).list;
                if (list.get(row).getType() == TaasCollectionType.PRIVATE) {
                    c.setFont(c.getFont().deriveFont(1));
                }
                return c;
            }
        };
        DOWNLOAD_LISTENER = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final List<TaasCollection> list = ((CollectionsTable)BrowseTaasCollectionsController.dialog.tableCollections.getModel()).list;
                final boolean[] marks = ((CollectionsTable)BrowseTaasCollectionsController.dialog.tableCollections.getModel()).marks;
                new SwingWorker<Object, String>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        for (int i = 0; i < list.size(); ++i) {
                            TaasCollection c = (TaasCollection)list.get(i);
                            if (!marks[i]) continue;
                            this.publish(c.getName());
                            File glossaryFile = BrowseTaasCollectionsController.getFileForCollection(c);
                            File newFile = new File(glossaryFile.getAbsolutePath() + ".new");
                            TaaSPlugin.client.downloadCollection(c.getId(), newFile);
                            if (glossaryFile.exists()) {
                                glossaryFile.delete();
                            }
                            if (newFile.renameTo(glossaryFile)) continue;
                            BrowseTaasCollectionsController.dialog.labelStatus.setText(OStrings.getString((String)"TAAS_REPLACE_ERROR"));
                            return null;
                        }
                        return null;
                    }

                    @Override
                    protected void process(List<String> chunks) {
                        for (String n : chunks) {
                            BrowseTaasCollectionsController.dialog.labelStatus.setText(MessageFormat.format(OStrings.getString((String)"TAAS_STATUS_DOWNLOAD"), n));
                        }
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            BrowseTaasCollectionsController.dialog.labelStatus.setText(" ");
                            BrowseTaasCollectionsController.dialog.tableCollections.repaint();
                        }
                        catch (ExecutionException e) {
                            Throwable ex = e.getCause();
                            if (ex instanceof TaaSClient.FormatError) {
                                Log.logErrorRB((Throwable)ex, (String)"TAAS_FORMAT_ERROR", (Object[])new Object[]{ex.getMessage()});
                                BrowseTaasCollectionsController.dialog.labelStatus.setText(OStrings.getString((String)"TAAS_FORMAT_ERROR"));
                            } else if (ex instanceof TaaSClient.Unauthorized) {
                                Log.logErrorRB((Throwable)ex, (String)"TAAS_UNAUTHORIZED_ERROR", (Object[])new Object[0]);
                                BrowseTaasCollectionsController.dialog.labelStatus.setText(OStrings.getString((String)"TAAS_UNAUTHORIZED_ERROR"));
                            } else {
                                Log.logErrorRB((Throwable)ex, (String)"TAAS_GENERAL_ERROR", (Object[])new Object[]{ex.getMessage()});
                                BrowseTaasCollectionsController.dialog.labelStatus.setText(MessageFormat.format(OStrings.getString((String)"TAAS_GENERAL_ERROR"), ex.getMessage()));
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }.execute();
            }
        };
    }

    public static class CollectionsTable
    extends AbstractTableModel {
        final List<TaasCollection> list;
        final boolean[] marks;
        final Language source;
        final Language target;

        public CollectionsTable(List<TaasCollection> list, Language source, Language target) {
            this.list = list;
            this.marks = new boolean[list.size()];
            this.source = source;
            this.target = target;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return Boolean.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TaasCollection c = this.list.get(rowIndex);
            File glossaryFile = BrowseTaasCollectionsController.getFileForCollection(c);
            switch (columnIndex) {
                case 0: {
                    return c.getName();
                }
                case 1: {
                    return c.getDescription();
                }
                case 2: {
                    return BrowseTaasCollectionsController.getCountForLanguage(c, this.source);
                }
                case 3: {
                    return BrowseTaasCollectionsController.getCountForLanguage(c, this.target);
                }
                case 4: {
                    StringBuilder o = new StringBuilder(200);
                    for (TaasDomain d : c.getDomains().getDomain()) {
                        o.append('/').append(d.getName());
                    }
                    return o.substring(1);
                }
                case 5: {
                    if (glossaryFile.exists()) {
                        String sc;
                        Date m = new Date(glossaryFile.lastModified());
                        String sm = DateFormat.getDateInstance().format(m);
                        if (sm.equals(sc = DateFormat.getDateInstance().format(new Date()))) {
                            sm = DateFormat.getTimeInstance().format(m);
                        }
                        return sm;
                    }
                    return "";
                }
                case 6: {
                    return this.marks[rowIndex];
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 6;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 6) {
                this.marks[rowIndex] = (Boolean)aValue;
            }
        }
    }
}

