/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.MenuMemory;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.WikiGet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MyMemory
extends MenuMemory {
    private static final String MYMEMORY_API_EMAIL = "mymemory.api.email";
    protected static String GT_URL = "https://mymemory.translated.net/api/get?q=";
    protected static String GT_URL2 = "&langpair=#sourceLang#|#targetLang#&of=#format#";
    protected static String XPATH_QUERY_ALL_TU = "//tu";
    protected static String XPATH_QUERY_TUV = "child::tuv[starts-with(@lang, '#langCode#')]/seg/text()";
    protected static final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    protected static final XPathFactory xpathFactory = XPathFactory.newInstance();
    public static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);

    protected String mymemoryCode(Language language) {
        String lCode = language.getLanguageCode().toLowerCase();
        return lCode;
    }

    protected String buildMyMemoryUrl(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException {
        String sourceLang = this.mymemoryCode(sLang);
        String targetLang = this.mymemoryCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang).replace("#format#", format);
        String url = GT_URL + URLEncoder.encode(text, "UTF-8") + url2;
        return url;
    }

    protected String getMyMemoryResponse(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException, IOException {
        String url = this.buildMyMemoryUrl(sLang, tLang, text, format);
        String email = System.getProperty(MYMEMORY_API_EMAIL);
        if (email != null && !"".equals(email)) {
            url = url + "&de=" + email;
        }
        String myMemoryResponse = "";
        myMemoryResponse = WikiGet.getURL((String)url);
        return myMemoryResponse;
    }

    protected String cleanUpText(String str) {
        str = str.replace("&quot;", "\"");
        str = str.replace("&nbsp;", "\u00a0");
        str = str.replace("&amp;", "&");
        str = str.replace("&apos;", "'");
        str = str.replace("&#39;", "'");
        str = str.replace("&lt;", "<");
        str = str.replace("&gt;", ">");
        str = str.trim();
        return str;
    }

    protected String getPreferenceName() {
        return "allow_mymemory_translation_memory";
    }

    public String getProviderName() {
        return OStrings.getString((String)"MT_ENGINE_MYMEMORY_HUMAN");
    }

    public String getMemoryName() {
        return OStrings.getString((String)"MT_ENGINE_MYMEMORY_HUMAN");
    }

    public List<PrepareTMXEntry> retreiveMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        String tmxResponse = "";
        try {
            tmxResponse = this.getMyMemoryResponse(sLang, tLang, text, "tmx");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
        tmxResponse = tmxResponse.replace("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">", "");
        tmxResponse = tmxResponse.replace("&", "&amp;");
        tmxResponse = this.getXMLString(tmxResponse);
        InputSource source = new InputSource(new StringReader(tmxResponse));
        Document document = docFactory.newDocumentBuilder().parse(source);
        XPath xpath = xpathFactory.newXPath();
        XPathExpression expr = xpath.compile(XPATH_QUERY_ALL_TU);
        Object result = expr.evaluate(document, XPathConstants.NODESET);
        NodeList allTUs = (NodeList)result;
        if (allTUs.getLength() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>(allTUs.getLength());
        String targetSegQueryString = XPATH_QUERY_TUV.replace("#langCode#", tLang.getLanguageCode());
        String sourceSegQueryString = XPATH_QUERY_TUV.replace("#langCode#", sLang.getLanguageCode());
        for (int i = 0; i < allTUs.getLength(); ++i) {
            Element tu = (Element)allTUs.item(i);
            PrepareTMXEntry entry = new PrepareTMXEntry();
            entry.source = xpath.evaluate(sourceSegQueryString, tu);
            entry.translation = xpath.evaluate(targetSegQueryString, tu);
            try {
                entry.creator = tu.getAttribute("creationid");
                entry.creationDate = dateFormat1.parse(tu.getAttribute("creationdate")).getTime();
                entry.changer = tu.getAttribute("changeid");
                entry.changeDate = dateFormat1.parse(tu.getAttribute("changedate")).getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            entries.add(entry);
        }
        return entries;
    }

    protected String getXMLString(String str) {
        int XMLHeader = str.indexOf("<?xml");
        if (XMLHeader != -1) {
            str = str.substring(XMLHeader);
        }
        return str;
    }
}

