/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class DockingSelectorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int CONFIRM = 0;
    public static final int CANCEL = 1;
    private DockablesTableModel model;
    private DockingDesktop desktop;
    private static final String TITLE = "Docking Configuration";
    private JButton confirmButton = new JButton("Ok");
    private JButton cancelButton = new JButton("Cancel");
    private JTable table = new JTable();
    JLabel wizardLabel = new JLabel(){
        private static final long serialVersionUID = 1L;

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Paint p = g2.getPaint();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, this.getWidth(), 0.0f, this.getBackground()));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setPaint(p);
            super.paintComponent(g);
        }
    };
    private String wizardLabelText = "<HTML><BODY><P>This window helps you to manage the  views composing your application workspace.</P><P><P>By clicking on the table checkboxes below, you can select if a view will be diplayed or not </P> <P><P> Click on the <b>Ok</b> button to apply your changes or on the <b>Cancel</b> button if you do not want to save your changes. </BODY></HTML>";
    private int closingState = 1;
    private HashMap<DockableState, Boolean> visibleViews = new HashMap();

    public DockingSelectorDialog() {
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setTitle(TITLE);
        this.init();
    }

    public DockingSelectorDialog(Dialog owner) {
        super(owner, true);
        this.setDefaultCloseOperation(2);
        this.setTitle(TITLE);
        this.init();
    }

    public DockingSelectorDialog(Frame owner) {
        super(owner, true);
        this.setDefaultCloseOperation(2);
        this.setTitle(TITLE);
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JScrollPane jsp = new JScrollPane(this.table);
        jsp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), jsp.getBorder()));
        this.getContentPane().add((Component)jsp, "Center");
        this.confirmButton.setToolTipText("Close this window and update the views");
        this.cancelButton.setToolTipText("Close this window without updating the views");
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DockingSelectorDialog.this.closingState = 0;
                int i = 0;
                while (i < DockingSelectorDialog.this.model.states.length) {
                    boolean oldVisible;
                    DockableState state = DockingSelectorDialog.this.model.states[i];
                    boolean newVisible = (Boolean)DockingSelectorDialog.this.visibleViews.get(state);
                    boolean bl = oldVisible = state.getLocation() != DockableState.Location.CLOSED;
                    if (oldVisible != newVisible) {
                        if (newVisible) {
                            DockingSelectorDialog.this.desktop.addDockable(state.getDockable(), state.getPosition());
                        } else {
                            DockingSelectorDialog.this.desktop.close(state.getDockable());
                        }
                    }
                    ++i;
                }
                DockingSelectorDialog.this.dispose();
            }
        });
        AbstractAction closeAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DockingSelectorDialog.this.closingState = 1;
                DockingSelectorDialog.this.dispose();
            }
        };
        this.cancelButton.setAction(closeAction);
        JPanel buttons = new JPanel(new FlowLayout(4));
        JPanel grid = new JPanel(new GridLayout(1, 0, 5, 0));
        grid.add(this.confirmButton);
        grid.add(this.cancelButton);
        buttons.add(grid);
        this.getContentPane().add((Component)buttons, "South");
        this.wizardLabel.setText(this.wizardLabelText);
        this.wizardLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.getContentPane().add((Component)this.wizardLabel, "North");
        KeyStroke ESC = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(ESC, "CLOSE");
        this.getRootPane().getActionMap().put("CLOSE", closeAction);
        this.table.getInputMap(1).put(ESC, "CLOSE");
        this.table.getActionMap().put("CLOSE", closeAction);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                DockingSelectorDialog.this.getRootPane().setDefaultButton(DockingSelectorDialog.this.confirmButton);
            }
        });
    }

    public void setConfirmButtonText(String text) {
        this.confirmButton.setText(text);
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public void setConfirmButtonTooltipText(String text) {
        this.confirmButton.setToolTipText(text);
    }

    public void setCancelButtonTooltipText(String text) {
        this.cancelButton.setToolTipText(text);
    }

    public void setWizardLabelText(String wizardLabelText) {
        this.wizardLabel.setText(wizardLabelText);
    }

    public void setDockingDesktop(DockingDesktop desktop) {
        this.desktop = desktop;
        Object[] states = desktop.getDockables();
        Arrays.sort(states);
        this.model = new DockablesTableModel((DockableState[])states);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.table.setCellSelectionEnabled(true);
        this.table.setShowVerticalLines(false);
        this.table.setRowHeight(20);
    }

    public int getClosingState() {
        return this.closingState;
    }

    class DockablesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        String[] colNames = new String[]{" ", "Name", "Visible"};
        private DockableState[] states;

        DockablesTableModel(DockableState[] states) {
            this.states = states;
            int i = 0;
            while (i < states.length) {
                DockingSelectorDialog.this.visibleViews.put(states[i], states[i].getLocation() == DockableState.Location.CLOSED ? Boolean.FALSE : Boolean.TRUE);
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return this.states.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col != 2) {
                return false;
            }
            Dockable dockable = this.states[row].getDockable();
            return dockable.getDockKey().isCloseEnabled();
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Icon.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DockableState state = this.states[row];
            switch (col) {
                case 0: {
                    return state.getDockable().getDockKey().getIcon();
                }
                case 1: {
                    return state.getDockable().getDockKey().getName();
                }
                case 2: {
                    return (Boolean)DockingSelectorDialog.this.visibleViews.get(state);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object v, int row, int col) {
            DockableState state = this.states[row];
            DockingSelectorDialog.this.visibleViews.put(state, (Boolean)v);
        }
    }
}

