/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowMenu;
import org.omegat.gui.main.MainWindowMenuHandler;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBar
extends JToolBar
implements ActionListener,
IMarker,
IProjectEventListener {
    private static final Logger LOGGER = Logger.getLogger(ToolBar.class.getName());
    public static ToolBar INSTANCE = null;
    protected final MainWindowMenuHandler mainWindowMenuHandler;

    public ToolBar() {
        this((MainWindow)Core.getMainWindow());
    }

    public ToolBar(MainWindow parent) {
        this.addJToolBarButton(parent.menu, "projectNewMenuItem", "TF_MENU_FILE_CREATE", "filenew.png");
        this.addJToolBarButton(parent.menu, "projectOpenMenuItem", "TF_MENU_FILE_OPEN", "project_open.png");
        this.addJToolBarButton(parent.menu, "projectReloadMenuItem", "TF_MENU_PROJECT_RELOAD", "reload.png");
        this.addJToolBarButton(parent.menu, "projectCloseMenuItem", "TF_MENU_FILE_CLOSE", "fileclose.png");
        this.addSeparator();
        this.addJToolBarButton(parent.menu, "editUndoMenuItem", "TF_MENU_EDIT_UNDO", "undo.png");
        this.addJToolBarButton(parent.menu, "editRedoMenuItem", "TF_MENU_EDIT_REDO", "redo.png");
        this.addSeparator();
        this.addJToolBarButton(parent.menu, "editFindInProjectMenuItem", "TF_MENU_EDIT_FIND,TF_MENU_EDIT_FIND_PROJECT", "search.png");
        this.addJToolBarButton(parent.menu, "editReplaceInProjectMenuItem", "TF_MENU_EDIT_REPLACEALL,TF_MENU_EDIT_REPLACE", "replaceAll.png");
        this.addSeparator();
        this.addJToolBarButton(parent.menu, "gotoPreviousSegmentMenuItem", "TF_MENU_EDIT_PREV", "1uparrow.png");
        this.addJToolBarButton(parent.menu, "gotoNextSegmentMenuItem", "TF_MENU_EDIT_NEXT", "1downarrow.png");
        this.addJToolBarButton(parent.menu, "gotoNextUntranslatedMenuItem", "TF_MENU_EDIT_UNTRANS", "2downarrow.png");
        this.addSeparator();
        this.addJToolBarButton(parent.menu, "editOverwriteTranslationMenuItem", "TF_MENU_EDIT_RECYCLE", "eraser.png");
        this.addJToolBarButton(parent.menu, "editInsertTranslationMenuItem", "TF_MENU_EDIT_INSERT", "key_enter.png");
        this.addJToolBarButton(parent.menu, "editOverwriteMachineTranslationMenuItem", "TF_MENU_EDIT_OVERWRITE_MACHITE_TRANSLATION", "machinetrans.png");
        this.addSeparator();
        this.addJToolBarButton(parent.menu, "editTagPainterMenuItem", "TF_MENU_EDIT_TAGPAINT", "ins_tag.png");
        this.addJToolBarButton(parent.menu, "toolsValidateTagsMenuItem", "TF_MENU_TOOLS_VALIDATE", "validate_tag.png");
        this.addJToolBarButton(parent.menu, "revisionModeMenuItem", "TF_MENU_REVISION_MODE", "rev1.png");
        this.addSeparator();
        this.addJToolBarButton(parent.menu, "projectExitMenuItem", "TF_MENU_FILE_QUIT", "application-exit.png");
        parent.getContentPane().add((Component)this, "North");
        this.mainWindowMenuHandler = new MainWindowMenuHandler(parent);
        this.onProjectChanged(null);
        CoreEvents.registerProjectChangeListener((IProjectEventListener)this);
        INSTANCE = this;
    }

    private JMenuItem findMenu(MenuElement menu, String action) {
        for (MenuElement element : menu.getSubElements()) {
            if (element instanceof JMenuItem) {
                try {
                    String command;
                    JMenuItem item = (JMenuItem)element;
                    if (item != null && (command = item.getActionCommand()) != null && command.equals(action)) {
                        return item;
                    }
                }
                catch (ClassCastException classCastException) {}
                continue;
            }
            return this.findMenu(element, action);
        }
        return null;
    }

    private JMenuItem findMenu(MainWindowMenu menu, String action) {
        if (action.startsWith("project")) {
            return this.findMenu(menu.getProjectMenu(), action);
        }
        if (action.startsWith("edit")) {
            return this.findMenu((MenuElement)((Object)menu.editMultipleDefault.getParent()), action);
        }
        if (action.startsWith("tools")) {
            return this.findMenu(menu.getToolsMenu(), action);
        }
        if (action.startsWith("rev")) {
            return this.findMenu(menu.getOptionsMenu(), action);
        }
        return null;
    }

    private void addJToolBarButton(MainWindowMenu menu, String action, String tips, String iconLocation) {
        AbstractButton btn;
        URL resource16 = ToolBar.class.getResource("/org/omegat/gui/resources/x16/" + iconLocation);
        URL resource32 = ToolBar.class.getResource("/org/omegat/gui/resources/x32/" + iconLocation);
        JMenuItem item = this.findMenu(menu, action);
        if (item != null) {
            try {
                ImageIcon icon16 = new ImageIcon(resource16);
                item.setIcon(icon16);
            }
            catch (Exception icon16) {
                // empty catch block
            }
        }
        ImageIcon icon32 = new ImageIcon(resource32);
        if (item instanceof JCheckBoxMenuItem) {
            btn = new JToggleButton(icon32);
            btn.setSelected(false);
            btn.setModel(item.getModel());
        } else {
            btn = new JButton(icon32);
        }
        btn.setActionCommand(action);
        btn.addActionListener(this);
        this.add(btn);
        for (String tip : tips.split(",")) {
            try {
                btn.setToolTipText(OStrings.getString((String)tip).replaceAll("\\&", ""));
                return;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        AbstractButton menuItem = (AbstractButton)evt.getSource();
        String action = menuItem.getActionCommand();
        Log.logInfoRB((String)"LOG_MENU_CLICK", (Object[])new Object[]{action});
        String methodName = action + "ActionPerformed";
        Method method = null;
        try {
            method = this.mainWindowMenuHandler.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu: there is no method " + methodName);
        }
        try {
            method.invoke((Object)this.mainWindowMenuHandler, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.SEVERE, "Error execute method", ex);
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
    }

    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        boolean loaded = Core.getProject().isProjectLoaded();
        this.getComponentAtIndex(0).setEnabled(!loaded);
        this.getComponentAtIndex(1).setEnabled(!loaded);
        this.getComponentAtIndex(2).setEnabled(loaded);
        this.getComponentAtIndex(3).setEnabled(loaded);
        this.getComponentAtIndex(5).setEnabled(loaded);
        this.getComponentAtIndex(6).setEnabled(loaded);
        this.getComponentAtIndex(8).setEnabled(loaded);
        this.getComponentAtIndex(9).setEnabled(loaded);
        this.getComponentAtIndex(11).setEnabled(loaded);
        this.getComponentAtIndex(12).setEnabled(loaded);
        this.getComponentAtIndex(13).setEnabled(loaded);
        this.getComponentAtIndex(15).setEnabled(loaded);
        this.getComponentAtIndex(16).setEnabled(loaded);
        this.getComponentAtIndex(17).setEnabled(loaded);
        this.getComponentAtIndex(19).setEnabled(loaded);
        this.getComponentAtIndex(20).setEnabled(loaded);
    }

    public Highlighter.HighlightPainter getPainter() {
        return null;
    }

    public List<Mark> getMarksForEntry(String sourceText, String translationText, boolean isActive) throws Exception {
        return Collections.EMPTY_LIST;
    }

    public List<Mark> getMarksForEntry(SourceTextEntry entry, String sourceText, String translationText, boolean isActive) throws Exception {
        return Collections.EMPTY_LIST;
    }
}

