/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNObjectsPool;
import org.tmatesoft.svn.core.wc.SVNRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNEntryHashMap
extends SVNHashMap {
    private static final long serialVersionUID = 1L;
    private static final Set<String> ourNonPoolableKeys = new HashSet<String>();
    private static final Set<String> ourURLKeys = new HashSet<String>();
    private SVNObjectsPool myObjectsPool;

    public SVNEntryHashMap(SVNObjectsPool pool) {
        this(null, pool);
    }

    public SVNEntryHashMap(Map<?, ?> map, SVNObjectsPool pool) {
        this.myObjectsPool = pool;
        this.init();
        this.putAll(map);
    }

    @Override
    public Object put(Object key, Object value) {
        key = this.getObjectFromPool(key);
        return super.put(key, value);
    }

    @Override
    protected SVNHashMap.TableEntry createTableEntry(Object key, Object value, int hash) {
        return new PooledTableEntry(this.myObjectsPool, key, value, hash);
    }

    private Object getObjectFromPool(Object value) {
        if (this.myObjectsPool != null) {
            return this.myObjectsPool.getObject(value);
        }
        return value;
    }

    private static boolean isNonPoolableKey(Object key) {
        return ourNonPoolableKeys.contains(key);
    }

    private static boolean isURLKey(Object key) {
        return ourURLKeys.contains(key);
    }

    private static Object[] split(String url) {
        ArrayList<String> segments = new ArrayList<String>();
        int startIndex = 0;
        int count = 0;
        for (int i = 0; i < url.length(); ++i) {
            char ch = url.charAt(i);
            if (ch == '/' || i <= 0 || url.charAt(i - 1) != '/' || ++count <= 3) continue;
            segments.add(url.substring(startIndex, i));
            startIndex = i;
        }
        if (startIndex < url.length()) {
            segments.add(url.substring(startIndex));
        }
        return segments.toArray();
    }

    static {
        ourNonPoolableKeys.add("svn:entry:checksum");
        ourNonPoolableKeys.add("svn:entry:committed-date");
        ourNonPoolableKeys.add("svn:entry:text-time");
        ourNonPoolableKeys.add("svn:entry:working-size");
        ourNonPoolableKeys.add("svn:entry:lock-creation-date");
        ourNonPoolableKeys.add("svn:entry:prop-time");
        ourURLKeys.add("svn:entry:url");
        ourURLKeys.add("svn:entry:copyfrom-url");
        ourURLKeys.add("svn:entry:file-external-path");
        ourURLKeys.add("svn:entry:repos");
    }

    private static class StringAsArray {
        private Object[] segments;
        private int hashCode;

        public StringAsArray(String str, SVNObjectsPool pool) {
            this.hashCode = str.hashCode();
            this.segments = SVNEntryHashMap.split(str);
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = pool.getObject(this.segments[i]);
            }
        }

        public boolean equals(Object other) {
            if (other instanceof StringAsArray) {
                return Arrays.equals(this.segments, ((StringAsArray)other).segments);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < this.segments.length; ++i) {
                str.append((String)this.segments[i]);
            }
            return str.toString();
        }
    }

    protected static class PooledTableEntry
    extends SVNHashMap.TableEntry {
        private SVNObjectsPool myObjectsPool;

        public PooledTableEntry(SVNObjectsPool pool, Object key, Object value, int hash) {
            this.myObjectsPool = pool;
            this.init(key, value, hash);
        }

        public Object setValue(Object value) {
            Object valueForPool = this.getPoolValue(super.getKey(), value);
            return super.setValue(valueForPool);
        }

        public Object getValue() {
            return this.getRealValue(super.getValue());
        }

        private Object getRealValue(Object value) {
            if (value instanceof StringAsArray) {
                return ((StringAsArray)value).toString();
            }
            return value;
        }

        private Object getPoolValue(Object key, Object value) {
            if (this.myObjectsPool != null) {
                if (value instanceof String) {
                    if (SVNEntryHashMap.isURLKey(key)) {
                        return new StringAsArray((String)value, this.myObjectsPool);
                    }
                    if (!SVNEntryHashMap.isNonPoolableKey(key)) {
                        return this.myObjectsPool.getObject(value);
                    }
                    return value;
                }
                if (value instanceof String[]) {
                    String[] array = (String[])value;
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = (String)this.myObjectsPool.getObject(array[i]);
                    }
                } else if (value instanceof SVNRevision) {
                    return this.myObjectsPool.getObject(value);
                }
            }
            return value;
        }
    }
}

